/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.main.networking;

import com.wildfire.main.GenderPlayer;
import com.wildfire.main.WildfireGender;
import com.wildfire.main.networking.PacketSync;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public class PacketSendGenderInfo {
    private final String uuid;
    private final int gender;
    private final float bust_size;
    private final String capeURL;
    private final boolean breast_physics;
    private final boolean breast_physics_armor;
    private final float bounceMultiplier;
    private final float floppyMultiplier;
    private final boolean hurtSounds;

    public PacketSendGenderInfo(GenderPlayer plr) {
        this.uuid = plr.username;
        this.gender = plr.gender;
        this.bust_size = plr.getBustSize();
        this.capeURL = plr.capeURL;
        this.hurtSounds = plr.hurtSounds;
        this.breast_physics = plr.breast_physics;
        this.breast_physics_armor = plr.breast_physics_armor;
        this.bounceMultiplier = plr.bounceMultiplier;
        this.floppyMultiplier = plr.floppyMultiplier;
    }

    public PacketSendGenderInfo(FriendlyByteBuf buffer) {
        this.uuid = buffer.m_130136_(36);
        this.gender = buffer.readInt();
        this.bust_size = buffer.readFloat();
        this.hurtSounds = buffer.readBoolean();
        this.breast_physics = buffer.readBoolean();
        this.breast_physics_armor = buffer.readBoolean();
        this.bounceMultiplier = buffer.readFloat();
        this.floppyMultiplier = buffer.readFloat();
        this.capeURL = buffer.m_130136_(250);
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.uuid);
        buffer.writeInt(this.gender);
        buffer.writeFloat(this.bust_size);
        buffer.writeBoolean(this.hurtSounds);
        buffer.writeBoolean(this.breast_physics);
        buffer.writeBoolean(this.breast_physics_armor);
        buffer.writeFloat(this.bounceMultiplier);
        buffer.writeFloat(this.floppyMultiplier);
        buffer.m_130070_(this.capeURL);
    }

    public static void handle(PacketSendGenderInfo packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            if (!player.m_142081_().toString().equals(packet.uuid)) {
                return;
            }
            GenderPlayer plr = WildfireGender.getPlayerByName(packet.uuid);
            if (plr == null) {
                plr = new GenderPlayer(packet.uuid);
                WildfireGender.CLOTHING_PLAYER.add(plr);
            }
            plr.gender = packet.gender;
            plr.updateBustSize(packet.bust_size);
            plr.capeURL = packet.capeURL;
            plr.hurtSounds = packet.hurtSounds;
            plr.breast_physics = packet.breast_physics;
            plr.breast_physics_armor = packet.breast_physics_armor;
            plr.bounceMultiplier = packet.bounceMultiplier;
            plr.floppyMultiplier = packet.floppyMultiplier;
            try {
                List PLAYERS = player.m_20194_().m_6846_().m_11314_();
                for (ServerPlayer sPlayer : PLAYERS) {
                    PacketSync.send(player, WildfireGender.getPlayerByName(sPlayer.m_142081_().toString()));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        context.get().setPacketHandled(true);
    }

    public static void send(GenderPlayer plr) {
        if (plr == null) {
            return;
        }
        WildfireGender.NETWORK.sendToServer((Object)new PacketSendGenderInfo(plr));
    }
}

