/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.main.networking;

import com.wildfire.main.GenderPlayer;
import com.wildfire.main.WildfireGender;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import net.minecraftforge.fmllegacy.network.PacketDistributor;

public class PacketSync {
    private final String uuid;
    private final int gender;
    private final float bust_size;
    private final String capeURL;
    private final boolean breast_physics;
    private final boolean breast_physics_armor;
    private final float bounceMultiplier;
    private final float floppyMultiplier;
    private final boolean hurtSounds;

    public PacketSync(GenderPlayer plr) {
        this.uuid = plr.username;
        this.gender = plr.gender;
        this.bust_size = plr.getBustSize();
        this.capeURL = plr.capeURL;
        this.hurtSounds = plr.hurtSounds;
        this.breast_physics = plr.breast_physics;
        this.breast_physics_armor = plr.breast_physics_armor;
        this.bounceMultiplier = plr.bounceMultiplier;
        this.floppyMultiplier = plr.floppyMultiplier;
    }

    public PacketSync(FriendlyByteBuf buffer) {
        this.uuid = buffer.m_130136_(36);
        this.gender = buffer.readInt();
        this.bust_size = buffer.readFloat();
        this.capeURL = buffer.m_130136_(250);
        this.hurtSounds = buffer.readBoolean();
        this.breast_physics = buffer.readBoolean();
        this.breast_physics_armor = buffer.readBoolean();
        this.bounceMultiplier = buffer.readFloat();
        this.floppyMultiplier = buffer.readFloat();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.uuid);
        buffer.writeInt(this.gender);
        buffer.writeFloat(this.bust_size);
        buffer.m_130070_(this.capeURL);
        buffer.writeBoolean(this.hurtSounds);
        buffer.writeBoolean(this.breast_physics);
        buffer.writeBoolean(this.breast_physics_armor);
        buffer.writeFloat(this.bounceMultiplier);
        buffer.writeFloat(this.floppyMultiplier);
    }

    public static void handle(PacketSync packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            GenderPlayer plr;
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            if (!packet.uuid.equals(Minecraft.m_91087_().f_91074_.m_142081_().toString()) && (plr = WildfireGender.getPlayerByName(packet.uuid)) != null) {
                plr.gender = packet.gender;
                plr.updateBustSize(packet.bust_size);
                plr.capeURL = packet.capeURL;
                plr.hurtSounds = packet.hurtSounds;
                plr.breast_physics = packet.breast_physics;
                plr.breast_physics_armor = packet.breast_physics_armor;
                plr.bounceMultiplier = packet.bounceMultiplier;
                plr.floppyMultiplier = packet.floppyMultiplier;
                plr.syncStatus = GenderPlayer.SyncStatus.SYNCED;
                plr.lockSettings = true;
            }
        });
        context.get().setPacketHandled(true);
    }

    public static void send(ServerPlayer player, GenderPlayer plr) {
        if (plr == null) {
            return;
        }
        PacketSync syncPacket = new PacketSync(plr);
        WildfireGender.NETWORK.send(PacketDistributor.PLAYER.with(() -> player), (Object)syncPacket);
    }
}

