/*
 * Decompiled with CFR 0.152.
 */
package com.wildfire.render;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import com.wildfire.main.GenderPlayer;
import com.wildfire.main.WildfireGender;
import com.wildfire.render.WildfireModelRenderer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.client.ForgeHooksClient;

public class GenderLayer
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    private WildfireModelRenderer.ModelBox chest = new WildfireModelRenderer.ModelBox(64, 64, 16, 17, -4.0f, 0.0f, 0.0f, 8, 5, 4, 0.0f, false);
    private WildfireModelRenderer.ModelBox chestwear = new WildfireModelRenderer.ModelBox(64, 64, 17, 34, -4.0f, 0.0f, 0.0f, 8, 5, 3, 0.0f, false);
    private WildfireModelRenderer.ModelBox sBox = new WildfireModelRenderer.ModelBox(64, 32, 17, 19, -4.0f, 0.0f, 0.0f, 8, 5, 3, 0.0f, false);
    protected static final ResourceLocation ENCHANTED_ITEM_GLINT_RES = new ResourceLocation("textures/misc/enchanted_item_glint.png");

    public GenderLayer(RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> player) {
        super(player);
    }

    public ResourceLocation getArmorResource(Entity entity, ItemStack stack, EquipmentSlot slot, @Nullable String type) {
        ArmorItem item = (ArmorItem)stack.m_41720_();
        String texture = item.m_40401_().m_6082_();
        String domain = "minecraft";
        int idx = texture.indexOf(58);
        if (idx != -1) {
            domain = texture.substring(0, idx);
            texture = texture.substring(idx + 1);
        }
        String s1 = String.format("%s:textures/models/armor/%s_layer_%d%s.png", domain, texture, 1, type == null ? "" : String.format("_%s", type));
        s1 = ForgeHooksClient.getArmorTexture((Entity)entity, (ItemStack)stack, (String)s1, (EquipmentSlot)slot, (String)type);
        ResourceLocation resourcelocation = null;
        if (resourcelocation == null) {
            resourcelocation = new ResourceLocation(s1);
        }
        return resourcelocation;
    }

    public boolean shouldCombineTextures() {
        return true;
    }

    public void render(PoseStack matrixStack, MultiBufferSource bufferIn, int packedLightIn, AbstractClientPlayer ent, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (WildfireGender.modEnabled) {
            AbstractClientPlayer aPlr = ent;
            String playerName = Player.m_36198_((GameProfile)ent.m_36316_()).toString();
            GenderPlayer plr = WildfireGender.getPlayerByName(playerName);
            PlayerRenderer rend = (PlayerRenderer)Minecraft.m_91087_().m_91290_().m_114382_((Entity)ent);
            PlayerModel model = (PlayerModel)rend.m_7200_();
            if (plr != null) {
                boolean bounceEnabled;
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                float preBounce = plr.getBreastPhysics().getPreBounceY();
                float breastBounce = plr.getBreastPhysics().getBounceY();
                float total = Mth.m_14179_((float)partialTicks, (float)preBounce, (float)breastBounce);
                float breastBounceX = plr.getBreastPhysics().getBounceX();
                float preBounceX = plr.getBreastPhysics().getPreBounceX();
                float totalX = Mth.m_14179_((float)partialTicks, (float)preBounceX, (float)breastBounceX);
                float breastBounceRot = plr.getBreastPhysics().getBounceRotation();
                float preBounceRot = plr.getBreastPhysics().getPreBounceRotation();
                float bounceRotation = Mth.m_14179_((float)partialTicks, (float)preBounceRot, (float)breastBounceRot);
                float breastSize = plr.getBreastPhysics().getBreastSize(partialTicks);
                if (breastSize < 0.02f) {
                    return;
                }
                boolean isChestplateOccupied = !ent.m_6844_(EquipmentSlot.CHEST).equals(new ItemStack((ItemLike)Items.f_42741_, 1), true) && !ent.m_6844_(EquipmentSlot.CHEST).equals(new ItemStack((ItemLike)Items.f_41852_, 1), true);
                boolean teamSeeFriendly = false;
                if (ent.m_5647_() != null) {
                    teamSeeFriendly = ent.m_5647_().m_6259_();
                }
                boolean breathingAnimation = true;
                this.pushMatrix(matrixStack, model.f_102810_, 0.0f);
                float rotationMultiplier = 0.0f;
                boolean bl = bounceEnabled = plr.breast_physics && !isChestplateOccupied || plr.breast_physics && plr.breast_physics_armor && isChestplateOccupied;
                if (bounceEnabled) {
                    matrixStack.m_85837_((double)(totalX / 32.0f), 0.0, 0.0);
                    matrixStack.m_85837_(0.0, (double)(total / 32.0f), 0.0);
                }
                matrixStack.m_85837_(0.0, (double)0.05625f, -0.125);
                if (bounceEnabled) {
                    matrixStack.m_85837_(0.0, (double)(-0.035f * breastSize), 0.0);
                    rotationMultiplier = -total / 12.0f;
                }
                float totalRotation = breastSize + rotationMultiplier;
                if (!bounceEnabled) {
                    totalRotation = breastSize;
                }
                if (totalRotation > breastSize + 0.2f) {
                    totalRotation = breastSize + 0.2f;
                }
                if (totalRotation > 1.0f) {
                    totalRotation = 1.0f;
                }
                if (isChestplateOccupied) {
                    matrixStack.m_85837_(0.0, 0.0, (double)0.01f);
                }
                if (bounceEnabled) {
                    matrixStack.m_85845_(new Quaternion(0.0f, bounceRotation, 0.0f, true));
                }
                matrixStack.m_85845_(new Quaternion(-35.0f * totalRotation, 0.0f, 0.0f, true));
                float f = 1.0f;
                f = (float)ent.m_20184_().m_82556_();
                f /= 0.2f;
                f = f * f * f;
                if (f < 1.0f) {
                    f = 1.0f;
                }
                if (!isChestplateOccupied && breathingAnimation) {
                    float f5 = -Mth.m_14089_((float)(ageInTicks * 0.09f)) * 0.45f + 0.45f;
                    matrixStack.m_85845_(new Quaternion(f5, 0.0f, 0.0f, true));
                }
                int combineTex = LivingEntityRenderer.m_115338_((LivingEntity)ent, (float)0.0f);
                RenderType type = RenderType.m_110473_((ResourceLocation)rend.m_5478_(ent));
                VertexConsumer ivertexbuilder = bufferIn.m_6299_(type);
                matrixStack.m_85841_(0.9995f, 1.0f, 1.0f);
                if (teamSeeFriendly && ent.m_20145_() || !ent.m_20145_()) {
                    GenderLayer.renderBox(this.chest, matrixStack, ivertexbuilder, packedLightIn, combineTex, 1.0f, 1.0f, 1.0f, this.getTransparency(ent));
                    if (ent.m_36170_(PlayerModelPart.JACKET)) {
                        matrixStack.m_85837_(0.0, 0.0, (double)-0.015f);
                        matrixStack.m_85841_(1.05f, 1.05f, 1.05f);
                        GenderLayer.renderBox(this.chestwear, matrixStack, ivertexbuilder, packedLightIn, combineTex, 1.0f, 1.0f, 1.0f, this.getTransparency(ent));
                    }
                }
                if (!ent.m_150109_().m_36052_(2).equals(new ItemStack((ItemLike)Items.f_41852_, 1), true)) {
                    ItemStack itemstack = ent.m_150109_().m_36052_(2);
                    ResourceLocation ARMOR_TXTR = this.getArmorResource((Entity)ent, ent.m_150109_().m_36052_(2), EquipmentSlot.CHEST, null);
                    if (ARMOR_TXTR != null && itemstack.m_41720_() instanceof ArmorItem) {
                        matrixStack.m_85836_();
                        float armorR = 1.0f;
                        float armorG = 1.0f;
                        float armorB = 1.0f;
                        if (!(itemstack.m_41720_() instanceof ElytraItem)) {
                            ArmorItem armoritem = (ArmorItem)itemstack.m_41720_();
                            if (armoritem instanceof DyeableLeatherItem) {
                                int i = ((DyeableLeatherItem)armoritem).m_41121_(itemstack);
                                armorR = (float)(i >> 16 & 0xFF) / 255.0f;
                                armorG = (float)(i >> 8 & 0xFF) / 255.0f;
                                armorB = (float)(i & 0xFF) / 255.0f;
                            }
                            matrixStack.m_85837_(0.0, (double)0.015f, (double)-0.015f);
                            matrixStack.m_85841_(1.05f, 1.0f, 1.0f);
                            VertexConsumer vertexconsumer = ItemRenderer.m_115184_((MultiBufferSource)bufferIn, (RenderType)RenderType.m_110431_((ResourceLocation)ARMOR_TXTR), (boolean)false, (boolean)ent.m_150109_().m_36052_(2).m_41793_());
                            GenderLayer.renderBox(this.sBox, matrixStack, vertexconsumer, packedLightIn, 0xFFFFFF, armorR, armorG, armorB, this.getTransparency(ent));
                            matrixStack.m_85849_();
                        }
                    }
                }
                matrixStack.m_85849_();
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
    }

    protected void unsetBrightness() {
    }

    public void pushMatrix(PoseStack m, ModelPart mdl, float f7) {
        float rPointX = mdl.f_104200_;
        float rPointY = mdl.f_104201_;
        float rPointZ = mdl.f_104202_;
        float rAngleX = mdl.f_104203_;
        float rAngleY = mdl.f_104204_;
        float rAngleZ = mdl.f_104205_;
        m.m_85836_();
        m.m_85837_((double)(rPointX * 0.0625f), (double)(rPointY * 0.0625f), (double)(rPointZ * 0.0625f));
        if (rAngleZ != 0.0f) {
            m.m_85845_(new Quaternion(0.0f, 0.0f, rAngleZ, false));
        }
        if (rAngleY != 0.0f) {
            m.m_85845_(new Quaternion(0.0f, rAngleY, 0.0f, false));
        }
        if (rAngleX != 0.0f) {
            m.m_85845_(new Quaternion(rAngleX, 0.0f, 0.0f, false));
        }
    }

    public float getTransparency(AbstractClientPlayer ent) {
        boolean flag1;
        float alphaChannel = 1.0f;
        boolean bl = flag1 = ent.m_20145_() && !ent.m_20177_((Player)Minecraft.m_91087_().f_91074_);
        if (flag1) {
            alphaChannel = 0.15f;
        } else if (ent.m_20145_()) {
            alphaChannel = 0.0f;
        }
        return alphaChannel;
    }

    public static void renderBox(WildfireModelRenderer.ModelBox box, PoseStack matrixEntryIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        matrixEntryIn.m_85836_();
        Matrix4f matrix4f = matrixEntryIn.m_85850_().m_85861_();
        Matrix3f matrix3f = matrixEntryIn.m_85850_().m_85864_();
        for (WildfireModelRenderer.TexturedQuad modelrenderer$texturedquad : box.quads) {
            Vector3f vector3f = modelrenderer$texturedquad.normal.m_122281_();
            vector3f.m_122249_(matrix3f);
            float f = vector3f.m_122239_();
            float f1 = vector3f.m_122260_();
            float f2 = vector3f.m_122269_();
            for (int i = 0; i < 4; ++i) {
                WildfireModelRenderer.PositionTextureVertex modelrenderer$positiontexturevertex = modelrenderer$texturedquad.vertexPositions[i];
                float f3 = modelrenderer$positiontexturevertex.vector3D.m_122239_() / 16.0f;
                float f4 = modelrenderer$positiontexturevertex.vector3D.m_122260_() / 16.0f;
                float f5 = modelrenderer$positiontexturevertex.vector3D.m_122269_() / 16.0f;
                Vector4f vector4f = new Vector4f(f3, f4, f5, 1.0f);
                vector4f.m_123607_(matrix4f);
                bufferIn.m_5954_(vector4f.m_123601_(), vector4f.m_123615_(), vector4f.m_123616_(), red, green, blue, alpha, modelrenderer$positiontexturevertex.texturePositionX, modelrenderer$positiontexturevertex.texturePositionY, packedOverlayIn, packedLightIn, f, f1, f2);
            }
        }
        matrixEntryIn.m_85849_();
    }
}

