/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.montoyo.wd.WebDisplays;
import net.montoyo.wd.net.client.CMessageAchievement;
import net.montoyo.wd.utilities.Log;
import net.montoyo.wd.utilities.Util;

public class AchievementManager {
    private static File FILE;
    private static final HashMap<UUID, Boolean> MAP;

    public static void init(File saveDir) {
        FILE = new File(saveDir, "wd_achievements.bin");
        if (FILE.exists()) {
            try {
                DataInputStream dis = new DataInputStream(new FileInputStream(FILE));
                int numEntries = dis.readInt();
                MAP.clear();
                for (int i = 0; i < numEntries; ++i) {
                    long msb = dis.readLong();
                    long lsb = dis.readLong();
                    MAP.put(new UUID(msb, lsb), true);
                }
                Util.silentClose(dis);
            }
            catch (IOException ex) {
                Log.warningEx("Couldn't load player achievements", ex, new Object[0]);
            }
        }
    }

    public static void saveAchievements() {
        if (FILE == null) {
            return;
        }
        try {
            DataOutputStream dos = new DataOutputStream(new FileOutputStream(FILE));
            int count = 0;
            for (Map.Entry<UUID, Boolean> entry : MAP.entrySet()) {
                if (!entry.getValue().booleanValue()) continue;
                ++count;
            }
            dos.writeInt(count);
            for (Map.Entry<UUID, Boolean> entry : MAP.entrySet()) {
                if (!entry.getValue().booleanValue()) continue;
                dos.writeLong(entry.getKey().getMostSignificantBits());
                dos.writeLong(entry.getKey().getLeastSignificantBits());
            }
            Util.silentClose(dos);
        }
        catch (IOException ex) {
            Log.warningEx("Couldn't save player achievements", ex, new Object[0]);
        }
    }

    public static void giveAchievement(EntityPlayerMP player) {
        UUID uuid = player.func_146103_bH().getId();
        if (!MAP.getOrDefault(uuid, false).booleanValue()) {
            MAP.put(uuid, true);
            AchievementManager.saveAchievements();
            WebDisplays.NET_HANDLER.sendTo((IMessage)new CMessageAchievement(true), player);
        }
    }

    public static void revokeAchievement(EntityPlayerMP player) {
        UUID uuid = player.func_146103_bH().getId();
        if (MAP.getOrDefault(uuid, false).booleanValue()) {
            MAP.put(uuid, false);
            AchievementManager.saveAchievements();
            WebDisplays.NET_HANDLER.sendTo((IMessage)new CMessageAchievement(false), player);
        }
    }

    public static boolean doesPlayerHaveAchievement(EntityPlayer ply) {
        return MAP.getOrDefault(ply.func_146103_bH().getId(), false);
    }

    static {
        MAP = new HashMap();
    }
}

