/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.block;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.montoyo.wd.WebDisplays;
import net.montoyo.wd.block.BlockKeyboardRight;
import net.montoyo.wd.block.WDBlockContainer;
import net.montoyo.wd.core.DefaultPeripheral;
import net.montoyo.wd.entity.TileEntityKeyboard;
import net.montoyo.wd.entity.TileEntityOCInterface;
import net.montoyo.wd.entity.TileEntityPeripheralBase;
import net.montoyo.wd.entity.TileEntityServer;
import net.montoyo.wd.item.ItemLinker;
import net.montoyo.wd.item.ItemPeripheral;
import net.montoyo.wd.net.client.CMessageCloseGui;
import net.montoyo.wd.utilities.BlockSide;
import net.montoyo.wd.utilities.Log;

public class BlockPeripheral
extends WDBlockContainer {
    public static final PropertyEnum<DefaultPeripheral> type = PropertyEnum.func_177709_a((String)"type", DefaultPeripheral.class);
    public static final PropertyInteger facing = PropertyInteger.func_177719_a((String)"facing", (int)0, (int)3);
    private static final IProperty[] properties = new IProperty[]{type, facing};

    public BlockPeripheral() {
        super(Material.field_151576_e);
        this.func_149711_c(1.5f);
        this.func_149752_b(10.0f);
        this.func_149647_a(WebDisplays.CREATIVE_TAB);
        this.setName("peripheral");
    }

    @Override
    protected ItemBlock createItemBlock() {
        return new ItemPeripheral((Block)this);
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, properties);
    }

    @Nonnull
    public IBlockState getStateForPlacement(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing nocare, float hitX, float hitY, float hitZ, int meta, @Nonnull EntityLivingBase placer, ItemStack stack) {
        int rot = MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 2.5)) & 3;
        return this.func_176223_P().func_177226_a(type, (Comparable)((Object)DefaultPeripheral.fromMetadata(meta))).func_177226_a((IProperty)facing, (Comparable)Integer.valueOf(rot));
    }

    public void func_149666_a(@Nonnull Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        for (DefaultPeripheral dp : DefaultPeripheral.values()) {
            list.add(new ItemStack((Item)this.getItem(), 1, dp.toMetadata(0)));
        }
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        DefaultPeripheral dp = DefaultPeripheral.fromMetadata(meta);
        IBlockState state = this.func_176223_P().func_177226_a(type, (Comparable)((Object)dp));
        if (dp.hasFacing()) {
            state = state.func_177226_a((IProperty)facing, (Comparable)Integer.valueOf(meta >> 2 & 3));
        }
        return state;
    }

    public int func_176201_c(IBlockState state) {
        return ((DefaultPeripheral)((Object)state.func_177229_b(type))).toMetadata((Integer)state.func_177229_b((IProperty)facing));
    }

    @Nullable
    public TileEntity func_149915_a(@Nonnull World world, int meta) {
        Class<? extends TileEntity> cls = DefaultPeripheral.fromMetadata(meta).getTEClass();
        if (cls == null) {
            return null;
        }
        try {
            return cls.newInstance();
        }
        catch (Throwable t) {
            Log.errorEx("Couldn't instantiate peripheral TileEntity:", t, new Object[0]);
            return null;
        }
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public int func_180651_a(IBlockState state) {
        return ((DefaultPeripheral)((Object)state.func_177229_b(type))).toMetadata(0);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            return false;
        }
        if (heldItem != null && heldItem.func_77973_b() instanceof ItemLinker) {
            return false;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityPeripheralBase) {
            return ((TileEntityPeripheralBase)te).onRightClick(player, hand, BlockSide.values()[facing.ordinal()]);
        }
        if (te instanceof TileEntityServer) {
            ((TileEntityServer)te).onPlayerRightClick(player);
            return true;
        }
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return state.func_177229_b(type) != DefaultPeripheral.KEYBOARD;
    }

    public boolean func_149730_j(IBlockState state) {
        return state.func_177229_b(type) != DefaultPeripheral.KEYBOARD;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state.func_177229_b(type) != DefaultPeripheral.KEYBOARD;
    }

    public boolean func_149662_c(IBlockState state) {
        return state.func_177229_b(type) != DefaultPeripheral.KEYBOARD;
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return state.func_177229_b(type) != DefaultPeripheral.KEYBOARD;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return state.func_177229_b(type) == DefaultPeripheral.KEYBOARD ? BlockKeyboardRight.KEYBOARD_AABB : field_185505_j;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (world.field_72995_K) {
            return;
        }
        if (state.func_177229_b(type) == DefaultPeripheral.KEYBOARD) {
            int f = (Integer)state.func_177229_b((IProperty)facing);
            Vec3i dir = EnumFacing.func_176731_b((int)f).func_176746_e().func_176730_m();
            BlockPos left = pos.func_177971_a(dir);
            BlockPos right = pos.func_177973_b(dir);
            if (!world.func_175623_d(pos.func_177977_b()) && BlockKeyboardRight.checkNeighborhood((IBlockAccess)world, pos, null)) {
                if (world.func_175623_d(right) && !world.func_175623_d(right.func_177977_b()) && BlockKeyboardRight.checkNeighborhood((IBlockAccess)world, right, pos)) {
                    world.func_175656_a(right, WebDisplays.INSTANCE.blockKbRight.func_176223_P().func_177226_a((IProperty)BlockKeyboardRight.facing, (Comparable)Integer.valueOf(f)));
                    return;
                }
                if (world.func_175623_d(left) && !world.func_175623_d(left.func_177977_b()) && BlockKeyboardRight.checkNeighborhood((IBlockAccess)world, left, pos)) {
                    world.func_175656_a(left, state);
                    world.func_175656_a(pos, WebDisplays.INSTANCE.blockKbRight.func_176223_P().func_177226_a((IProperty)BlockKeyboardRight.facing, (Comparable)Integer.valueOf(f)));
                    return;
                }
            }
            world.func_175698_g(pos);
            if (!(placer instanceof EntityPlayer) || !((EntityPlayer)placer).func_184812_l_()) {
                this.func_176226_b(world, pos, state, 0);
            }
        } else if (placer instanceof EntityPlayer) {
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof TileEntityServer) {
                ((TileEntityServer)te).setOwner((EntityPlayer)placer);
            } else if (te instanceof TileEntityOCInterface) {
                ((TileEntityOCInterface)te).setOwner((EntityPlayer)placer);
            }
        }
    }

    @Nonnull
    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.IGNORE;
    }

    private void removeRightPiece(World world, BlockPos pos) {
        for (EnumFacing nf : EnumFacing.field_176754_o) {
            BlockPos np = pos.func_177971_a(nf.func_176730_m());
            if (!(world.func_180495_p(np).func_177230_c() instanceof BlockKeyboardRight)) continue;
            world.func_175698_g(np);
            break;
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockThatChanged) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileEntityPeripheralBase) {
            ((TileEntityPeripheralBase)te).onNeighborChange();
        }
        if (world.field_72995_K || state.func_177229_b(type) != DefaultPeripheral.KEYBOARD) {
            return;
        }
        if (world.func_175623_d(pos.func_177977_b())) {
            this.removeRightPiece(world, pos);
            world.func_175698_g(pos);
            this.func_176226_b(world, pos, state, 0);
            WebDisplays.NET_HANDLER.sendToAllAround((IMessage)new CMessageCloseGui(pos), BlockPeripheral.point(world, pos));
        }
    }

    public void func_176206_d(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            if (state.func_177230_c() == this && state.func_177229_b(type) == DefaultPeripheral.KEYBOARD) {
                this.removeRightPiece(world, pos);
            }
            WebDisplays.NET_HANDLER.sendToAllAround((IMessage)new CMessageCloseGui(pos), BlockPeripheral.point(world, pos));
        }
    }

    public void func_180652_a(World world, BlockPos pos, Explosion explosion) {
        this.func_176206_d(world, pos, world.func_180495_p(pos));
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        TileEntity te;
        double rpos;
        if (!world.field_72995_K && world.func_180495_p(pos).func_177229_b(type) == DefaultPeripheral.KEYBOARD && (rpos = (entity.field_70163_u - (double)pos.func_177956_o()) * 16.0) >= 1.0 && rpos <= 2.0 && Math.random() < 0.25 && (te = world.func_175625_s(pos)) != null && te instanceof TileEntityKeyboard) {
            ((TileEntityKeyboard)te).simulateCat(entity);
        }
    }

    private static NetworkRegistry.TargetPoint point(World world, BlockPos bp) {
        return new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)bp.func_177958_n(), (double)bp.func_177956_o(), (double)bp.func_177952_p(), 64.0);
    }
}

