/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.client.gui;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.annotation.Nullable;
import javax.swing.filechooser.FileSystemView;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.montoyo.wd.WebDisplays;
import net.montoyo.wd.client.gui.CommandHandler;
import net.montoyo.wd.client.gui.WDScreen;
import net.montoyo.wd.miniserv.client.Client;
import net.montoyo.wd.miniserv.client.ClientTask;
import net.montoyo.wd.miniserv.client.ClientTaskCheckFile;
import net.montoyo.wd.miniserv.client.ClientTaskDeleteFile;
import net.montoyo.wd.miniserv.client.ClientTaskGetFileList;
import net.montoyo.wd.miniserv.client.ClientTaskGetQuota;
import net.montoyo.wd.miniserv.client.ClientTaskUploadFile;
import net.montoyo.wd.utilities.BlockSide;
import net.montoyo.wd.utilities.Log;
import net.montoyo.wd.utilities.NameUUIDPair;
import net.montoyo.wd.utilities.Util;
import net.montoyo.wd.utilities.Vector3i;
import org.lwjgl.input.Keyboard;

public class GuiServer
extends WDScreen {
    private static final ResourceLocation BG_IMAGE = new ResourceLocation("webdisplays", "textures/gui/server_bg.png");
    private static final ResourceLocation FG_IMAGE = new ResourceLocation("webdisplays", "textures/gui/server_fg.png");
    private static final HashMap<String, Method> COMMAND_MAP = new HashMap();
    private static final int MAX_LINE_LEN = 32;
    private static final int MAX_LINES = 12;
    private final Vector3i serverPos;
    private final NameUUIDPair owner;
    private final ArrayList<String> lines = new ArrayList();
    private String prompt = "";
    private String userPrompt;
    private int blinkTime;
    private String lastCmd;
    private boolean promptLocked;
    private volatile long queryTime;
    private ClientTask<?> currentTask;
    private int selectedLine = -1;
    private int accessTrials;
    private int accessTime;
    private int accessState = -1;
    private PositionedSoundRecord accessSound;
    private boolean uploadWizard;
    private File uploadDir;
    private final ArrayList<File> uploadFiles = new ArrayList();
    private int uploadOffset;
    private boolean uploadFirstIsParent;
    private String uploadFilter = "";
    private long uploadFilterTime;

    public GuiServer(Vector3i vec, NameUUIDPair owner) {
        this.serverPos = vec;
        this.owner = owner;
        this.userPrompt = "> ";
        if (COMMAND_MAP.isEmpty()) {
            GuiServer.buildCommandMap();
        }
        this.lines.add("MiniServ 1.0");
        this.lines.add(GuiServer.tr("info", new Object[0]));
        this.uploadCD(FileSystemView.getFileSystemView().getDefaultDirectory());
    }

    private static String tr(String key, Object ... args) {
        return I18n.func_135052_a((String)("webdisplays.server." + key), (Object[])args);
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float ptt) {
        super.func_73863_a(mouseX, mouseY, ptt);
        int x = (this.field_146294_l - 256) / 2;
        int y = (this.field_146295_m - 176) / 2;
        GlStateManager.func_179098_w();
        this.field_146297_k.field_71446_o.func_110577_a(BG_IMAGE);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(x, y, 0, 0, 256, 176);
        x += 18;
        y += 18;
        for (int i = 0; i < this.lines.size(); ++i) {
            if (this.selectedLine == i) {
                this.drawWhiteQuad(x - 1, y - 2, this.field_146289_q.func_78256_a(this.lines.get(i)) + 1, 12);
                this.field_146289_q.func_175065_a(this.lines.get(i), (float)x, (float)y, -15558912, false);
            } else {
                this.field_146289_q.func_175065_a(this.lines.get(i), (float)x, (float)y, -1, false);
            }
            y += 12;
        }
        if (!this.promptLocked) {
            x = this.field_146289_q.func_175065_a(this.userPrompt, (float)x, (float)y, -1, false);
            x = this.field_146289_q.func_175065_a(this.prompt, (float)x, (float)y, -1, false);
        }
        if (!this.uploadWizard && this.blinkTime < 5) {
            this.drawWhiteQuad(x + 1, y, 6, 8);
        }
        GlStateManager.func_179118_c();
        GlStateManager.func_179098_w();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        this.field_146297_k.field_71446_o.func_110577_a(FG_IMAGE);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b((this.field_146294_l - 256) / 2, (this.field_146295_m - 176) / 2, 0, 0, 256, 176);
        GlStateManager.func_179141_d();
    }

    private void drawWhiteQuad(int x, int y, int w, int h) {
        double xd = x;
        double xd2 = x + w;
        double yd = y;
        double yd2 = y + h;
        double zd = this.field_73735_i;
        GlStateManager.func_179090_x();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Tessellator t = Tessellator.func_178181_a();
        VertexBuffer bb = t.func_178180_c();
        bb.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        bb.func_181662_b(xd, yd2, zd).func_181675_d();
        bb.func_181662_b(xd2, yd2, zd).func_181675_d();
        bb.func_181662_b(xd2, yd, zd).func_181675_d();
        bb.func_181662_b(xd, yd, zd).func_181675_d();
        t.func_78381_a();
        GlStateManager.func_179098_w();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void func_73876_c() {
        super.func_73876_c();
        if (this.accessState >= 0) {
            if (--this.accessTime <= 0) {
                ++this.accessState;
                if (this.accessState == 1) {
                    if (this.lines.size() > 0) {
                        this.lines.remove(this.lines.size() - 1);
                    }
                    this.lines.add("access: PERMISSION DENIED....and...");
                    this.accessTime = 20;
                } else {
                    if (this.accessSound == null) {
                        this.accessSound = new PositionedSoundRecord(WebDisplays.INSTANCE.soundServer.func_187503_a(), SoundCategory.MASTER, 1.0f, 1.0f, true, 0, ISound.AttenuationType.NONE, 0.0f, 0.0f, 0.0f);
                        this.field_146297_k.func_147118_V().func_147682_a((ISound)this.accessSound);
                    }
                    this.writeLine("YOU DIDN'T SAY THE MAGIC WORD!");
                    this.accessTime = 2;
                }
            }
        } else {
            this.blinkTime = (this.blinkTime + 1) % 10;
            if (this.currentTask != null) {
                long queryTime;
                GuiServer guiServer = this;
                synchronized (guiServer) {
                    queryTime = this.queryTime;
                }
                if (System.currentTimeMillis() - queryTime >= 10000L) {
                    this.writeLine(GuiServer.tr("timeout", new Object[0]));
                    this.currentTask.cancel();
                    this.clearTask();
                }
            }
            if (!this.uploadFilter.isEmpty() && System.currentTimeMillis() - this.uploadFilterTime >= 1000L) {
                Log.info("Upload filter cleared", new Object[0]);
                this.uploadFilter = "";
            }
        }
    }

    @Override
    public void func_146282_l() throws IOException {
        boolean keyState = Keyboard.getEventKeyState();
        int keyCode = Keyboard.getEventKey();
        if (this.uploadWizard) {
            if (keyState) {
                if (keyCode == 200) {
                    if (this.selectedLine > 3) {
                        --this.selectedLine;
                    } else if (this.uploadOffset > 0) {
                        --this.uploadOffset;
                        this.updateUploadScreen();
                    }
                } else if (keyCode == 208) {
                    if (this.selectedLine < 11) {
                        ++this.selectedLine;
                    } else if (this.uploadOffset + this.selectedLine - 2 < this.uploadFiles.size()) {
                        ++this.uploadOffset;
                        this.updateUploadScreen();
                    }
                } else if (keyCode == 201) {
                    this.selectedLine = 3;
                    int dst = this.uploadOffset - 9;
                    if (dst < 0) {
                        dst = 0;
                    }
                    this.selectFile(dst);
                } else if (keyCode == 209) {
                    this.selectedLine = 3;
                    int dst = this.uploadOffset + 9;
                    if (dst >= this.uploadFiles.size()) {
                        dst = this.uploadFiles.size() - 1;
                    }
                    this.selectFile(dst);
                } else if (keyCode == 28 || keyCode == 156) {
                    File file = this.uploadFiles.get(this.uploadOffset + this.selectedLine - 3);
                    if (file.isDirectory()) {
                        this.uploadCD(file);
                        this.updateUploadScreen();
                    } else {
                        this.startFileUpload(file, true);
                    }
                } else if (keyCode == 63) {
                    this.uploadCD(this.uploadDir);
                    this.updateUploadScreen();
                }
            }
            if (keyCode == 1) {
                this.quitUploadWizard();
                return;
            }
            super.func_146282_l();
        } else {
            super.func_146282_l();
            if (keyState) {
                boolean ctrl;
                boolean bl = ctrl = Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157);
                if (keyCode == 38 && ctrl) {
                    this.lines.clear();
                } else if (keyCode == 47 && ctrl) {
                    this.prompt = this.prompt + GuiServer.func_146277_j();
                    if (this.prompt.length() > 32) {
                        this.prompt = this.prompt.substring(0, 32);
                    }
                } else if (keyCode == 200 && this.lastCmd != null) {
                    String tmp = this.prompt;
                    this.prompt = this.lastCmd;
                    this.lastCmd = tmp;
                }
            }
        }
    }

    @Override
    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        if (this.uploadWizard) {
            int i;
            boolean found = false;
            this.uploadFilter = this.uploadFilter + Character.toLowerCase(typedChar);
            this.uploadFilterTime = System.currentTimeMillis();
            int n = i = this.uploadFirstIsParent ? 1 : 0;
            while (i < this.uploadFiles.size()) {
                if (this.uploadFiles.get(i).getName().toLowerCase().startsWith(this.uploadFilter)) {
                    this.selectFile(i);
                    found = true;
                    break;
                }
                ++i;
            }
            if (!found && this.uploadFilter.length() == 1) {
                this.uploadFilter = "";
            }
            return;
        }
        if (this.promptLocked) {
            return;
        }
        if (keyCode == 14) {
            if (this.prompt.length() > 0) {
                this.prompt = this.prompt.substring(0, this.prompt.length() - 1);
            }
        } else if (keyCode == 28 || keyCode == 156) {
            if (this.prompt.length() > 0) {
                this.writeLine(this.userPrompt + this.prompt);
                this.evaluateCommand(this.prompt);
                this.lastCmd = this.prompt;
                this.prompt = "";
            } else {
                this.writeLine(this.userPrompt);
            }
        } else if (this.prompt.length() + 1 < 32 && typedChar >= ' ' && typedChar <= '~') {
            this.prompt = this.prompt + typedChar;
        }
        this.blinkTime = 0;
    }

    private void evaluateCommand(String str) {
        Object[] params;
        String[] args = str.trim().split("\\s+");
        Method handler = COMMAND_MAP.get(args[0].toLowerCase());
        if (handler == null) {
            this.writeLine(GuiServer.tr("unknowncmd", new Object[0]));
            return;
        }
        if (handler.getParameterCount() == 0) {
            params = new Object[]{};
        } else {
            String[] args2 = new String[args.length - 1];
            System.arraycopy(args, 1, args2, 0, args2.length);
            params = new Object[]{args2};
        }
        try {
            handler.invoke((Object)this, params);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            Log.errorEx("Caught exception while running command \"%s\"", e, str);
            this.writeLine(GuiServer.tr("error", new Object[0]));
        }
    }

    private void writeLine(String line) {
        int maxl;
        int n = maxl = this.uploadWizard ? 12 : 11;
        while (this.lines.size() >= maxl) {
            this.lines.remove(0);
        }
        this.lines.add(line);
    }

    private static void buildCommandMap() {
        Method[] methods;
        COMMAND_MAP.clear();
        for (Method m : methods = GuiServer.class.getMethods()) {
            CommandHandler cmd = m.getAnnotation(CommandHandler.class);
            if (cmd == null || !Modifier.isPublic(m.getModifiers()) || m.getParameterCount() != 0 && (m.getParameterCount() != 1 || m.getParameterTypes()[0] != String[].class)) continue;
            COMMAND_MAP.put(cmd.value().toLowerCase(), m);
        }
    }

    private void quitUploadWizard() {
        this.lines.clear();
        this.promptLocked = false;
        this.uploadWizard = false;
        this.selectedLine = -1;
    }

    @Override
    public void func_146281_b() {
        super.func_146281_b();
        if (this.accessSound != null) {
            this.field_146297_k.func_147118_V().func_147683_b((ISound)this.accessSound);
        }
    }

    private boolean queueTask(ClientTask<?> task) {
        if (Client.getInstance().addTask(task)) {
            this.promptLocked = true;
            this.queryTime = System.currentTimeMillis();
            this.currentTask = task;
            return true;
        }
        this.writeLine(GuiServer.tr("queryerr", new Object[0]));
        return false;
    }

    private void clearTask() {
        this.promptLocked = false;
        this.currentTask = null;
    }

    private static String trimStringL(String str) {
        int delta = str.length() - 32;
        if (delta <= 0) {
            return str;
        }
        return "..." + str.substring(delta + 3);
    }

    private static String trimStringR(String str) {
        return str.length() <= 32 ? str : str.substring(0, 29) + "...";
    }

    @CommandHandler(value="clear")
    public void commandClear() {
        this.lines.clear();
    }

    @CommandHandler(value="help")
    public void commandHelp(String[] args) {
        if (args.length > 0) {
            String cmd = args[0].toLowerCase();
            if (COMMAND_MAP.containsKey(cmd)) {
                this.writeLine(GuiServer.tr("help." + cmd, new Object[0]));
            } else {
                this.writeLine(GuiServer.tr("unknowncmd", new Object[0]));
            }
        } else {
            for (String c : COMMAND_MAP.keySet()) {
                this.writeLine(c + " - " + GuiServer.tr("help." + c, new Object[0]));
            }
        }
    }

    @CommandHandler(value="exit")
    public void commandExit() {
        this.field_146297_k.func_147108_a(null);
    }

    @CommandHandler(value="access")
    public void commandAccess(String[] args) {
        boolean handled = false;
        if (args.length >= 1 && args[0].equalsIgnoreCase("security")) {
            if (args.length == 1 || args.length == 2 && args[1].equalsIgnoreCase("grid")) {
                handled = true;
            }
        } else if (args.length == 3 && args[0].equalsIgnoreCase("main") && args[1].equalsIgnoreCase("security") && args[2].equalsIgnoreCase("grid")) {
            handled = true;
        }
        if (handled) {
            this.writeLine("access: PERMISSION DENIED.");
            if (++this.accessTrials >= 3) {
                this.promptLocked = true;
                this.accessState = 0;
                this.accessTime = 20;
            }
        } else {
            this.writeLine(GuiServer.tr("argerror", new Object[0]));
        }
    }

    @CommandHandler(value="owner")
    public void commandOwner() {
        this.writeLine(GuiServer.tr("ownername", this.owner.name));
        this.writeLine(GuiServer.tr("owneruuid", new Object[0]));
        this.writeLine(this.owner.uuid.toString());
    }

    @CommandHandler(value="quota")
    public void commandQuota() {
        if (!this.field_146297_k.field_71439_g.func_146103_bH().getId().equals(this.owner.uuid)) {
            this.writeLine(GuiServer.tr("errowner", new Object[0]));
            return;
        }
        ClientTaskGetQuota task = new ClientTaskGetQuota();
        task.setFinishCallback(t -> {
            this.writeLine(GuiServer.tr("quota", Util.sizeString(t.getQuota()), Util.sizeString(t.getMaxQuota())));
            this.clearTask();
        });
        this.queueTask(task);
    }

    @CommandHandler(value="ls")
    public void commandList() {
        ClientTaskGetFileList task = new ClientTaskGetFileList(this.owner.uuid);
        task.setFinishCallback(t -> {
            String[] files = t.getFileList();
            if (files != null) {
                Arrays.stream(files).forEach(this::writeLine);
            }
            this.clearTask();
        });
        this.queueTask(task);
    }

    @CommandHandler(value="url")
    public void commandURL(String[] args) {
        if (args.length < 1) {
            this.writeLine(GuiServer.tr("fnamearg", new Object[0]));
            return;
        }
        String fname = Util.join(args, " ");
        if (Util.isFileNameInvalid(fname)) {
            this.writeLine(GuiServer.tr("nameerr", new Object[0]));
            return;
        }
        ClientTaskCheckFile task = new ClientTaskCheckFile(this.owner.uuid, fname);
        task.setFinishCallback(t -> {
            int status = t.getStatus();
            if (status == 0) {
                this.writeLine(GuiServer.tr("urlcopied", new Object[0]));
                GuiServer.func_146275_d((String)t.getURL());
            } else if (status == 2) {
                this.writeLine(GuiServer.tr("notfound", new Object[0]));
            } else {
                this.writeLine(GuiServer.tr("error2", status));
            }
            this.clearTask();
        });
        this.queueTask(task);
    }

    private void uploadCD(File newDir) {
        try {
            this.uploadDir = newDir.getCanonicalFile();
        }
        catch (IOException ex) {
            this.uploadDir = newDir;
        }
        this.uploadFiles.clear();
        File parent = this.uploadDir.getParentFile();
        if (parent != null && parent.exists()) {
            this.uploadFiles.add(parent);
            this.uploadFirstIsParent = true;
        } else {
            this.uploadFirstIsParent = false;
        }
        File[] children = this.uploadDir.listFiles();
        if (children != null) {
            Collator c = Collator.getInstance();
            c.setStrength(1);
            c.setDecomposition(1);
            Arrays.stream(children).filter(f -> !f.isHidden() && (f.isDirectory() || f.isFile())).sorted((a, b) -> c.compare(a.getName(), b.getName())).forEach(this.uploadFiles::add);
        }
        this.uploadOffset = 0;
        this.uploadFilter = "";
        if (this.uploadWizard) {
            this.selectedLine = 3;
        }
    }

    private void updateUploadScreen() {
        this.lines.clear();
        this.lines.add(GuiServer.tr("upload.info", new Object[0]));
        this.lines.add(GuiServer.trimStringL(this.uploadDir.getPath()));
        this.lines.add("");
        for (int i = this.uploadOffset; i < this.uploadFiles.size() && this.lines.size() < 12; ++i) {
            if (i == 0 && this.uploadFirstIsParent) {
                this.lines.add(GuiServer.tr("upload.parent", new Object[0]));
                continue;
            }
            this.lines.add(GuiServer.trimStringR(this.uploadFiles.get(i).getName()));
        }
    }

    private void selectFile(int i) {
        int pos = 3 + i - this.uploadOffset;
        if (pos >= 3 && pos < 12) {
            this.selectedLine = pos;
            return;
        }
        this.uploadOffset = i;
        if (this.uploadOffset + 12 - 3 > this.uploadFiles.size()) {
            this.uploadOffset = this.uploadFiles.size() - 12 + 3;
        }
        this.updateUploadScreen();
        this.selectedLine = 3 + i - this.uploadOffset;
    }

    @CommandHandler(value="upload")
    public void commandUpload(String[] args) {
        if (!this.field_146297_k.field_71439_g.func_146103_bH().getId().equals(this.owner.uuid)) {
            this.writeLine(GuiServer.tr("errowner", new Object[0]));
            return;
        }
        if (args.length > 0) {
            File fle = new File(Util.join(args, " "));
            if (!fle.exists()) {
                this.writeLine(GuiServer.tr("notfound", new Object[0]));
                return;
            }
            if (fle.isDirectory()) {
                this.uploadCD(fle);
            } else {
                if (fle.isFile()) {
                    this.startFileUpload(fle, false);
                    return;
                }
                this.writeLine(GuiServer.tr("notfound", new Object[0]));
                return;
            }
        }
        this.uploadWizard = true;
        this.promptLocked = true;
        this.uploadOffset = 0;
        this.selectedLine = 3;
        this.updateUploadScreen();
    }

    @CommandHandler(value="rm")
    public void commandDelete(String[] args) {
        if (!this.field_146297_k.field_71439_g.func_146103_bH().getId().equals(this.owner.uuid)) {
            this.writeLine(GuiServer.tr("errowner", new Object[0]));
            return;
        }
        if (args.length < 1) {
            this.writeLine(GuiServer.tr("fnamearg", new Object[0]));
            return;
        }
        String fname = Util.join(args, " ");
        if (Util.isFileNameInvalid(fname)) {
            this.writeLine(GuiServer.tr("nameerr", new Object[0]));
            return;
        }
        ClientTaskDeleteFile task = new ClientTaskDeleteFile(fname);
        task.setFinishCallback(t -> {
            int status = t.getStatus();
            if (status == 1) {
                this.writeLine(GuiServer.tr("notfound", new Object[0]));
            } else if (status != 0) {
                this.writeLine(GuiServer.tr("error", new Object[0]));
            }
            this.clearTask();
        });
        this.queueTask(task);
    }

    @CommandHandler(value="reconnect")
    public void commandReconnect() {
        Client.getInstance().stop();
        WebDisplays.NET_HANDLER.sendToServer((IMessage)Client.getInstance().beginConnection());
    }

    private void startFileUpload(File f, boolean quit) {
        ClientTaskUploadFile task;
        if (quit) {
            this.quitUploadWizard();
        }
        if (Util.isFileNameInvalid(f.getName()) || f.getName().length() >= 29) {
            this.writeLine(GuiServer.tr("nameerr", new Object[0]));
            return;
        }
        try {
            task = new ClientTaskUploadFile(f);
        }
        catch (IOException ex) {
            this.writeLine(GuiServer.tr("error", new Object[0]));
            ex.printStackTrace();
            return;
        }
        task.setProgressCallback((cur, total) -> {
            GuiServer guiServer = this;
            synchronized (guiServer) {
                this.queryTime = System.currentTimeMillis();
            }
        });
        task.setFinishCallback(t -> {
            int status = t.getUploadStatus();
            if (status == 0) {
                this.writeLine(GuiServer.tr("upload.done", new Object[0]));
            } else if (status == 5) {
                this.writeLine(GuiServer.tr("upload.exists", new Object[0]));
            } else if (status == 3) {
                this.writeLine(GuiServer.tr("upload.quota", new Object[0]));
            } else {
                this.writeLine(GuiServer.tr("error2", status));
            }
            this.clearTask();
        });
        if (this.queueTask(task)) {
            this.writeLine(GuiServer.tr("upload.uploading", new Object[0]));
        }
    }

    @Override
    public boolean isForBlock(BlockPos bp, BlockSide side) {
        return this.serverPos.equalsBlockPos(bp);
    }

    @Override
    @Nullable
    public String getWikiPageName() {
        return "Server";
    }
}

