/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.client.gui;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.montoyo.wd.WebDisplays;
import net.montoyo.wd.client.gui.GuiSubscribe;
import net.montoyo.wd.client.gui.controls.Container;
import net.montoyo.wd.client.gui.controls.Control;
import net.montoyo.wd.client.gui.controls.Event;
import net.montoyo.wd.client.gui.loading.FillControl;
import net.montoyo.wd.client.gui.loading.GuiLoader;
import net.montoyo.wd.client.gui.loading.JsonOWrapper;
import net.montoyo.wd.net.server.SMessageACQuery;
import net.montoyo.wd.utilities.BlockSide;
import net.montoyo.wd.utilities.Bounds;
import net.montoyo.wd.utilities.Log;
import net.montoyo.wd.utilities.NameUUIDPair;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public abstract class WDScreen
extends GuiScreen {
    public static WDScreen CURRENT_SCREEN = null;
    protected final ArrayList<Control> controls = new ArrayList();
    protected final ArrayList<Control> postDrawList = new ArrayList();
    private final HashMap<Class<? extends Event>, Method> eventMap = new HashMap();
    protected boolean quitOnEscape = true;
    protected boolean defaultBackground = true;
    protected int syncTicks = 40;
    private int syncTicksLeft = -1;

    public WDScreen() {
        Method[] methods;
        for (Method m : methods = ((Object)((Object)this)).getClass().getMethods()) {
            if (m.getAnnotation(GuiSubscribe.class) == null) continue;
            if (!Modifier.isPublic(m.getModifiers())) {
                throw new RuntimeException("Found non public @GuiSubscribe");
            }
            Class<?>[] params = m.getParameterTypes();
            if (params.length != 1 || !Event.class.isAssignableFrom(params[0])) {
                throw new RuntimeException("Invalid parameters for @GuiSubscribe");
            }
            this.eventMap.put(params[0], m);
        }
    }

    protected <T extends Control> T addControl(T ctrl) {
        this.controls.add(ctrl);
        return ctrl;
    }

    public int screen2DisplayX(int x) {
        double ret = (double)x / (double)this.field_146294_l * (double)this.field_146297_k.field_71443_c;
        return (int)ret;
    }

    public int screen2DisplayY(int y) {
        double ret = (double)y / (double)this.field_146295_m * (double)this.field_146297_k.field_71440_d;
        return (int)ret;
    }

    public int display2ScreenX(int x) {
        double ret = (double)x / (double)this.field_146297_k.field_71443_c * (double)this.field_146294_l;
        return (int)ret;
    }

    public int display2ScreenY(int y) {
        double ret = (double)y / (double)this.field_146297_k.field_71440_d * (double)this.field_146295_m;
        return (int)ret;
    }

    protected void centerControls() {
        Bounds bounds = Control.findBounds(this.controls);
        int diffX = (this.field_146294_l - bounds.maxX - bounds.minX) / 2;
        int diffY = (this.field_146295_m - bounds.maxY - bounds.minY) / 2;
        for (Control ctrl : this.controls) {
            int x = ctrl.getX();
            int y = ctrl.getY();
            ctrl.setPos(x + diffX, y + diffY);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float ptt) {
        if (this.defaultBackground) {
            this.func_146276_q_();
        }
        for (Control ctrl : this.controls) {
            ctrl.draw(mouseX, mouseY, ptt);
        }
        for (Control ctrl : this.postDrawList) {
            ctrl.postDraw(mouseX, mouseY, ptt);
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.quitOnEscape && keyCode == 1) {
            this.field_146297_k.func_147108_a(null);
            return;
        }
        for (Control ctrl : this.controls) {
            ctrl.keyTyped(typedChar, keyCode);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        for (Control ctrl : this.controls) {
            ctrl.mouseClicked(mouseX, mouseY, mouseButton);
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        for (Control ctrl : this.controls) {
            ctrl.mouseReleased(mouseX, mouseY, state);
        }
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        for (Control ctrl : this.controls) {
            ctrl.mouseClickMove(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        }
    }

    public void func_73866_w_() {
        CURRENT_SCREEN = this;
        Keyboard.enableRepeatEvents((boolean)true);
    }

    public void func_146281_b() {
        if (this.syncTicksLeft >= 0) {
            this.sync();
            this.syncTicksLeft = -1;
        }
        for (Control ctrl : this.controls) {
            ctrl.destroy();
        }
        Keyboard.enableRepeatEvents((boolean)false);
        CURRENT_SCREEN = null;
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        int dw = Mouse.getEventDWheel();
        if (dw != 0) {
            this.onMouseScroll(x, y, dw);
        } else if (Mouse.getEventButton() == -1) {
            this.onMouseMove(x, y);
        }
    }

    public void func_146282_l() throws IOException {
        block4: {
            super.func_146282_l();
            int key = Keyboard.getEventKey();
            if (key == 0) break block4;
            if (Keyboard.getEventKeyState()) {
                for (Control ctrl : this.controls) {
                    ctrl.keyDown(key);
                }
            } else {
                for (Control ctrl : this.controls) {
                    ctrl.keyUp(key);
                }
            }
        }
    }

    public void onMouseScroll(int mouseX, int mouseY, int amount) {
        for (Control ctrl : this.controls) {
            ctrl.mouseScroll(mouseX, mouseY, amount);
        }
    }

    public void onMouseMove(int mouseX, int mouseY) {
        for (Control ctrl : this.controls) {
            ctrl.mouseMove(mouseX, mouseY);
        }
    }

    public Object actionPerformed(Event ev) {
        Method m = this.eventMap.get(ev.getClass());
        if (m != null) {
            try {
                return m.invoke((Object)this, ev);
            }
            catch (IllegalAccessException e) {
                Log.errorEx("Access to event %s of screen %s is denied", e, ev.getClass().getSimpleName(), ((Object)((Object)this)).getClass().getSimpleName());
            }
            catch (InvocationTargetException e) {
                Log.errorEx("Event %s of screen %s failed", e, ev.getClass().getSimpleName(), ((Object)((Object)this)).getClass().getSimpleName());
            }
        }
        return null;
    }

    public <T extends Control> T getControlByName(String name) {
        for (Control ctrl : this.controls) {
            Control ret;
            if (name.equals(ctrl.getName())) {
                return (T)ctrl;
            }
            if (!(ctrl instanceof Container) || (ret = ((Container)ctrl).getByName(name)) == null) continue;
            return (T)ret;
        }
        return null;
    }

    protected void addLoadCustomVariables(Map<String, Double> vars) {
    }

    public void loadFrom(ResourceLocation resLoc) {
        Field[] fields;
        JsonObject root = GuiLoader.getJson(resLoc);
        if (root == null) {
            throw new RuntimeException("Could not load GUI file " + resLoc.toString());
        }
        if (!root.has("controls") || !root.get("controls").isJsonArray()) {
            throw new RuntimeException("In GUI file " + resLoc.toString() + ": missing root 'controls' object.");
        }
        HashMap<String, Double> vars = new HashMap<String, Double>();
        vars.put("width", Double.valueOf(this.field_146294_l));
        vars.put("height", Double.valueOf(this.field_146295_m));
        vars.put("displayWidth", Double.valueOf(this.field_146297_k.field_71443_c));
        vars.put("displayHeight", Double.valueOf(this.field_146297_k.field_71440_d));
        this.addLoadCustomVariables(vars);
        JsonArray content = root.get("controls").getAsJsonArray();
        for (JsonElement elem : content) {
            this.controls.add(GuiLoader.create(new JsonOWrapper(elem.getAsJsonObject(), vars)));
        }
        for (Field f : fields = ((Object)((Object)this)).getClass().getDeclaredFields()) {
            f.setAccessible(true);
            FillControl fc = f.getAnnotation(FillControl.class);
            if (fc == null) continue;
            String name = fc.name().isEmpty() ? f.getName() : fc.name();
            Object ctrl = this.getControlByName(name);
            if (ctrl == null) {
                if (!fc.required()) continue;
                throw new RuntimeException("In GUI file " + resLoc.toString() + ": missing required control " + name);
            }
            if (!f.getType().isAssignableFrom(ctrl.getClass())) {
                throw new RuntimeException("In GUI file " + resLoc.toString() + ": invalid type for control " + name);
            }
            try {
                f.set((Object)this, ctrl);
            }
            catch (IllegalAccessException e) {
                if (!fc.required()) continue;
                throw new RuntimeException(e);
            }
        }
        if (root.has("center") && root.get("center").getAsBoolean()) {
            this.centerControls();
        }
    }

    public void func_175273_b(@Nonnull Minecraft mcIn, int w, int h) {
        for (Control ctrl : this.controls) {
            ctrl.destroy();
        }
        this.controls.clear();
        super.func_175273_b(mcIn, w, h);
    }

    protected void requestAutocomplete(String beginning, boolean matchExact) {
        WebDisplays.NET_HANDLER.sendToServer((IMessage)new SMessageACQuery(beginning, matchExact));
    }

    public void onAutocompleteResult(NameUUIDPair[] pairs) {
    }

    public void onAutocompleteFailure() {
    }

    protected void requestSync() {
        this.syncTicksLeft = this.syncTicks - 1;
    }

    protected boolean syncRequested() {
        return this.syncTicksLeft >= 0;
    }

    protected void abortSync() {
        this.syncTicksLeft = -1;
    }

    protected void sync() {
    }

    public void func_73876_c() {
        if (this.syncTicksLeft >= 0 && --this.syncTicksLeft < 0) {
            this.sync();
        }
    }

    public void drawItemStackTooltip(ItemStack is, int x, int y) {
        this.func_146285_a(is, x, y);
    }

    public void requirePostDraw(Control ctrl) {
        if (!this.postDrawList.contains(ctrl)) {
            this.postDrawList.add(ctrl);
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    public abstract boolean isForBlock(BlockPos var1, BlockSide var2);

    @Nullable
    public String getWikiPageName() {
        return null;
    }
}

