/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.client.gui.controls;

import net.minecraft.client.gui.GuiButton;
import net.montoyo.wd.client.gui.controls.Control;
import net.montoyo.wd.client.gui.controls.Event;
import net.montoyo.wd.client.gui.loading.JsonOWrapper;

public class Button
extends Control {
    protected final GuiButton btn;
    protected boolean selected = false;
    protected boolean shiftDown = false;
    protected int originalColor = 0;
    protected int shiftColor = 0;

    public Button() {
        this.btn = new GuiButton(0, 0, 0, "");
    }

    public Button(String text, int x, int y, int width) {
        this.btn = new GuiButton(0, x, y, width, 20, text);
    }

    public Button(String text, int x, int y) {
        this.btn = new GuiButton(0, x, y, text);
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 0 && this.btn.func_146116_c(this.mc, mouseX, mouseY)) {
            this.selected = true;
            this.btn.func_146113_a(this.mc.func_147118_V());
            if (!this.onClick()) {
                this.parent.actionPerformed(new ClickEvent(this));
            }
        }
    }

    @Override
    public void mouseReleased(int mouseX, int mouseY, int state) {
        if (this.selected && state == 0) {
            this.btn.func_146118_a(mouseX, mouseY);
            this.selected = false;
        }
    }

    @Override
    public void draw(int mouseX, int mouseY, float ptt) {
        this.btn.func_146112_a(this.mc, mouseX, mouseY);
    }

    public void setLabel(String label) {
        this.btn.field_146126_j = label;
    }

    public String getLabel() {
        return this.btn.field_146126_j;
    }

    public void setWidth(int width) {
        this.btn.func_175211_a(width);
    }

    @Override
    public int getWidth() {
        return this.btn.func_146117_b();
    }

    @Override
    public int getHeight() {
        return 20;
    }

    @Override
    public void setPos(int x, int y) {
        this.btn.field_146128_h = x;
        this.btn.field_146129_i = y;
    }

    @Override
    public int getX() {
        return this.btn.field_146128_h;
    }

    @Override
    public int getY() {
        return this.btn.field_146129_i;
    }

    public GuiButton getMcButton() {
        return this.btn;
    }

    public void setDisabled(boolean dis) {
        this.btn.field_146124_l = !dis;
    }

    public boolean isDisabled() {
        return !this.btn.field_146124_l;
    }

    public void enable() {
        this.btn.field_146124_l = true;
    }

    public void disable() {
        this.btn.field_146124_l = false;
    }

    public void setVisible(boolean visible) {
        this.btn.field_146125_m = visible;
    }

    public boolean isVisible() {
        return this.btn.field_146125_m;
    }

    public void show() {
        this.btn.field_146125_m = true;
    }

    public void hide() {
        this.btn.field_146125_m = false;
    }

    public boolean isShiftDown() {
        return this.shiftDown;
    }

    @Override
    public void keyUp(int key) {
        if (key == 42 || key == 54) {
            this.shiftDown = false;
            this.btn.packedFGColour = this.originalColor;
        }
    }

    @Override
    public void keyDown(int key) {
        if (key == 42 || key == 54) {
            this.shiftDown = true;
            this.btn.packedFGColour = this.shiftColor;
        }
    }

    public void setTextColor(int color) {
        this.originalColor = color;
        if (!this.shiftDown) {
            this.btn.packedFGColour = color;
        }
    }

    public int getTextColor() {
        return this.btn.packedFGColour;
    }

    public void setShiftTextColor(int shiftColor) {
        this.shiftColor = shiftColor;
        if (this.shiftDown) {
            this.btn.packedFGColour = shiftColor;
        }
    }

    public int getShiftTextColor() {
        return this.shiftColor;
    }

    @Override
    public void load(JsonOWrapper json) {
        super.load(json);
        this.btn.field_146128_h = json.getInt("x", 0);
        this.btn.field_146129_i = json.getInt("y", 0);
        this.btn.field_146120_f = json.getInt("width", 200);
        this.btn.field_146126_j = Button.tr(json.getString("label", this.btn.field_146126_j));
        this.btn.field_146124_l = !json.getBool("disabled", !this.btn.field_146124_l);
        this.btn.field_146125_m = json.getBool("visible", this.btn.field_146125_m);
        this.originalColor = json.getColor("color", this.originalColor);
        this.shiftColor = json.getColor("shiftColor", this.shiftColor);
        this.btn.packedFGColour = this.originalColor;
    }

    protected boolean onClick() {
        return false;
    }

    public static class ClickEvent
    extends Event<Button> {
        private final boolean shiftDown;

        private ClickEvent(Button btn) {
            this.source = btn;
            this.shiftDown = btn.shiftDown;
        }

        public boolean isShiftDown() {
            return this.shiftDown;
        }
    }
}

