/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.client.gui.controls;

import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.montoyo.wd.client.gui.controls.BasicControl;
import net.montoyo.wd.client.gui.controls.Event;
import net.montoyo.wd.client.gui.loading.JsonOWrapper;

public class CheckBox
extends BasicControl {
    private static final ResourceLocation texUnchecked = new ResourceLocation("webdisplays", "textures/gui/checkbox.png");
    private static final ResourceLocation texChecked = new ResourceLocation("webdisplays", "textures/gui/checkbox_checked.png");
    public static final int WIDTH = 16;
    public static final int HEIGHT = 16;
    private String label;
    private int labelW;
    private boolean checked;

    public CheckBox() {
        this.label = "";
    }

    public CheckBox(int x, int y, String label) {
        this.label = label;
        this.labelW = this.font.func_78256_a(label);
        this.checked = false;
        this.x = x;
        this.y = y;
    }

    public CheckBox(int x, int y, String label, boolean val) {
        this.label = label;
        this.labelW = this.font.func_78256_a(label);
        this.checked = val;
        this.x = x;
        this.y = y;
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 0 && !this.disabled && mouseX >= this.x && mouseX <= this.x + 16 + 2 + this.labelW && mouseY >= this.y && mouseY < this.y + 16) {
            this.checked = !this.checked;
            this.mc.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            this.parent.actionPerformed(new CheckedEvent(this));
        }
    }

    @Override
    public void draw(int mouseX, int mouseY, float ptt) {
        if (this.visible) {
            GlStateManager.func_179118_c();
            this.bindTexture(this.checked ? texChecked : texUnchecked);
            CheckBox.blend(true);
            this.fillTexturedRect(this.x, this.y, 16, 16, 0.0, 0.0, 1.0, 1.0);
            CheckBox.blend(false);
            this.bindTexture(null);
            boolean inside = !this.disabled && mouseX >= this.x && mouseX <= this.x + 16 + 2 + this.labelW && mouseY >= this.y && mouseY < this.y + 16;
            this.font.func_78276_b(this.label, this.x + 16 + 2, this.y + 4, inside ? -16744193 : -1);
        }
    }

    public void setLabel(String label) {
        this.label = label;
        this.labelW = this.font.func_78256_a(label);
    }

    public String getLabel() {
        return this.label;
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
    }

    @Override
    public int getWidth() {
        return 18 + this.labelW;
    }

    @Override
    public int getHeight() {
        return 16;
    }

    @Override
    public void load(JsonOWrapper json) {
        super.load(json);
        this.label = CheckBox.tr(json.getString("label", ""));
        this.labelW = this.font.func_78256_a(this.label);
        this.checked = json.getBool("checked", false);
    }

    public static class CheckedEvent
    extends Event<CheckBox> {
        private final boolean checked;

        private CheckedEvent(CheckBox cb) {
            this.source = cb;
            this.checked = cb.checked;
        }

        public boolean isChecked() {
            return this.checked;
        }
    }
}

