/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.client.gui.controls;

import java.io.IOException;
import java.util.ArrayList;
import net.montoyo.wd.client.gui.controls.BasicControl;
import net.montoyo.wd.client.gui.controls.Control;
import net.montoyo.wd.client.gui.loading.GuiLoader;
import net.montoyo.wd.client.gui.loading.JsonAWrapper;
import net.montoyo.wd.client.gui.loading.JsonOWrapper;
import org.lwjgl.opengl.GL11;

public abstract class Container
extends BasicControl {
    protected int paddingX = 0;
    protected int paddingY = 0;
    protected final ArrayList<Control> childs = new ArrayList();

    public <T extends Control> T addControl(T ctrl) {
        this.childs.add(ctrl);
        return ctrl;
    }

    @Override
    public void keyTyped(char typedChar, int keyCode) throws IOException {
        if (!this.disabled) {
            for (Control ctrl : this.childs) {
                ctrl.keyTyped(typedChar, keyCode);
            }
        }
    }

    @Override
    public void keyUp(int key) {
        if (!this.disabled) {
            for (Control ctrl : this.childs) {
                ctrl.keyUp(key);
            }
        }
    }

    @Override
    public void keyDown(int key) {
        if (!this.disabled) {
            for (Control ctrl : this.childs) {
                ctrl.keyDown(key);
            }
        }
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (!this.disabled) {
            mouseX -= this.x + this.paddingX;
            mouseY -= this.y + this.paddingY;
            for (Control ctrl : this.childs) {
                ctrl.mouseClicked(mouseX, mouseY, mouseButton);
            }
        }
    }

    @Override
    public void mouseReleased(int mouseX, int mouseY, int state) {
        if (!this.disabled) {
            mouseX -= this.x + this.paddingX;
            mouseY -= this.y + this.paddingY;
            for (Control ctrl : this.childs) {
                ctrl.mouseReleased(mouseX, mouseY, state);
            }
        }
    }

    @Override
    public void mouseClickMove(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        if (!this.disabled) {
            mouseX -= this.x + this.paddingX;
            mouseY -= this.y + this.paddingY;
            for (Control ctrl : this.childs) {
                ctrl.mouseClickMove(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
            }
        }
    }

    @Override
    public void mouseMove(int mouseX, int mouseY) {
        if (!this.disabled) {
            mouseX -= this.x + this.paddingX;
            mouseY -= this.y + this.paddingY;
            for (Control ctrl : this.childs) {
                ctrl.mouseMove(mouseX, mouseY);
            }
        }
    }

    @Override
    public void mouseScroll(int mouseX, int mouseY, int amount) {
        if (!this.disabled) {
            mouseX -= this.x + this.paddingX;
            mouseY -= this.y + this.paddingY;
            for (Control ctrl : this.childs) {
                ctrl.mouseScroll(mouseX, mouseY, amount);
            }
        }
    }

    @Override
    public void draw(int mouseX, int mouseY, float ptt) {
        if (this.visible) {
            mouseX -= this.x + this.paddingX;
            mouseY -= this.y + this.paddingY;
            GL11.glPushMatrix();
            GL11.glTranslated((double)(this.x + this.paddingX), (double)(this.y + this.paddingY), (double)0.0);
            if (this.disabled) {
                for (Control ctrl : this.childs) {
                    ctrl.draw(-1, -1, ptt);
                }
            } else {
                for (Control ctrl : this.childs) {
                    ctrl.draw(mouseX, mouseY, ptt);
                }
            }
            GL11.glPopMatrix();
        }
    }

    @Override
    public void destroy() {
        for (Control ctrl : this.childs) {
            ctrl.destroy();
        }
    }

    @Override
    public void load(JsonOWrapper json) {
        super.load(json);
        JsonAWrapper objs = json.getArray("childs");
        for (int i = 0; i < objs.size(); ++i) {
            this.childs.add(GuiLoader.create(objs.getObject(i)));
        }
    }

    public Control getByName(String name) {
        for (Control ctrl : this.childs) {
            Control ret;
            if (name.equals(ctrl.name)) {
                return ctrl;
            }
            if (!(ctrl instanceof Container) || (ret = ((Container)ctrl).getByName(name)) == null) continue;
            return ret;
        }
        return null;
    }
}

