/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.client.gui.controls;

import java.io.IOException;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.util.ResourceLocation;
import net.montoyo.wd.client.gui.WDScreen;
import net.montoyo.wd.client.gui.loading.JsonOWrapper;
import net.montoyo.wd.utilities.Bounds;
import org.lwjgl.opengl.GL11;

public abstract class Control {
    public static final int COLOR_BLACK = -16777216;
    public static final int COLOR_WHITE = -1;
    public static final int COLOR_RED = -65536;
    public static final int COLOR_GREEN = -16711936;
    public static final int COLOR_BLUE = -16776961;
    public static final int COLOR_CYAN = -16711681;
    public static final int COLOR_MANGENTA = -65281;
    public static final int COLOR_YELLOW = -256;
    protected final Minecraft mc = Minecraft.func_71410_x();
    protected final FontRenderer font;
    protected final Tessellator tessellator;
    protected final VertexBuffer vBuffer;
    protected final WDScreen parent;
    protected String name;
    protected Object userdata;

    public Control() {
        this.font = this.mc.field_71466_p;
        this.tessellator = Tessellator.func_178181_a();
        this.vBuffer = this.tessellator.func_178180_c();
        this.parent = WDScreen.CURRENT_SCREEN;
    }

    public Object getUserdata() {
        return this.userdata;
    }

    public void setUserdata(Object userdata) {
        this.userdata = userdata;
    }

    public void keyTyped(char typedChar, int keyCode) throws IOException {
    }

    public void keyUp(int key) {
    }

    public void keyDown(int key) {
    }

    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
    }

    public void mouseReleased(int mouseX, int mouseY, int state) {
    }

    public void mouseClickMove(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
    }

    public void mouseMove(int mouseX, int mouseY) {
    }

    public void mouseScroll(int mouseX, int mouseY, int amount) {
    }

    public void draw(int mouseX, int mouseY, float ptt) {
    }

    public void postDraw(int mouseX, int mouseY, float ptt) {
    }

    public void destroy() {
    }

    public WDScreen getParent() {
        return this.parent;
    }

    public abstract int getX();

    public abstract int getY();

    public abstract int getWidth();

    public abstract int getHeight();

    public abstract void setPos(int var1, int var2);

    public void fillRect(int x, int y, int w, int h, int color) {
        double x1 = x;
        double y1 = y;
        double x2 = x + w;
        double y2 = y + h;
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        GL11.glColor4f((float)((float)r / 255.0f), (float)((float)g / 255.0f), (float)((float)b / 255.0f), (float)((float)a / 255.0f));
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        this.vBuffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        this.vBuffer.func_181662_b(x1, y2, 0.0).func_181675_d();
        this.vBuffer.func_181662_b(x2, y2, 0.0).func_181675_d();
        this.vBuffer.func_181662_b(x2, y1, 0.0).func_181675_d();
        this.vBuffer.func_181662_b(x1, y1, 0.0).func_181675_d();
        this.tessellator.func_78381_a();
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3553);
    }

    public void fillTexturedRect(int x, int y, int w, int h, double u1, double v1, double u2, double v2) {
        double x1 = x;
        double y1 = y;
        double x2 = x + w;
        double y2 = y + h;
        this.vBuffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        this.vBuffer.func_181662_b(x1, y2, 0.0).func_187315_a(u1, v2).func_181669_b(255, 255, 255, 255).func_181675_d();
        this.vBuffer.func_181662_b(x2, y2, 0.0).func_187315_a(u2, v2).func_181669_b(255, 255, 255, 255).func_181675_d();
        this.vBuffer.func_181662_b(x2, y1, 0.0).func_187315_a(u2, v1).func_181669_b(255, 255, 255, 255).func_181675_d();
        this.vBuffer.func_181662_b(x1, y1, 0.0).func_187315_a(u1, v1).func_181669_b(255, 255, 255, 255).func_181675_d();
        this.tessellator.func_78381_a();
    }

    public static void blend(boolean enable) {
        if (enable) {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
        } else {
            GL11.glDisable((int)3042);
        }
    }

    public void bindTexture(ResourceLocation resLoc) {
        if (resLoc == null) {
            GlStateManager.func_179144_i((int)0);
        } else {
            this.mc.field_71446_o.func_110577_a(resLoc);
        }
    }

    public void drawBorder(int x, int y, int w, int h, int color) {
        this.drawBorder(x, y, w, h, color, 1.0);
    }

    public void drawBorder(int x, int y, int w, int h, int color, double sz) {
        double x1 = x;
        double y1 = y;
        double x2 = x + w;
        double y2 = y + h;
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        GL11.glColor4f((float)((float)r / 255.0f), (float)((float)g / 255.0f), (float)((float)b / 255.0f), (float)((float)a / 255.0f));
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        this.vBuffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        this.vBuffer.func_181662_b(x1, y1 + sz, 0.0).func_181675_d();
        this.vBuffer.func_181662_b(x2, y1 + sz, 0.0).func_181675_d();
        this.vBuffer.func_181662_b(x2, y1, 0.0).func_181675_d();
        this.vBuffer.func_181662_b(x1, y1, 0.0).func_181675_d();
        this.vBuffer.func_181662_b(x1, y2, 0.0).func_181675_d();
        this.vBuffer.func_181662_b(x2, y2, 0.0).func_181675_d();
        this.vBuffer.func_181662_b(x2, y2 - sz, 0.0).func_181675_d();
        this.vBuffer.func_181662_b(x1, y2 - sz, 0.0).func_181675_d();
        this.vBuffer.func_181662_b(x1, y2, 0.0).func_181675_d();
        this.vBuffer.func_181662_b(x1 + sz, y2, 0.0).func_181675_d();
        this.vBuffer.func_181662_b(x1 + sz, y1, 0.0).func_181675_d();
        this.vBuffer.func_181662_b(x1, y1, 0.0).func_181675_d();
        this.vBuffer.func_181662_b(x2 - sz, y2, 0.0).func_181675_d();
        this.vBuffer.func_181662_b(x2, y2, 0.0).func_181675_d();
        this.vBuffer.func_181662_b(x2, y1, 0.0).func_181675_d();
        this.vBuffer.func_181662_b(x2 - sz, y1, 0.0).func_181675_d();
        this.tessellator.func_78381_a();
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3553);
    }

    public void beginFramebuffer(Framebuffer fbo, int vpW, int vpH) {
        fbo.func_147610_a(true);
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)vpW, (double)vpH, (double)0.0, (double)-1.0, (double)1.0);
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        if (!fbo.field_147619_e) {
            GL11.glDisable((int)2929);
        }
    }

    public void endFramebuffer(Framebuffer fbo) {
        if (!fbo.field_147619_e) {
            GL11.glEnable((int)2929);
        }
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5889);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5888);
        fbo.func_147609_e();
        this.mc.func_147110_a().func_147610_a(true);
    }

    public static String tr(String text) {
        if (text.length() >= 2 && text.charAt(0) == '$') {
            if (text.charAt(1) == '$') {
                return text.substring(1);
            }
            return I18n.func_135052_a((String)text.substring(1), (Object[])new Object[0]);
        }
        return text;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void load(JsonOWrapper json) {
        this.name = json.getString("name", "");
    }

    public static Bounds findBounds(List<Control> controlList) {
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        for (Control ctrl : controlList) {
            int x = ctrl.getX();
            int y = ctrl.getY();
            if (x < minX) {
                minX = x;
            }
            if (y < minY) {
                minY = y;
            }
            y += ctrl.getHeight();
            if ((x += ctrl.getWidth()) > maxX) {
                maxX = x;
            }
            if (y < maxY) continue;
            maxY = y;
        }
        return new Bounds(minX, minY, maxX, maxY);
    }
}

