/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumHand;
import net.montoyo.wd.data.KeyboardData;
import net.montoyo.wd.entity.TileEntityPeripheralBase;
import net.montoyo.wd.entity.TileEntityScreen;
import net.montoyo.wd.utilities.BlockSide;
import net.montoyo.wd.utilities.Util;

public class TileEntityKeyboard
extends TileEntityPeripheralBase {
    private static final String RANDOM_CHARS = "AZERTYUIOPQSDFGHJKLMWXCVBNazertyuiopqsdfghjklmwxcvbn0123456789";

    @Override
    public boolean onRightClick(EntityPlayer player, EnumHand hand, BlockSide side) {
        if (this.field_145850_b.field_72995_K) {
            return true;
        }
        if (!this.isScreenChunkLoaded()) {
            Util.toast(player, "chunkUnloaded", new Object[0]);
            return true;
        }
        TileEntityScreen tes = this.getConnectedScreen();
        if (tes == null) {
            Util.toast(player, "notLinked", new Object[0]);
            return true;
        }
        TileEntityScreen.Screen scr = tes.getScreen(this.screenSide);
        if ((scr.rightsFor(player) & 2) == 0) {
            Util.toast(player, "restrictions", new Object[0]);
            return true;
        }
        new KeyboardData(tes, this.screenSide, this.field_174879_c).sendTo((EntityPlayerMP)player);
        return true;
    }

    public void simulateCat(Entity ent) {
        TileEntityScreen tes;
        if (this.isScreenChunkLoaded() && (tes = this.getConnectedScreen()) != null) {
            boolean ok;
            TileEntityScreen.Screen scr = tes.getScreen(this.screenSide);
            if (ent instanceof EntityPlayer) {
                ok = (scr.rightsFor((EntityPlayer)ent) & 2) != 0;
            } else {
                boolean bl = ok = (scr.otherRights & 2) != 0;
            }
            if (ok) {
                char rnd = RANDOM_CHARS.charAt((int)(Math.random() * (double)RANDOM_CHARS.length()));
                tes.type(this.screenSide, "t" + rnd, this.field_174879_c);
            }
        }
    }
}

