/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.entity;

import javax.annotation.Nonnull;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.Optional;
import net.montoyo.wd.core.IUpgrade;
import net.montoyo.wd.entity.TileEntityPeripheralBase;
import net.montoyo.wd.entity.TileEntityScreen;
import net.montoyo.wd.utilities.BlockSide;
import net.montoyo.wd.utilities.NameUUIDPair;
import net.montoyo.wd.utilities.Rotation;
import net.montoyo.wd.utilities.Util;
import net.montoyo.wd.utilities.Vector2i;

@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="opencomputers")
public class TileEntityOCInterface
extends TileEntityPeripheralBase
implements SimpleComponent {
    private NameUUIDPair owner;
    private static final Object[] TRUE = new Object[]{true};
    private static final Object[] FALSE = new Object[]{false};

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.owner = Util.readOwnerFromNBT(tag);
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        return Util.writeOwnerToNBT(tag, this.owner);
    }

    public void setOwner(EntityPlayer ep) {
        this.owner = new NameUUIDPair(ep.func_146103_bH());
        this.func_70296_d();
    }

    public String getComponentName() {
        return "webdisplays";
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] isLinked(Context ctx, Arguments args) {
        return new Object[]{this.isLinked()};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] isScreenChunkLoaded(Context ctx, Arguments args) {
        return new Object[]{this.isScreenChunkLoaded()};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getScreenPos(Context ctx, Arguments args) {
        Object[] objectArray;
        if (this.isLinked()) {
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = this.screenPos.x;
            objectArray2[1] = this.screenPos.y;
            objectArray = objectArray2;
            objectArray2[2] = this.screenPos.z;
        } else {
            objectArray = null;
        }
        return objectArray;
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getScreenSide(Context ctx, Arguments args) {
        Object[] objectArray;
        if (this.isLinked()) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = this.screenSide.toString().toLowerCase();
        } else {
            objectArray = null;
        }
        return objectArray;
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getOwner(Context ctx, Arguments args) {
        if (this.owner == null) {
            return null;
        }
        return new Object[]{this.owner.name, this.owner.uuid.toString()};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] can(Context ctx, Arguments args) {
        int right;
        String what;
        switch (what = args.checkString(0).toLowerCase()) {
            case "click": 
            case "type": {
                right = 2;
                break;
            }
            case "seturl": 
            case "js": 
            case "javascript": 
            case "runjs": {
                right = 1;
                break;
            }
            case "setresolution": 
            case "setrotation": {
                right = 32;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid right name");
            }
        }
        TileEntityScreen tes = this.getConnectedScreenEx();
        if (this.owner == null || tes == null) {
            return null;
        }
        return (tes.getScreen(this.screenSide).rightsFor(this.owner.uuid) & right) == 0 ? FALSE : TRUE;
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] hasUpgrade(Context ctx, Arguments args) {
        String name = args.checkString(0);
        TileEntityScreen tes = this.getConnectedScreenEx();
        if (this.owner == null || tes == null) {
            return null;
        }
        return tes.getScreen((BlockSide)this.screenSide).upgrades.stream().anyMatch(is -> ((IUpgrade)is.func_77973_b()).getJSName((ItemStack)is).equalsIgnoreCase(name)) ? TRUE : FALSE;
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getSize(Context ctx, Arguments args) {
        TileEntityScreen tes = this.getConnectedScreenEx();
        if (this.owner == null || tes == null) {
            return null;
        }
        Vector2i sz = tes.getScreen((BlockSide)this.screenSide).size;
        return new Object[]{sz.x, sz.y};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getResolution(Context ctx, Arguments args) {
        TileEntityScreen tes = this.getConnectedScreenEx();
        if (this.owner == null || tes == null) {
            return null;
        }
        Vector2i res = tes.getScreen((BlockSide)this.screenSide).resolution;
        return new Object[]{res.x, res.y};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getRotation(Context ctx, Arguments args) {
        TileEntityScreen tes = this.getConnectedScreenEx();
        if (this.owner == null || tes == null) {
            return null;
        }
        return new Object[]{tes.getScreen((BlockSide)this.screenSide).rotation.getAngleAsInt()};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getURL(Context ctx, Arguments args) {
        TileEntityScreen tes = this.getConnectedScreenEx();
        if (this.owner == null || tes == null) {
            return null;
        }
        return new Object[]{tes.getScreen((BlockSide)this.screenSide).url};
    }

    private static Object[] err(String str) {
        return new Object[]{false, str};
    }

    @Callback(limit=4)
    @Optional.Method(modid="opencomputers")
    public Object[] click(Context ctx, Arguments args) {
        int actionId;
        int x = args.checkInteger(0);
        int y = args.checkInteger(1);
        String action = "click";
        if (args.count() > 2) {
            action = args.checkString(2).toLowerCase();
        }
        switch (action) {
            case "click": {
                actionId = 0;
                break;
            }
            case "up": 
            case "release": {
                actionId = 1;
                break;
            }
            case "down": 
            case "press": {
                actionId = 3;
                break;
            }
            case "move": {
                actionId = 2;
                break;
            }
            default: {
                throw new IllegalArgumentException("bad action name");
            }
        }
        TileEntityScreen scr = this.getConnectedScreenEx();
        if (this.owner == null || scr == null) {
            return TileEntityOCInterface.err("notlinked");
        }
        TileEntityScreen.Screen scrscr = scr.getScreen(this.screenSide);
        if ((scrscr.rightsFor(this.owner.uuid) & 2) == 0) {
            return TileEntityOCInterface.err("restrictions");
        }
        switch (scrscr.rotation) {
            case ROT_90: {
                y = scrscr.resolution.y - y;
                break;
            }
            case ROT_180: {
                x = scrscr.resolution.x - x;
                y = scrscr.resolution.y - y;
                break;
            }
            case ROT_270: {
                x = scrscr.resolution.x - x;
                break;
            }
        }
        if (scrscr.rotation.isVertical) {
            scr.clickUnsafe(this.screenSide, actionId, y, x);
        } else {
            scr.clickUnsafe(this.screenSide, actionId, x, y);
        }
        return TRUE;
    }

    private Object[] realType(String what) {
        TileEntityScreen scr = this.getConnectedScreenEx();
        if (this.owner == null || scr == null) {
            return TileEntityOCInterface.err("notlinked");
        }
        if ((scr.getScreen(this.screenSide).rightsFor(this.owner.uuid) & 2) == 0) {
            return TileEntityOCInterface.err("restrictions");
        }
        scr.type(this.screenSide, what, null);
        return TRUE;
    }

    @Callback(limit=4)
    @Optional.Method(modid="opencomputers")
    public Object[] type(Context ctx, Arguments args) {
        String text = args.checkString(0);
        if (text.length() > 64) {
            return TileEntityOCInterface.err("toolong");
        }
        if (text.indexOf(1) >= 0) {
            return TileEntityOCInterface.err("badchar");
        }
        return this.realType("t" + text);
    }

    @Callback(limit=4)
    @Optional.Method(modid="opencomputers")
    public Object[] typeAdvanced(Context ctx, Arguments args) {
        String[] ctrl;
        String text = args.checkString(0);
        if (text.length() > 64) {
            return TileEntityOCInterface.err("toolong");
        }
        for (String c : ctrl = text.split("\u0001")) {
            if (c.length() < 2) {
                return TileEntityOCInterface.err("badformat");
            }
            if (c.charAt(0) == 't' || c.charAt(0) == 'p' || c.charAt(0) == 'r') continue;
            return TileEntityOCInterface.err("badformat");
        }
        return this.realType(text);
    }

    @Callback(limit=1)
    @Optional.Method(modid="opencomputers")
    public Object[] setURL(Context ctx, Arguments args) {
        String url = args.checkString(0);
        TileEntityScreen scr = this.getConnectedScreenEx();
        if (this.owner == null || scr == null) {
            return TileEntityOCInterface.err("notlinked");
        }
        if ((scr.getScreen(this.screenSide).rightsFor(this.owner.uuid) & 1) == 0) {
            return TileEntityOCInterface.err("restrictions");
        }
        scr.setScreenURL(this.screenSide, url);
        return TRUE;
    }

    @Callback(limit=1)
    @Optional.Method(modid="opencomputers")
    public Object[] setResolution(Context ctx, Arguments args) {
        int rx = args.checkInteger(0);
        int ry = args.checkInteger(1);
        TileEntityScreen scr = this.getConnectedScreenEx();
        if (this.owner == null || scr == null) {
            return TileEntityOCInterface.err("notlinked");
        }
        if ((scr.getScreen(this.screenSide).rightsFor(this.owner.uuid) & 0x20) == 0) {
            return TileEntityOCInterface.err("restrictions");
        }
        scr.setResolution(this.screenSide, new Vector2i(rx, ry));
        return TRUE;
    }

    @Callback(limit=1)
    @Optional.Method(modid="opencomputers")
    public Object[] setRotation(Context ctx, Arguments args) {
        int rot = args.checkInteger(0);
        if (rot < 0) {
            int toAdd = rot / -360 + 1;
            rot += toAdd * 360;
        }
        rot /= 90;
        rot &= 3;
        TileEntityScreen scr = this.getConnectedScreenEx();
        if (this.owner == null || scr == null) {
            return TileEntityOCInterface.err("notlinked");
        }
        if ((scr.getScreen(this.screenSide).rightsFor(this.owner.uuid) & 0x20) == 0) {
            return TileEntityOCInterface.err("restrictions");
        }
        scr.setRotation(this.screenSide, Rotation.values()[rot]);
        return TRUE;
    }

    @Callback(limit=4)
    @Optional.Method(modid="opencomputers")
    public Object[] runJS(Context ctx, Arguments args) {
        String code = args.checkString(0);
        TileEntityScreen scr = this.getConnectedScreenEx();
        if (this.owner == null || scr == null) {
            return TileEntityOCInterface.err("notlinked");
        }
        if ((scr.getScreen(this.screenSide).rightsFor(this.owner.uuid) & 1) == 0) {
            return TileEntityOCInterface.err("restrictions");
        }
        scr.evalJS(this.screenSide, code);
        return TRUE;
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] unlink(Context ctx, Arguments args) {
        if (this.isLinked()) {
            this.screenPos = null;
            this.screenSide = null;
            this.func_70296_d();
        }
        return null;
    }
}

