/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.entity;

import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.montoyo.wd.data.RedstoneCtrlData;
import net.montoyo.wd.entity.TileEntityPeripheralBase;
import net.montoyo.wd.entity.TileEntityScreen;
import net.montoyo.wd.utilities.BlockSide;
import net.montoyo.wd.utilities.Util;

public class TileEntityRedCtrl
extends TileEntityPeripheralBase {
    private String risingEdgeURL = "";
    private String fallingEdgeURL = "";
    private boolean state = false;

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.risingEdgeURL = tag.func_74779_i("RisingEdgeURL");
        this.fallingEdgeURL = tag.func_74779_i("FallingEdgeURL");
        this.state = tag.func_74767_n("Powered");
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74778_a("RisingEdgeURL", this.risingEdgeURL);
        tag.func_74778_a("FallingEdgeURL", this.fallingEdgeURL);
        tag.func_74757_a("Powered", this.state);
        return tag;
    }

    @Override
    public boolean onRightClick(EntityPlayer player, EnumHand hand, BlockSide side) {
        if (this.field_145850_b.field_72995_K) {
            return true;
        }
        if (!this.isScreenChunkLoaded()) {
            Util.toast(player, "chunkUnloaded", new Object[0]);
            return true;
        }
        TileEntityScreen tes = this.getConnectedScreen();
        if (tes == null) {
            Util.toast(player, "notLinked", new Object[0]);
            return true;
        }
        TileEntityScreen.Screen scr = tes.getScreen(this.screenSide);
        if ((scr.rightsFor(player) & 1) == 0) {
            Util.toast(player, "restrictions", new Object[0]);
            return true;
        }
        new RedstoneCtrlData(this.field_145850_b.field_73011_w.getDimension(), this.field_174879_c, this.risingEdgeURL, this.fallingEdgeURL).sendTo((EntityPlayerMP)player);
        return true;
    }

    @Override
    public void onNeighborChange() {
        boolean hasPower;
        boolean bl = hasPower = this.field_145850_b.func_175640_z(this.field_174879_c) || this.field_145850_b.func_175640_z(this.field_174879_c.func_177984_a());
        if (hasPower != this.state) {
            this.state = hasPower;
            if (this.state) {
                this.changeURL(this.risingEdgeURL);
            } else {
                this.changeURL(this.fallingEdgeURL);
            }
        }
    }

    public void setURLs(String r, String f) {
        this.risingEdgeURL = r.trim();
        this.fallingEdgeURL = f.trim();
        this.func_70296_d();
    }

    private void changeURL(String url) {
        TileEntityScreen tes;
        if (this.field_145850_b.field_72995_K || url.isEmpty()) {
            return;
        }
        if (this.isScreenChunkLoaded() && (tes = this.getConnectedScreen()) != null) {
            tes.setScreenURL(this.screenSide, url);
        }
    }
}

