/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.entity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.montoyo.mcef.api.IBrowser;
import net.montoyo.wd.WebDisplays;
import net.montoyo.wd.block.BlockScreen;
import net.montoyo.wd.core.DefaultUpgrade;
import net.montoyo.wd.core.IUpgrade;
import net.montoyo.wd.core.JSServerRequest;
import net.montoyo.wd.data.ScreenConfigData;
import net.montoyo.wd.net.client.CMessageAddScreen;
import net.montoyo.wd.net.client.CMessageCloseGui;
import net.montoyo.wd.net.client.CMessageJSResponse;
import net.montoyo.wd.net.client.CMessageScreenUpdate;
import net.montoyo.wd.net.server.SMessageRequestTEData;
import net.montoyo.wd.utilities.AABB;
import net.montoyo.wd.utilities.BlockSide;
import net.montoyo.wd.utilities.Log;
import net.montoyo.wd.utilities.NameUUIDPair;
import net.montoyo.wd.utilities.NibbleArray;
import net.montoyo.wd.utilities.Rotation;
import net.montoyo.wd.utilities.ScreenIterator;
import net.montoyo.wd.utilities.Vector2i;
import net.montoyo.wd.utilities.Vector3f;
import net.montoyo.wd.utilities.Vector3i;
import net.montoyo.wd.utilities.VideoType;

public class TileEntityScreen
extends TileEntity {
    private final ArrayList<Screen> screens = new ArrayList();
    private AxisAlignedBB renderBB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    private boolean loaded = true;
    public float ytVolume = Float.POSITIVE_INFINITY;

    public void forEachScreenBlocks(BlockSide side, Consumer<BlockPos> func) {
        Screen scr = this.getScreen(side);
        if (scr != null) {
            ScreenIterator it = new ScreenIterator(this.field_174879_c, side, scr.size);
            while (it.hasNext()) {
                func.accept(it.next());
            }
        }
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void load() {
        this.loaded = true;
    }

    public void unload() {
        for (Screen scr : this.screens) {
            if (scr.browser == null) continue;
            scr.browser.close();
            scr.browser = null;
        }
        this.loaded = false;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        NBTTagList list = tag.func_150295_c("WDScreens", 10);
        if (list.func_82582_d()) {
            return;
        }
        this.screens.clear();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            this.screens.add(Screen.deserialize(list.func_150305_b(i)));
        }
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        NBTTagList list = new NBTTagList();
        for (Screen scr : this.screens) {
            list.func_74742_a((NBTBase)scr.serialize());
        }
        tag.func_74782_a("WDScreens", (NBTBase)list);
        return tag;
    }

    private NetworkRegistry.TargetPoint point() {
        return new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 64.0);
    }

    public Screen addScreen(BlockSide side, Vector2i size, @Nullable Vector2i resolution, @Nullable EntityPlayer owner, boolean sendUpdate) {
        for (Screen scr : this.screens) {
            if (scr.side != side) continue;
            return scr;
        }
        Screen ret = new Screen();
        ret.side = side;
        ret.size = size;
        ret.url = WebDisplays.INSTANCE.homePage;
        ret.friends = new ArrayList();
        ret.friendRights = 51;
        ret.otherRights = 51;
        ret.upgrades = new ArrayList();
        if (owner != null) {
            ret.owner = new NameUUIDPair(owner.func_146103_bH());
            if (side == BlockSide.TOP || side == BlockSide.BOTTOM) {
                int rot = MathHelper.func_76128_c((double)((double)(owner.field_70177_z * 4.0f / 360.0f) + 2.5)) & 3;
                if (side == BlockSide.TOP) {
                    if (rot == 1) {
                        rot = 3;
                    } else if (rot == 3) {
                        rot = 1;
                    }
                }
                ret.rotation = Rotation.values()[rot];
            }
        }
        if (resolution == null || resolution.x < 1 || resolution.y < 1) {
            float psx = (float)size.x * 16.0f - 4.0f;
            float psy = (float)size.y * 16.0f - 4.0f;
            ret.resolution = new Vector2i((int)(psx *= 8.0f), (int)(psy *= 8.0f));
        } else {
            ret.resolution = resolution;
        }
        ret.clampResolution();
        if (!this.field_145850_b.field_72995_K) {
            ret.setupRedstoneStatus(this.field_145850_b, this.field_174879_c);
            if (sendUpdate) {
                WebDisplays.NET_HANDLER.sendToAllAround((IMessage)new CMessageAddScreen(this, ret), this.point());
            }
        }
        this.screens.add(ret);
        if (this.field_145850_b.field_72995_K) {
            this.updateAABB();
        } else {
            this.func_70296_d();
        }
        return ret;
    }

    public Screen getScreen(BlockSide side) {
        for (Screen scr : this.screens) {
            if (scr.side != side) continue;
            return scr;
        }
        return null;
    }

    public int screenCount() {
        return this.screens.size();
    }

    public Screen getScreen(int idx) {
        return this.screens.get(idx);
    }

    public void clear() {
        this.screens.clear();
        if (!this.field_145850_b.field_72995_K) {
            this.func_70296_d();
        }
    }

    public void requestData(EntityPlayerMP ep) {
        if (!this.field_145850_b.field_72995_K) {
            WebDisplays.NET_HANDLER.sendTo((IMessage)new CMessageAddScreen(this), ep);
        }
    }

    public void setScreenURL(BlockSide side, String url) {
        Screen scr = this.getScreen(side);
        if (scr == null) {
            Log.error("Attempt to change URL of non-existing screen on side %s", side.toString());
            return;
        }
        scr.url = url = WebDisplays.applyBlacklist(url);
        scr.videoType = VideoType.getTypeFromURL(url);
        if (this.field_145850_b.field_72995_K) {
            if (scr.browser != null) {
                scr.browser.loadURL(url);
            }
        } else {
            WebDisplays.NET_HANDLER.sendToAllAround((IMessage)CMessageScreenUpdate.setURL(this, side, url), this.point());
            this.func_70296_d();
        }
    }

    public void removeScreen(BlockSide side) {
        int idx = -1;
        for (int i = 0; i < this.screens.size(); ++i) {
            if (this.screens.get((int)i).side != side) continue;
            idx = i;
            break;
        }
        if (idx < 0) {
            Log.error("Tried to delete non-existing screen on side %s", side.toString());
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            if (this.screens.get((int)idx).browser != null) {
                this.screens.get((int)idx).browser.close();
                this.screens.get((int)idx).browser = null;
            }
        } else {
            WebDisplays.NET_HANDLER.sendToAllAround((IMessage)new CMessageScreenUpdate(this, side), this.point());
        }
        this.screens.remove(idx);
        if (!this.field_145850_b.field_72995_K) {
            if (this.screens.isEmpty()) {
                this.field_145850_b.func_175656_a(this.field_174879_c, WebDisplays.INSTANCE.blockScreen.func_176223_P().func_177226_a((IProperty)BlockScreen.hasTE, (Comparable)Boolean.valueOf(false)));
            } else {
                this.func_70296_d();
            }
        }
    }

    public void setResolution(BlockSide side, Vector2i res) {
        if (res.x < 1 || res.y < 1) {
            Log.warning("Call to TileEntityScreen.setResolution(%s) with suspicious values X=%d and Y=%d", side.toString(), res.x, res.y);
            return;
        }
        Screen scr = this.getScreen(side);
        if (scr == null) {
            Log.error("Tried to change resolution of non-existing screen on side %s", side.toString());
            return;
        }
        scr.resolution = res;
        scr.clampResolution();
        if (this.field_145850_b.field_72995_K) {
            WebDisplays.PROXY.screenUpdateResolutionInGui(new Vector3i(this.field_174879_c), side, res);
            if (scr.browser != null) {
                scr.browser.close();
                scr.browser = null;
            }
        } else {
            WebDisplays.NET_HANDLER.sendToAllAround((IMessage)CMessageScreenUpdate.setResolution(this, side, res), this.point());
            this.func_70296_d();
        }
    }

    private static EntityPlayer getLaserUser(Screen scr) {
        if (scr.laserUser != null && (scr.laserUser.field_70128_L || scr.laserUser.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() != WebDisplays.INSTANCE.itemLaserPointer)) {
            scr.laserUser = null;
        }
        return scr.laserUser;
    }

    private static void checkLaserUserRights(Screen scr) {
        if (scr.laserUser != null && (scr.rightsFor(scr.laserUser) & 2) == 0) {
            scr.laserUser = null;
        }
    }

    public void clearLaserUser(BlockSide side) {
        Screen scr = this.getScreen(side);
        if (scr != null) {
            scr.laserUser = null;
        }
    }

    public void click(BlockSide side, Vector2i vec) {
        Screen scr = this.getScreen(side);
        if (scr == null) {
            Log.error("Attempt click non-existing screen of side %s", side.toString());
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            Log.warning("TileEntityScreen.click() from client side is useless...", new Object[0]);
        } else if (TileEntityScreen.getLaserUser(scr) == null) {
            WebDisplays.NET_HANDLER.sendToAllAround((IMessage)CMessageScreenUpdate.click(this, side, 0, vec), this.point());
        }
    }

    void clickUnsafe(BlockSide side, int action, int x, int y) {
        if (this.field_145850_b.field_72995_K) {
            Vector2i vec = action == 1 ? null : new Vector2i(x, y);
            WebDisplays.NET_HANDLER.sendToAllAround((IMessage)CMessageScreenUpdate.click(this, side, action, vec), this.point());
        }
    }

    public void handleMouseEvent(BlockSide side, int event, @Nullable Vector2i vec) {
        Screen scr = this.getScreen(side);
        if (scr == null) {
            Log.error("Attempt inject mouse events on non-existing screen of side %s", side.toString());
            return;
        }
        if (scr.browser != null) {
            if (event == 0) {
                scr.browser.injectMouseMove(vec.x, vec.y, 0, false);
                scr.browser.injectMouseButton(vec.x, vec.y, 0, 1, true, 1);
                scr.browser.injectMouseButton(vec.x, vec.y, 0, 1, false, 1);
            } else if (event == 3) {
                scr.browser.injectMouseMove(vec.x, vec.y, 0, false);
                scr.browser.injectMouseButton(vec.x, vec.y, 0, 1, true, 1);
            } else if (event == 2) {
                scr.browser.injectMouseMove(vec.x, vec.y, 0, false);
            } else if (event == 1) {
                scr.browser.injectMouseButton(scr.lastMousePos.x, scr.lastMousePos.y, 0, 1, false, 1);
            }
            if (vec != null) {
                scr.lastMousePos.x = vec.x;
                scr.lastMousePos.y = vec.y;
            }
        }
    }

    public void updateJSRedstone(BlockSide side, Vector2i vec, int redstoneLevel) {
        Screen scr = this.getScreen(side);
        if (scr == null) {
            Log.error("Called updateJSRedstone on non-existing side %s", side.toString());
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            if (scr.browser != null) {
                scr.browser.runJS("if(typeof webdisplaysRedstoneCallback == \"function\") webdisplaysRedstoneCallback(" + vec.x + ", " + vec.y + ", " + redstoneLevel + ");", "");
            }
        } else {
            boolean sendMsg = false;
            if (scr.redstoneStatus == null) {
                scr.setupRedstoneStatus(this.field_145850_b, this.field_174879_c);
                sendMsg = true;
            } else {
                int idx = vec.y * scr.size.x + vec.x;
                if (scr.redstoneStatus.get(idx) != redstoneLevel) {
                    scr.redstoneStatus.set(idx, redstoneLevel);
                    sendMsg = true;
                }
            }
            if (sendMsg) {
                WebDisplays.NET_HANDLER.sendToAllAround((IMessage)CMessageScreenUpdate.jsRedstone(this, side, vec, redstoneLevel), this.point());
            }
        }
    }

    public void handleJSRequest(EntityPlayerMP src, BlockSide side, int reqId, JSServerRequest req, Object[] data) {
        if (this.field_145850_b.field_72995_K) {
            Log.error("Called handleJSRequest client-side", new Object[0]);
            return;
        }
        Screen scr = this.getScreen(side);
        if (scr == null) {
            Log.error("Called handleJSRequest on non-existing side %s", side.toString());
            WebDisplays.NET_HANDLER.sendTo((IMessage)new CMessageJSResponse(reqId, req, 403, "Invalid side"), src);
            return;
        }
        if (!scr.owner.uuid.equals(src.func_146103_bH().getId())) {
            Log.warning("Player %s (UUID %s) tries to use the redstone output API on a screen he doesn't own!", src.func_70005_c_(), src.func_146103_bH().getId().toString());
            WebDisplays.NET_HANDLER.sendTo((IMessage)new CMessageJSResponse(reqId, req, 403, "Only the owner can do that"), src);
            return;
        }
        if (scr.upgrades.stream().noneMatch(DefaultUpgrade.REDSTONE_OUTPUT::matches)) {
            WebDisplays.NET_HANDLER.sendTo((IMessage)new CMessageJSResponse(reqId, req, 403, "Missing upgrade"), src);
            return;
        }
        if (req == JSServerRequest.CLEAR_REDSTONE) {
            BlockPos.MutableBlockPos mbp = new BlockPos.MutableBlockPos();
            Vector3i vec1 = new Vector3i(this.field_174879_c);
            Vector3i vec2 = new Vector3i();
            for (int y = 0; y < scr.size.y; ++y) {
                vec2.set(vec1);
                for (int x = 0; x < scr.size.x; ++x) {
                    vec2.toBlock(mbp);
                    IBlockState bs = this.field_145850_b.func_180495_p((BlockPos)mbp);
                    if (((Boolean)bs.func_177229_b((IProperty)BlockScreen.emitting)).booleanValue()) {
                        this.field_145850_b.func_175656_a((BlockPos)mbp, bs.func_177226_a((IProperty)BlockScreen.emitting, (Comparable)Boolean.valueOf(false)));
                    }
                    vec2.add(side.right.x, side.right.y, side.right.z);
                }
                vec1.add(side.up.x, side.up.y, side.up.z);
            }
            WebDisplays.NET_HANDLER.sendTo((IMessage)new CMessageJSResponse(reqId, req, new byte[0]), src);
        } else if (req == JSServerRequest.SET_REDSTONE_AT) {
            int x = (Integer)data[0];
            int y = (Integer)data[1];
            boolean state = (Boolean)data[2];
            if (x < 0 || x >= scr.size.x || y < 0 || y >= scr.size.y) {
                WebDisplays.NET_HANDLER.sendTo((IMessage)new CMessageJSResponse(reqId, req, 403, "Out of range"), src);
            } else {
                BlockPos bp = new Vector3i(this.field_174879_c).addMul(side.right, x).addMul(side.up, y).toBlock();
                IBlockState bs = this.field_145850_b.func_180495_p(bp);
                if ((Boolean)bs.func_177229_b((IProperty)BlockScreen.emitting) != state) {
                    this.field_145850_b.func_175656_a(bp, bs.func_177226_a((IProperty)BlockScreen.emitting, (Comparable)Boolean.valueOf(state)));
                }
                WebDisplays.NET_HANDLER.sendTo((IMessage)new CMessageJSResponse(reqId, req, new byte[0]), src);
            }
        } else {
            WebDisplays.NET_HANDLER.sendTo((IMessage)new CMessageJSResponse(reqId, req, 400, "Invalid request"), src);
        }
    }

    public void onLoad() {
        if (this.field_145850_b.field_72995_K) {
            WebDisplays.NET_HANDLER.sendToServer((IMessage)new SMessageRequestTEData(this));
            WebDisplays.PROXY.trackScreen(this, true);
        }
    }

    public void onChunkUnload() {
        if (this.field_145850_b.field_72995_K) {
            WebDisplays.PROXY.trackScreen(this, false);
            for (Screen scr : this.screens) {
                if (scr.browser == null) continue;
                scr.browser.close();
                scr.browser = null;
            }
        }
    }

    private void updateAABB() {
        Vector3i origin = new Vector3i(this.field_174879_c);
        Vector3i tmp = new Vector3i();
        AABB aabb = new AABB(origin);
        for (Screen scr : this.screens) {
            tmp.set(origin);
            tmp.addMul(scr.side.right, scr.size.x);
            tmp.addMul(scr.side.up, scr.size.y);
            tmp.add(scr.side.forward);
            aabb.expand(tmp);
        }
        this.renderBB = aabb.toMc().func_72314_b(0.1, 0.1, 0.1);
    }

    @Nonnull
    public AxisAlignedBB getRenderBoundingBox() {
        return this.renderBB;
    }

    public void updateTrackDistance(double d, float masterVolume) {
        boolean needsComputation = true;
        int intPart = 0;
        int fracPart = 0;
        for (Screen scr : this.screens) {
            if (scr.videoType == null || scr.browser == null || scr.browser.isPageLoading()) continue;
            if (needsComputation) {
                float dist = (float)Math.sqrt(d);
                float vol = dist <= 10.0f ? masterVolume * WebDisplays.INSTANCE.ytVolume : (dist >= 30.0f ? 0.0f : (1.0f - (dist - 10.0f) / 20.0f) * masterVolume * WebDisplays.INSTANCE.ytVolume);
                if (Math.abs(this.ytVolume - vol) < 0.5f) {
                    return;
                }
                this.ytVolume = vol;
                intPart = (int)vol;
                fracPart = (int)(vol * 100.0f) - intPart * 100;
                needsComputation = false;
            }
            scr.browser.runJS(scr.videoType.getVolumeJSQuery(intPart, fracPart), "");
        }
    }

    public void updateClientSideURL(IBrowser target, String url) {
        for (Screen scr : this.screens) {
            if (scr.browser != target) continue;
            boolean blacklisted = WebDisplays.isSiteBlacklisted(url);
            scr.url = blacklisted ? "mod://webdisplays/blacklisted.html" : url;
            scr.videoType = VideoType.getTypeFromURL(scr.url);
            this.ytVolume = Float.POSITIVE_INFINITY;
            if (!blacklisted || scr.browser == null) break;
            scr.browser.loadURL("mod://webdisplays/blacklisted.html");
            break;
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b.field_72995_K) {
            this.onChunkUnload();
        }
    }

    public void addFriend(EntityPlayerMP ply, BlockSide side, NameUUIDPair pair) {
        if (!this.field_145850_b.field_72995_K) {
            Screen scr = this.getScreen(side);
            if (scr == null) {
                Log.error("Tried to add friend to invalid screen side %s", side.toString());
                return;
            }
            if (!scr.friends.contains(pair)) {
                scr.friends.add(pair);
                new ScreenConfigData(new Vector3i(this.field_174879_c), side, scr).updateOnly().sendTo(this.point());
                this.func_70296_d();
            }
        }
    }

    public void removeFriend(EntityPlayerMP ply, BlockSide side, NameUUIDPair pair) {
        if (!this.field_145850_b.field_72995_K) {
            Screen scr = this.getScreen(side);
            if (scr == null) {
                Log.error("Tried to remove friend from invalid screen side %s", side.toString());
                return;
            }
            if (scr.friends.remove(pair)) {
                TileEntityScreen.checkLaserUserRights(scr);
                new ScreenConfigData(new Vector3i(this.field_174879_c), side, scr).updateOnly().sendTo(this.point());
                this.func_70296_d();
            }
        }
    }

    public void setRights(EntityPlayerMP ply, BlockSide side, int fr, int or) {
        if (!this.field_145850_b.field_72995_K) {
            Screen scr = this.getScreen(side);
            if (scr == null) {
                Log.error("Tried to change rights of invalid screen on side %s", side.toString());
                return;
            }
            scr.friendRights = fr;
            scr.otherRights = or;
            TileEntityScreen.checkLaserUserRights(scr);
            new ScreenConfigData(new Vector3i(this.field_174879_c), side, scr).updateOnly().sendTo(this.point());
            this.func_70296_d();
        }
    }

    public void type(BlockSide side, String text, BlockPos soundPos) {
        Screen scr = this.getScreen(side);
        if (scr == null) {
            Log.error("Tried to type on invalid screen on side %s", side.toString());
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            if (scr.browser != null) {
                try {
                    String[] events;
                    for (String ev : events = text.split("\u0001")) {
                        char action = ev.charAt(0);
                        if (action == 'p') {
                            scr.browser.injectKeyPressed(ev.charAt(1), 0);
                            continue;
                        }
                        if (action == 'r') {
                            scr.browser.injectKeyReleased(ev.charAt(1), 0);
                            continue;
                        }
                        if (action == 't') {
                            for (int i = 1; i < ev.length(); ++i) {
                                scr.browser.injectKeyTyped(ev.charAt(i), 0);
                            }
                            continue;
                        }
                        throw new RuntimeException("Invalid control key '" + action + '\'');
                    }
                }
                catch (Throwable t) {
                    Log.warningEx("Suspicious keyboard type packet received...", t, new Object[0]);
                }
            }
        } else {
            WebDisplays.NET_HANDLER.sendToAllAround((IMessage)CMessageScreenUpdate.type(this, side, text), this.point());
            if (soundPos != null) {
                this.playSoundAt(WebDisplays.INSTANCE.soundTyping, soundPos, 0.25f, 1.0f);
            }
        }
    }

    private void playSoundAt(SoundEvent snd, BlockPos at, float vol, float pitch) {
        double x = at.func_177958_n();
        double y = at.func_177956_o();
        double z = at.func_177952_p();
        this.field_145850_b.func_184148_a(null, x + 0.5, y + 0.5, z + 0.5, snd, SoundCategory.BLOCKS, vol, pitch);
    }

    public void updateUpgrades(BlockSide side, ItemStack[] upgrades) {
        if (!this.field_145850_b.field_72995_K) {
            Log.error("Tried to call TileEntityScreen.updateUpgrades() from server side...", new Object[0]);
            return;
        }
        Screen scr = this.getScreen(side);
        if (scr == null) {
            Log.error("Tried to update upgrades on invalid screen on side %s", side.toString());
            return;
        }
        scr.upgrades.clear();
        Collections.addAll(scr.upgrades, upgrades);
        if (scr.browser != null) {
            scr.browser.runJS("if(typeof webdisplaysUpgradesChanged == \"function\") webdisplaysUpgradesChanged();", "");
        }
    }

    private static String safeName(ItemStack is) {
        ResourceLocation rl = is.func_77973_b().getRegistryName();
        return rl == null ? "[NO NAME, WTF?!]" : rl.toString();
    }

    public boolean addUpgrade(BlockSide side, ItemStack is, @Nullable EntityPlayer player, boolean abortIfExisting) {
        if (this.field_145850_b.field_72995_K) {
            return false;
        }
        Screen scr = this.getScreen(side);
        if (scr == null) {
            Log.error("Tried to add an upgrade on invalid screen on side %s", side.toString());
            return false;
        }
        if (!(is.func_77973_b() instanceof IUpgrade)) {
            Log.error("Tried to add a non-upgrade item %s to screen (%s does not implement IUpgrade)", TileEntityScreen.safeName(is), is.func_77973_b().getClass().getCanonicalName());
            return false;
        }
        if (scr.upgrades.size() >= 16) {
            Log.error("Can't insert upgrade %s in screen %s at %s: too many upgrades already!", TileEntityScreen.safeName(is), side.toString(), this.field_174879_c.toString());
            return false;
        }
        IUpgrade itemAsUpgrade = (IUpgrade)is.func_77973_b();
        if (abortIfExisting && scr.upgrades.stream().anyMatch(otherStack -> itemAsUpgrade.isSameUpgrade(is, (ItemStack)otherStack))) {
            return false;
        }
        ItemStack isCopy = is.func_77946_l();
        isCopy.field_77994_a = 1;
        scr.upgrades.add(isCopy);
        WebDisplays.NET_HANDLER.sendToAllAround((IMessage)CMessageScreenUpdate.upgrade(this, side), this.point());
        itemAsUpgrade.onInstall(this, side, player, isCopy);
        this.playSoundAt(WebDisplays.INSTANCE.soundUpgradeAdd, this.field_174879_c, 1.0f, 1.0f);
        this.func_70296_d();
        return true;
    }

    public boolean hasUpgrade(BlockSide side, ItemStack is) {
        Screen scr = this.getScreen(side);
        if (scr == null) {
            return false;
        }
        if (!(is.func_77973_b() instanceof IUpgrade)) {
            return false;
        }
        IUpgrade itemAsUpgrade = (IUpgrade)is.func_77973_b();
        return scr.upgrades.stream().anyMatch(otherStack -> itemAsUpgrade.isSameUpgrade(is, (ItemStack)otherStack));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasUpgrade(BlockSide side, DefaultUpgrade du) {
        Screen scr = this.getScreen(side);
        if (scr == null) return false;
        if (!scr.upgrades.stream().anyMatch(du::matches)) return false;
        return true;
    }

    public void removeUpgrade(BlockSide side, ItemStack is, @Nullable EntityPlayer player) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        Screen scr = this.getScreen(side);
        if (scr == null) {
            Log.error("Tried to remove an upgrade on invalid screen on side %s", side.toString());
            return;
        }
        if (!(is.func_77973_b() instanceof IUpgrade)) {
            Log.error("Tried to remove a non-upgrade item %s to screen (%s does not implement IUpgrade)", TileEntityScreen.safeName(is), is.func_77973_b().getClass().getCanonicalName());
            return;
        }
        int idxToRemove = -1;
        IUpgrade itemAsUpgrade = (IUpgrade)is.func_77973_b();
        for (int i = 0; i < scr.upgrades.size(); ++i) {
            if (!itemAsUpgrade.isSameUpgrade(is, scr.upgrades.get(i))) continue;
            idxToRemove = i;
            break;
        }
        if (idxToRemove >= 0) {
            this.dropUpgrade(scr.upgrades.get(idxToRemove), side, player);
            scr.upgrades.remove(idxToRemove);
            WebDisplays.NET_HANDLER.sendToAllAround((IMessage)CMessageScreenUpdate.upgrade(this, side), this.point());
            this.playSoundAt(WebDisplays.INSTANCE.soundUpgradeDel, this.field_174879_c, 1.0f, 1.0f);
            this.func_70296_d();
        } else {
            Log.warning("Tried to remove non-existing upgrade %s to screen %s at %s", TileEntityScreen.safeName(is), side.toString(), this.field_174879_c.toString());
        }
    }

    private void dropUpgrade(ItemStack is, BlockSide side, @Nullable EntityPlayer ply) {
        if (!((IUpgrade)is.func_77973_b()).onRemove(this, side, ply, is)) {
            boolean spawnDrop = true;
            if (ply != null && (ply.func_184812_l_() || ply.field_71071_by.func_70441_a(is))) {
                spawnDrop = false;
            }
            if (spawnDrop) {
                Vector3f pos = new Vector3f(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
                pos.addMul(side.backward.toFloat(), 1.5f);
                this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)pos.x, (double)pos.y, (double)pos.z, is));
            }
        }
    }

    private Screen getScreenForLaserOp(BlockSide side, EntityPlayer ply) {
        if (this.field_145850_b.field_72995_K) {
            return null;
        }
        Screen scr = this.getScreen(side);
        if (scr == null) {
            Log.error("Called laser operation on invalid screen on side %s", side.toString());
            return null;
        }
        if ((scr.rightsFor(ply) & 2) == 0) {
            return null;
        }
        if (scr.upgrades.stream().noneMatch(DefaultUpgrade.LASER_MOUSE::matches)) {
            Log.error("Called laser operation on side %s, but it's missing the laser sensor upgrade", side.toString());
            return null;
        }
        return scr;
    }

    public void laserDownMove(BlockSide side, EntityPlayer ply, Vector2i pos, boolean down) {
        Screen scr = this.getScreenForLaserOp(side, ply);
        if (scr != null) {
            if (down) {
                if (TileEntityScreen.getLaserUser(scr) == null) {
                    scr.laserUser = ply;
                    WebDisplays.NET_HANDLER.sendToAllAround((IMessage)CMessageScreenUpdate.click(this, side, 3, pos), this.point());
                }
            } else if (TileEntityScreen.getLaserUser(scr) == ply) {
                WebDisplays.NET_HANDLER.sendToAllAround((IMessage)CMessageScreenUpdate.click(this, side, 2, pos), this.point());
            }
        }
    }

    public void laserUp(BlockSide side, EntityPlayer ply) {
        Screen scr = this.getScreenForLaserOp(side, ply);
        if (scr != null && TileEntityScreen.getLaserUser(scr) == ply) {
            scr.laserUser = null;
            WebDisplays.NET_HANDLER.sendToAllAround((IMessage)CMessageScreenUpdate.click(this, side, 1, null), this.point());
        }
    }

    public void onDestroy(@Nullable EntityPlayer ply) {
        for (Screen scr : this.screens) {
            scr.upgrades.forEach(is -> this.dropUpgrade((ItemStack)is, scr.side, ply));
            scr.upgrades.clear();
        }
        WebDisplays.NET_HANDLER.sendToAllAround((IMessage)new CMessageCloseGui(this.field_174879_c), this.point());
    }

    public void setOwner(BlockSide side, EntityPlayer newOwner) {
        if (this.field_145850_b.field_72995_K) {
            Log.error("Called TileEntityScreen.setOwner() on client...", new Object[0]);
            return;
        }
        if (newOwner == null) {
            Log.error("Called TileEntityScreen.setOwner() with null owner", new Object[0]);
            return;
        }
        Screen scr = this.getScreen(side);
        if (scr == null) {
            Log.error("Called TileEntityScreen.setOwner() on invalid screen on side %s", side.toString());
            return;
        }
        scr.owner = new NameUUIDPair(newOwner.func_146103_bH());
        WebDisplays.NET_HANDLER.sendToAllAround((IMessage)CMessageScreenUpdate.owner(this, side, scr.owner), this.point());
        TileEntityScreen.checkLaserUserRights(scr);
        this.func_70296_d();
    }

    public void setRotation(BlockSide side, Rotation rot) {
        Screen scr = this.getScreen(side);
        if (scr == null) {
            Log.error("Trying to change rotation of invalid screen on side %s", side.toString());
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            boolean oldWasVertical = scr.rotation.isVertical;
            scr.rotation = rot;
            WebDisplays.PROXY.screenUpdateRotationInGui(new Vector3i(this.field_174879_c), side, rot);
            if (scr.browser != null && oldWasVertical != rot.isVertical) {
                scr.browser.close();
                scr.browser = null;
            }
        } else {
            scr.rotation = rot;
            WebDisplays.NET_HANDLER.sendToAllAround((IMessage)CMessageScreenUpdate.rotation(this, side, rot), this.point());
            this.func_70296_d();
        }
    }

    public void evalJS(BlockSide side, String code) {
        Screen scr = this.getScreen(side);
        if (scr == null) {
            Log.error("Trying to run JS code on invalid screen on side %s", side.toString());
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            if (scr.browser != null) {
                scr.browser.runJS(code, "");
            }
        } else {
            WebDisplays.NET_HANDLER.sendToAllAround((IMessage)CMessageScreenUpdate.js(this, side, code), this.point());
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, @Nonnull IBlockState oldState, @Nonnull IBlockState newState) {
        if (oldState.func_177230_c() != WebDisplays.INSTANCE.blockScreen || newState.func_177230_c() != WebDisplays.INSTANCE.blockScreen) {
            return true;
        }
        return oldState.func_177229_b((IProperty)BlockScreen.hasTE) != newState.func_177229_b((IProperty)BlockScreen.hasTE);
    }

    public static class Screen {
        public BlockSide side;
        public Vector2i size;
        public Vector2i resolution;
        public Rotation rotation = Rotation.ROT_0;
        public String url;
        private VideoType videoType;
        public NameUUIDPair owner;
        public ArrayList<NameUUIDPair> friends;
        public int friendRights;
        public int otherRights;
        public IBrowser browser;
        public ArrayList<ItemStack> upgrades;
        public boolean doTurnOnAnim;
        public long turnOnTime;
        public EntityPlayer laserUser;
        public final Vector2i lastMousePos = new Vector2i();
        public NibbleArray redstoneStatus;

        public static Screen deserialize(NBTTagCompound tag) {
            Screen ret = new Screen();
            ret.side = BlockSide.values()[tag.func_74771_c("Side")];
            ret.size = new Vector2i(tag.func_74762_e("Width"), tag.func_74762_e("Height"));
            ret.resolution = new Vector2i(tag.func_74762_e("ResolutionX"), tag.func_74762_e("ResolutionY"));
            ret.rotation = Rotation.values()[tag.func_74771_c("Rotation")];
            ret.url = tag.func_74779_i("URL");
            ret.videoType = VideoType.getTypeFromURL(ret.url);
            if (ret.resolution.x <= 0 || ret.resolution.y <= 0) {
                float psx = (float)ret.size.x * 16.0f - 4.0f;
                float psy = (float)ret.size.y * 16.0f - 4.0f;
                ret.resolution.x = (int)(psx *= 8.0f);
                ret.resolution.y = (int)(psy *= 8.0f);
            }
            if (tag.func_74764_b("OwnerName")) {
                String name = tag.func_74779_i("OwnerName");
                UUID uuid = tag.func_186857_a("OwnerUUID");
                ret.owner = new NameUUIDPair(name, uuid);
            }
            NBTTagList friends = tag.func_150295_c("Friends", 10);
            ret.friends = new ArrayList(friends.func_74745_c());
            for (int i = 0; i < friends.func_74745_c(); ++i) {
                NBTTagCompound nf = friends.func_150305_b(i);
                NameUUIDPair pair = new NameUUIDPair(nf.func_74779_i("Name"), nf.func_186857_a("UUID"));
                ret.friends.add(pair);
            }
            ret.friendRights = tag.func_74771_c("FriendRights");
            ret.otherRights = tag.func_74771_c("OtherRights");
            NBTTagList upgrades = tag.func_150295_c("Upgrades", 10);
            ret.upgrades = new ArrayList();
            for (int i = 0; i < upgrades.func_74745_c(); ++i) {
                ret.upgrades.add(ItemStack.func_77949_a((NBTTagCompound)upgrades.func_150305_b(i)));
            }
            return ret;
        }

        public NBTTagCompound serialize() {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Side", (byte)this.side.ordinal());
            tag.func_74768_a("Width", this.size.x);
            tag.func_74768_a("Height", this.size.y);
            tag.func_74768_a("ResolutionX", this.resolution.x);
            tag.func_74768_a("ResolutionY", this.resolution.y);
            tag.func_74774_a("Rotation", (byte)this.rotation.ordinal());
            tag.func_74778_a("URL", this.url);
            if (this.owner == null) {
                Log.warning("Found TES with NO OWNER!!", new Object[0]);
            } else {
                tag.func_74778_a("OwnerName", this.owner.name);
                tag.func_186854_a("OwnerUUID", this.owner.uuid);
            }
            NBTTagList list = new NBTTagList();
            for (NameUUIDPair f : this.friends) {
                NBTTagCompound nf = new NBTTagCompound();
                nf.func_74778_a("Name", f.name);
                nf.func_186854_a("UUID", f.uuid);
                list.func_74742_a((NBTBase)nf);
            }
            tag.func_74782_a("Friends", (NBTBase)list);
            tag.func_74774_a("FriendRights", (byte)this.friendRights);
            tag.func_74774_a("OtherRights", (byte)this.otherRights);
            list = new NBTTagList();
            for (ItemStack is : this.upgrades) {
                list.func_74742_a((NBTBase)is.func_77955_b(new NBTTagCompound()));
            }
            tag.func_74782_a("Upgrades", (NBTBase)list);
            return tag;
        }

        public int rightsFor(EntityPlayer ply) {
            return this.rightsFor(ply.func_146103_bH().getId());
        }

        public int rightsFor(UUID uuid) {
            if (this.owner.uuid.equals(uuid)) {
                return 255;
            }
            return this.friends.stream().anyMatch(f -> f.uuid.equals(uuid)) ? this.friendRights : this.otherRights;
        }

        public void setupRedstoneStatus(World world, BlockPos start) {
            if (world.field_72995_K) {
                Log.warning("Called Screen.setupRedstoneStatus() on client.", new Object[0]);
                return;
            }
            if (this.redstoneStatus != null) {
                Log.warning("Called Screen.setupRedstoneStatus() on server, but redstone status is non-null", new Object[0]);
                return;
            }
            this.redstoneStatus = new NibbleArray(this.size.x * this.size.y);
            EnumFacing facing = EnumFacing.field_82609_l[this.side.reverse().ordinal()];
            ScreenIterator it = new ScreenIterator(start, this.side, this.size);
            while (it.hasNext()) {
                int idx = it.getIndex();
                this.redstoneStatus.set(idx, world.func_175651_c(it.next(), facing));
            }
        }

        public void clampResolution() {
            if (this.resolution.x > WebDisplays.INSTANCE.maxResX) {
                float newY = (float)this.resolution.y * (float)WebDisplays.INSTANCE.maxResX / (float)this.resolution.x;
                this.resolution.x = WebDisplays.INSTANCE.maxResX;
                this.resolution.y = (int)newY;
            }
            if (this.resolution.y > WebDisplays.INSTANCE.maxResY) {
                float newX = (float)this.resolution.x * (float)WebDisplays.INSTANCE.maxResY / (float)this.resolution.y;
                this.resolution.x = (int)newX;
                this.resolution.y = WebDisplays.INSTANCE.maxResY;
            }
        }
    }
}

