/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.item;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.montoyo.wd.WebDisplays;
import net.montoyo.wd.block.BlockScreen;
import net.montoyo.wd.core.IPeripheral;
import net.montoyo.wd.entity.TileEntityScreen;
import net.montoyo.wd.item.WDItem;
import net.montoyo.wd.utilities.BlockSide;
import net.montoyo.wd.utilities.Multiblock;
import net.montoyo.wd.utilities.Util;
import net.montoyo.wd.utilities.Vector3i;

public class ItemLinker
extends Item
implements WDItem {
    public ItemLinker() {
        this.func_77655_b("webdisplays.linker");
        this.setRegistryName("linker");
        this.func_77625_d(1);
        this.func_77637_a(WebDisplays.CREATIVE_TAB);
    }

    @Nonnull
    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos_, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null && tag.func_74764_b("ScreenX") && tag.func_74764_b("ScreenY") && tag.func_74764_b("ScreenZ") && tag.func_74764_b("ScreenSide")) {
            IPeripheral target;
            IBlockState state = world.func_180495_p(pos_);
            if (state.func_177230_c() instanceof IPeripheral) {
                target = (IPeripheral)state.func_177230_c();
            } else {
                TileEntity te = world.func_175625_s(pos_);
                if (te == null || !(te instanceof IPeripheral)) {
                    if (player.func_70093_af()) {
                        Util.toast(player, TextFormatting.GOLD, "linkAbort", new Object[0]);
                        stack.func_77982_d(null);
                    } else {
                        Util.toast(player, "peripheral", new Object[0]);
                    }
                    return EnumActionResult.SUCCESS;
                }
                target = (IPeripheral)te;
            }
            Vector3i tePos = new Vector3i(tag.func_74762_e("ScreenX"), tag.func_74762_e("ScreenY"), tag.func_74762_e("ScreenZ"));
            BlockSide scrSide = BlockSide.values()[tag.func_74771_c("ScreenSide")];
            if (target.connect(world, pos_, state, tePos, scrSide)) {
                Util.toast(player, TextFormatting.AQUA, "linked", new Object[0]);
            } else {
                Util.toast(player, "linkError", new Object[0]);
            }
            stack.func_77982_d(null);
            return EnumActionResult.SUCCESS;
        }
        if (!(world.func_180495_p(pos_).func_177230_c() instanceof BlockScreen)) {
            Util.toast(player, "notAScreen", new Object[0]);
            return EnumActionResult.SUCCESS;
        }
        Vector3i pos = new Vector3i(pos_);
        BlockSide side = BlockSide.values()[facing.ordinal()];
        Multiblock.findOrigin((IBlockAccess)world, pos, side, null);
        TileEntity te = world.func_175625_s(pos.toBlock());
        if (te == null || !(te instanceof TileEntityScreen)) {
            Util.toast(player, "turnOn", new Object[0]);
            return EnumActionResult.SUCCESS;
        }
        TileEntityScreen.Screen scr = ((TileEntityScreen)te).getScreen(side);
        if (scr == null) {
            Util.toast(player, "turnOn", new Object[0]);
        } else if ((scr.rightsFor(player) & 0x10) == 0) {
            Util.toast(player, "restrictions", new Object[0]);
        } else {
            tag = new NBTTagCompound();
            tag.func_74768_a("ScreenX", pos.x);
            tag.func_74768_a("ScreenY", pos.y);
            tag.func_74768_a("ScreenZ", pos.z);
            tag.func_74774_a("ScreenSide", (byte)side.ordinal());
            stack.func_77982_d(tag);
            Util.toast(player, TextFormatting.AQUA, "screenSet2", new Object[0]);
        }
        return EnumActionResult.SUCCESS;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer ply, List<String> tt, boolean ttFlags) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null && tag.func_74764_b("ScreenX") && tag.func_74764_b("ScreenY") && tag.func_74764_b("ScreenZ") && tag.func_74764_b("ScreenSide")) {
            BlockSide side = BlockSide.fromInt(tag.func_74771_c("ScreenSide"));
            if (side == null) {
                side = BlockSide.BOTTOM;
            }
            tt.add(I18n.func_135052_a((String)"webdisplays.linker.selectPeripheral", (Object[])new Object[0]));
            tt.add(I18n.func_135052_a((String)"webdisplays.linker.posInfo", (Object[])new Object[]{tag.func_74762_e("ScreenX"), tag.func_74762_e("ScreenY"), tag.func_74762_e("ScreenZ")}));
            tt.add(I18n.func_135052_a((String)"webdisplays.linker.sideInfo", (Object[])new Object[]{I18n.func_135052_a((String)("webdisplays.side." + side.toString().toLowerCase()), (Object[])new Object[0])}));
            WDItem.addInformation(tt);
            return;
        }
        tt.add(I18n.func_135052_a((String)"webdisplays.linker.selectScreen", (Object[])new Object[0]));
        WDItem.addInformation(tt);
    }

    @Override
    @Nullable
    public String getWikiName(@Nonnull ItemStack is) {
        return "Linking_Tool";
    }
}

