/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.net;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.montoyo.wd.net.DefaultHandler;
import net.montoyo.wd.net.Message;
import net.montoyo.wd.net.client.CMessageACResult;
import net.montoyo.wd.net.client.CMessageAchievement;
import net.montoyo.wd.net.client.CMessageAddScreen;
import net.montoyo.wd.net.client.CMessageCloseGui;
import net.montoyo.wd.net.client.CMessageJSResponse;
import net.montoyo.wd.net.client.CMessageMiniservKey;
import net.montoyo.wd.net.client.CMessageOpenGui;
import net.montoyo.wd.net.client.CMessageScreenUpdate;
import net.montoyo.wd.net.client.CMessageServerInfo;
import net.montoyo.wd.net.server.SMessageACQuery;
import net.montoyo.wd.net.server.SMessageMiniservConnect;
import net.montoyo.wd.net.server.SMessagePadCtrl;
import net.montoyo.wd.net.server.SMessageRedstoneCtrl;
import net.montoyo.wd.net.server.SMessageRequestTEData;
import net.montoyo.wd.net.server.SMessageScreenCtrl;

public abstract class Messages {
    private static final DefaultHandler DEFAULT_HANDLER = new DefaultHandler();
    private static final Class<? extends IMessage>[] MESSAGES;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void registerAll(SimpleNetworkWrapper wrapper) {
        for (Class<? extends IMessage> md : MESSAGES) {
            IMessageHandler handlerInst;
            Message data = md.getAnnotation(Message.class);
            if (data == null) {
                throw new RuntimeException("Missing @Message annotation for message class " + md.getSimpleName());
            }
            Class<?>[] classes = md.getClasses();
            Class<?> handler = null;
            for (Class<?> cls : classes) {
                if (!cls.getSimpleName().equals("Handler") || !Modifier.isStatic(cls.getModifiers()) || !IMessageHandler.class.isAssignableFrom(cls)) continue;
                handler = cls;
                break;
            }
            if (handler == null) {
                if (!Runnable.class.isAssignableFrom(md)) throw new RuntimeException("Could not find message handler for message " + md.getSimpleName());
                handlerInst = DEFAULT_HANDLER;
            } else {
                try {
                    handlerInst = (IMessageHandler)handler.newInstance();
                }
                catch (Throwable t) {
                    throw new RuntimeException("Could not instantiate message handler for message " + md.getSimpleName());
                }
            }
            wrapper.registerMessage(handlerInst, md, data.messageId(), data.side());
        }
    }

    static {
        ArrayList<Class<CMessageAchievement>> l = new ArrayList<Class<CMessageAchievement>>();
        l.add(CMessageAddScreen.class);
        l.add(SMessageRequestTEData.class);
        l.add(SMessageScreenCtrl.class);
        l.add(CMessageOpenGui.class);
        l.add(CMessageScreenUpdate.class);
        l.add(SMessageACQuery.class);
        l.add(CMessageACResult.class);
        l.add(SMessagePadCtrl.class);
        l.add(SMessageRedstoneCtrl.class);
        l.add(CMessageJSResponse.class);
        l.add(SMessageMiniservConnect.class);
        l.add(CMessageMiniservKey.class);
        l.add(CMessageServerInfo.class);
        l.add(CMessageCloseGui.class);
        l.add(CMessageAchievement.class);
        MESSAGES = l.toArray(new Class[0]);
    }
}

