/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.net.client;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.montoyo.wd.WebDisplays;
import net.montoyo.wd.entity.TileEntityScreen;
import net.montoyo.wd.net.Message;
import net.montoyo.wd.utilities.BlockSide;
import net.montoyo.wd.utilities.Log;
import net.montoyo.wd.utilities.NameUUIDPair;
import net.montoyo.wd.utilities.Rotation;
import net.montoyo.wd.utilities.Vector2i;
import net.montoyo.wd.utilities.Vector3i;

@Message(messageId=0, side=Side.CLIENT)
public class CMessageAddScreen
implements IMessage,
Runnable {
    private boolean clear;
    private Vector3i pos;
    private TileEntityScreen.Screen[] screens;

    public CMessageAddScreen() {
    }

    public CMessageAddScreen(TileEntityScreen tes) {
        this.clear = true;
        this.pos = new Vector3i(tes.func_174877_v());
        this.screens = new TileEntityScreen.Screen[tes.screenCount()];
        for (int i = 0; i < tes.screenCount(); ++i) {
            this.screens[i] = tes.getScreen(i);
        }
    }

    public CMessageAddScreen(TileEntityScreen tes, TileEntityScreen.Screen ... toSend) {
        this.clear = false;
        this.pos = new Vector3i(tes.func_174877_v());
        this.screens = toSend;
    }

    public void fromBytes(ByteBuf buf) {
        this.clear = buf.readBoolean();
        this.pos = new Vector3i(buf);
        int cnt = buf.readByte() & 7;
        this.screens = new TileEntityScreen.Screen[cnt];
        for (int i = 0; i < cnt; ++i) {
            this.screens[i] = new TileEntityScreen.Screen();
            this.screens[i].side = BlockSide.values()[buf.readByte()];
            this.screens[i].size = new Vector2i(buf);
            this.screens[i].url = ByteBufUtils.readUTF8String((ByteBuf)buf);
            this.screens[i].resolution = new Vector2i(buf);
            this.screens[i].rotation = Rotation.values()[buf.readByte() & 3];
            this.screens[i].owner = new NameUUIDPair(buf);
            this.screens[i].upgrades = new ArrayList();
            int numUpgrades = buf.readByte();
            for (int j = 0; j < numUpgrades; ++j) {
                this.screens[i].upgrades.add(ByteBufUtils.readItemStack((ByteBuf)buf));
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.clear);
        this.pos.writeTo(buf);
        buf.writeByte(this.screens.length);
        for (TileEntityScreen.Screen scr : this.screens) {
            buf.writeByte(scr.side.ordinal());
            scr.size.writeTo(buf);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)scr.url);
            scr.resolution.writeTo(buf);
            buf.writeByte(scr.rotation.ordinal());
            scr.owner.writeTo(buf);
            buf.writeByte(scr.upgrades.size());
            for (ItemStack is : scr.upgrades) {
                ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)is);
            }
        }
    }

    @Override
    public void run() {
        TileEntity te = WebDisplays.PROXY.getWorld(Integer.MAX_VALUE).func_175625_s(this.pos.toBlock());
        if (te == null || !(te instanceof TileEntityScreen)) {
            if (this.clear) {
                Log.error("CMessageAddScreen: Can't add screen to invalid tile entity at %s", this.pos.toString());
            }
            return;
        }
        TileEntityScreen tes = (TileEntityScreen)te;
        if (this.clear) {
            tes.clear();
        }
        for (TileEntityScreen.Screen entry : this.screens) {
            TileEntityScreen.Screen scr = tes.addScreen(entry.side, entry.size, entry.resolution, null, false);
            scr.rotation = entry.rotation;
            scr.url = entry.url;
            scr.owner = entry.owner;
            scr.upgrades = entry.upgrades;
            if (scr.browser == null) continue;
            scr.browser.loadURL(entry.url);
        }
    }
}

