/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.utilities;

import net.minecraft.util.math.AxisAlignedBB;
import net.montoyo.wd.utilities.Vector3i;

public final class AABB {
    public final Vector3i start;
    public final Vector3i end;

    public AABB() {
        this.start = new Vector3i();
        this.end = new Vector3i();
    }

    public AABB(Vector3i pos) {
        this.start = pos.clone();
        this.end = pos.clone();
    }

    public AABB(Vector3i a, Vector3i b) {
        this.start = new Vector3i();
        this.end = new Vector3i();
        this.start.x = Math.min(a.x, b.x);
        this.start.y = Math.min(a.y, b.y);
        this.start.z = Math.min(a.z, b.z);
        this.end.x = Math.max(a.x, b.x);
        this.end.y = Math.max(a.y, b.y);
        this.end.z = Math.max(a.z, b.z);
    }

    public AABB(AxisAlignedBB bb) {
        this.start = new Vector3i();
        this.end = new Vector3i();
        this.start.x = (int)bb.field_72340_a;
        this.start.y = (int)bb.field_72338_b;
        this.start.z = (int)bb.field_72339_c;
        this.end.x = (int)Math.ceil(bb.field_72336_d);
        this.end.y = (int)Math.ceil(bb.field_72337_e);
        this.end.z = (int)Math.ceil(bb.field_72334_f);
    }

    public AABB expand(Vector3i vec) {
        if (vec.x > this.end.x) {
            this.end.x = vec.x;
        } else if (vec.x < this.start.x) {
            this.start.x = vec.x;
        }
        if (vec.y > this.end.y) {
            this.end.y = vec.y;
        } else if (vec.y < this.start.y) {
            this.start.y = vec.y;
        }
        if (vec.z > this.end.z) {
            this.end.z = vec.z;
        } else if (vec.z < this.start.z) {
            this.start.z = vec.z;
        }
        return this;
    }

    public AABB move(Vector3i start) {
        this.end.sub(this.start).add(start);
        this.start.set(start);
        return this;
    }

    public AxisAlignedBB toMc() {
        return new AxisAlignedBB((double)this.start.x, (double)this.start.y, (double)this.start.z, (double)this.end.x, (double)this.end.y, (double)this.end.z);
    }
}

