/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.utilities;

public final class NibbleArray {
    private final byte[] data;

    public NibbleArray(int count) {
        if ((count & 1) != 0) {
            ++count;
        }
        this.data = new byte[count >> 1];
    }

    public NibbleArray(byte[] d) {
        this.data = d;
    }

    public final int get(int idx) {
        if ((idx & 1) == 0) {
            return this.data[idx >> 1] >> 4 & 0xF;
        }
        return this.data[idx >> 1] & 0xF;
    }

    public final void set(int idx, int val) {
        this.data[idx >>= 1] = (idx & 1) == 0 ? (byte)(this.data[idx] & 0xF | val << 4) : (byte)(this.data[idx] & 0xF0 | (val &= 0xF));
    }

    public byte[] copyBytes() {
        byte[] ret = new byte[this.data.length];
        System.arraycopy(this.data, 0, ret, 0, this.data.length);
        return ret;
    }
}

