/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.utilities;

import java.util.Iterator;
import net.minecraft.util.math.BlockPos;
import net.montoyo.wd.utilities.BlockSide;
import net.montoyo.wd.utilities.Vector2i;
import net.montoyo.wd.utilities.Vector3i;

public final class ScreenIterator
implements Iterator<BlockPos> {
    private final Vector3i vec1;
    private final Vector3i vec2;
    private final BlockSide side;
    private final Vector2i size;
    private final BlockPos.MutableBlockPos blockPos;
    private int x = 0;
    private int y = 0;
    private boolean hasNext = true;

    public ScreenIterator(BlockPos pos, BlockSide side, Vector2i size) {
        this.vec1 = new Vector3i(pos);
        this.vec2 = this.vec1.clone();
        this.side = side;
        this.size = size;
        this.blockPos = new BlockPos.MutableBlockPos();
    }

    @Override
    public final boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public final BlockPos next() {
        this.vec2.toBlock(this.blockPos);
        if (++this.x >= this.size.x) {
            if (++this.y >= this.size.y) {
                this.hasNext = false;
            } else {
                this.x = 0;
                this.vec2.set(this.vec1.add(this.side.up));
            }
        } else {
            this.vec2.add(this.side.right);
        }
        return this.blockPos;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getIndex() {
        return this.y * this.size.x + this.x;
    }
}

