/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.utilities;

import io.netty.buffer.ByteBuf;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.StringJoiner;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.montoyo.wd.utilities.DontSerialize;
import net.montoyo.wd.utilities.NameUUIDPair;

public abstract class Util {
    public static final String[] SIZES = new String[]{"bytes", "KiB", "MiB", "GiB", "TiB"};

    public static void serialize(ByteBuf bb, Object f) {
        Class<?> cls = f.getClass();
        if (cls == Integer.class || cls == Integer.TYPE) {
            bb.writeInt(((Integer)f).intValue());
        } else if (cls == Float.class || cls == Float.TYPE) {
            bb.writeFloat(((Float)f).floatValue());
        } else if (cls == Double.class || cls == Double.TYPE) {
            bb.writeDouble(((Double)f).doubleValue());
        } else if (cls == Boolean.class || cls == Boolean.TYPE) {
            bb.writeBoolean(((Boolean)f).booleanValue());
        } else if (cls == String.class) {
            ByteBufUtils.writeUTF8String((ByteBuf)bb, (String)((String)f));
        } else if (cls == NameUUIDPair.class) {
            ((NameUUIDPair)f).writeTo(bb);
        } else if (cls.isEnum()) {
            bb.writeByte(((Enum)f).ordinal());
        } else if (cls.isArray()) {
            Object[] ray = (Object[])f;
            bb.writeInt(ray.length);
            for (Object o : ray) {
                Util.serialize(bb, o);
            }
        } else if (!cls.isPrimitive()) {
            Field[] fields;
            for (Field ff : fields = cls.getFields()) {
                try {
                    if (ff.getAnnotation(DontSerialize.class) != null || Modifier.isStatic(ff.getModifiers())) continue;
                    Util.serialize(bb, ff.get(f));
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    throw new RuntimeException(String.format("Caught IllegalAccessException for %s.%s", cls.getName(), ff.getName()));
                }
            }
        } else {
            throw new RuntimeException(String.format("Cannot transmit class %s over network!", cls.getName()));
        }
    }

    public static Object unserialize(ByteBuf bb, Class cls) {
        if (cls == Integer.class || cls == Integer.TYPE) {
            return bb.readInt();
        }
        if (cls == Float.class || cls == Float.TYPE) {
            return Float.valueOf(bb.readFloat());
        }
        if (cls == Double.class || cls == Double.TYPE) {
            return bb.readDouble();
        }
        if (cls == Boolean.class || cls == Boolean.TYPE) {
            return bb.readBoolean();
        }
        if (cls == String.class) {
            return ByteBufUtils.readUTF8String((ByteBuf)bb);
        }
        if (cls == NameUUIDPair.class) {
            return new NameUUIDPair(bb);
        }
        if (cls.isEnum()) {
            return cls.getEnumConstants()[bb.readByte()];
        }
        if (cls.isArray()) {
            Object[] ray = new Object[bb.readInt()];
            for (int i = 0; i < ray.length; ++i) {
                ray[i] = Util.unserialize(bb, cls.getComponentType());
            }
            return Arrays.copyOf(ray, ray.length, cls);
        }
        if (!cls.isPrimitive()) {
            Object ret;
            Field[] fields = cls.getFields();
            try {
                ret = cls.newInstance();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                throw new RuntimeException(String.format("Caught InstantiationException for class %s", cls.getName()));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new RuntimeException(String.format("Caught IllegalAccessException for class %s", cls.getName()));
            }
            for (Field ff : fields) {
                try {
                    if (ff.getAnnotation(DontSerialize.class) != null || Modifier.isStatic(ff.getModifiers())) continue;
                    ff.set(ret, Util.unserialize(bb, ff.getType()));
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(String.format("Caught IllegalAccessException for %s.%s", cls.getName(), ff.getName()));
                }
            }
            return ret;
        }
        throw new RuntimeException(String.format("Cannot unserialize class %s!", cls.getName()));
    }

    public static String addSlashes(String str) {
        String out = "";
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            out = c == '\\' ? out + "\\\\" : (c == '\"' ? out + "\\\"" : out + c);
        }
        return out;
    }

    public static int scrambleKey(int idx) {
        return (idx *= -1640531527) ^ idx >> 16;
    }

    public static void toast(EntityPlayer player, String key, Object ... data) {
        Util.toast(player, TextFormatting.RED, key, data);
    }

    public static void toast(EntityPlayer player, TextFormatting color, String key, Object ... data) {
        TextComponentString root = new TextComponentString("[WebDisplays] ");
        root.func_150255_a(new Style().func_150238_a(color));
        root.func_150257_a((ITextComponent)new TextComponentTranslation("webdisplays.message." + key, data));
        player.func_146105_b((ITextComponent)root);
    }

    public static void silentClose(Object obj) {
        try {
            obj.getClass().getMethod("close", new Class[0]).invoke(obj, new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static String addProtocol(String str) {
        return str.isEmpty() || str.contains("://") ? str : "http://" + str;
    }

    public static boolean isFileNameInvalid(String fname) {
        return fname.isEmpty() || fname.length() > 64 || fname.charAt(0) == '.' || fname.indexOf(47) >= 0 || fname.indexOf(92) >= 0;
    }

    public static String sizeString(long l) {
        double d = l;
        int size = 0;
        while (l >= 1024L && size + 1 < SIZES.length) {
            d /= 1024.0;
            l /= 1024L;
            ++size;
        }
        return String.format("%.2f %s", d, SIZES[size]);
    }

    public static String join(String[] array, String sep) {
        StringJoiner j = new StringJoiner(sep);
        Arrays.stream(array).forEach(j::add);
        return j.toString();
    }

    public static NBTTagCompound writeOwnerToNBT(NBTTagCompound tag, NameUUIDPair owner) {
        if (owner != null) {
            tag.func_74772_a("OwnerMSB", owner.uuid.getMostSignificantBits());
            tag.func_74772_a("OwnerLSB", owner.uuid.getLeastSignificantBits());
            tag.func_74778_a("OwnerName", owner.name);
        }
        return tag;
    }

    public static NameUUIDPair readOwnerFromNBT(NBTTagCompound tag) {
        long msb = tag.func_74763_f("OwnerMSB");
        long lsb = tag.func_74763_f("OwnerLSB");
        String str = tag.func_74779_i("OwnerName");
        return new NameUUIDPair(str, new UUID(msb, lsb));
    }
}

