/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.mcef.client;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.SplashProgress;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.montoyo.mcef.BaseProxy;
import net.montoyo.mcef.MCEF;
import net.montoyo.mcef.api.IBrowser;
import net.montoyo.mcef.api.IDisplayHandler;
import net.montoyo.mcef.api.IJSQueryHandler;
import net.montoyo.mcef.api.IScheme;
import net.montoyo.mcef.client.AppHandler;
import net.montoyo.mcef.client.DisplayHandler;
import net.montoyo.mcef.client.MessageRouter;
import net.montoyo.mcef.client.ShutdownThread;
import net.montoyo.mcef.client.UpdateFrame;
import net.montoyo.mcef.coremod.ShutdownPatcher;
import net.montoyo.mcef.example.ExampleMod;
import net.montoyo.mcef.remote.RemoteConfig;
import net.montoyo.mcef.utilities.ForgeProgressListener;
import net.montoyo.mcef.utilities.IProgressListener;
import net.montoyo.mcef.utilities.Log;
import net.montoyo.mcef.utilities.Util;
import net.montoyo.mcef.virtual.VirtualBrowser;
import org.cef.CefApp;
import org.cef.CefClient;
import org.cef.CefSettings;
import org.cef.OS;
import org.cef.browser.CefBrowserOsr;
import org.cef.browser.CefMessageRouter;
import org.cef.browser.CefRenderer;

public class ClientProxy
extends BaseProxy {
    public static String ROOT = ".";
    public static boolean VIRTUAL = false;
    private CefApp cefApp;
    private CefClient cefClient;
    private CefMessageRouter cefRouter;
    private final ArrayList<CefBrowserOsr> browsers = new ArrayList();
    private String updateStr;
    private final Minecraft mc = Minecraft.func_71410_x();
    private final DisplayHandler displayHandler = new DisplayHandler();
    private final HashMap<String, String> mimeTypeMap = new HashMap();
    private final AppHandler appHandler = new AppHandler();
    private ExampleMod exampleMod;

    @Override
    public void onPreInit() {
        this.exampleMod = new ExampleMod();
        this.exampleMod.onPreInit();
    }

    @Override
    public void onInit() {
        if (MCEF.DISABLE_GPU_RENDERING) {
            Log.info("GPU rendering is disabled because the new launcher sucks.", new Object[0]);
            this.appHandler.setArgs(new String[]{"--disable-gpu"});
        } else {
            this.appHandler.setArgs(new String[0]);
        }
        boolean enableForgeSplash = false;
        try {
            Field f = SplashProgress.class.getDeclaredField("enabled");
            f.setAccessible(true);
            enableForgeSplash = f.getBoolean(null);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        ROOT = this.mc.field_71412_D.getAbsolutePath().replaceAll("\\\\", "/");
        if (ROOT.endsWith(".")) {
            ROOT = ROOT.substring(0, ROOT.length() - 1);
        }
        if (ROOT.endsWith("/")) {
            ROOT = ROOT.substring(0, ROOT.length() - 1);
        }
        File fileListing = new File(new File(ROOT), "config");
        RemoteConfig cfg = new RemoteConfig();
        IProgressListener ipl = MCEF.USE_FORGE_SPLASH && enableForgeSplash ? new ForgeProgressListener() : new UpdateFrame();
        cfg.load();
        if (!cfg.updateFileListing(fileListing, false)) {
            Log.warning("There was a problem while establishing file list. Uninstall may not delete all files.", new Object[0]);
        }
        if (!cfg.downloadMissing(ipl)) {
            Log.warning("Going in virtual mode; couldn't download resources.", new Object[0]);
            VIRTUAL = true;
            return;
        }
        if (!cfg.updateFileListing(fileListing, true)) {
            Log.warning("There was a problem while updating file list. Uninstall may not delete all files.", new Object[0]);
        }
        this.updateStr = cfg.getUpdateString();
        ipl.onProgressEnd();
        if (VIRTUAL) {
            return;
        }
        Log.info("Now adding \"%s\" to java.library.path", ROOT);
        try {
            Field pathsField = ClassLoader.class.getDeclaredField("usr_paths");
            pathsField.setAccessible(true);
            String[] paths = (String[])pathsField.get(null);
            String[] newList = new String[paths.length + 1];
            System.arraycopy(paths, 0, newList, 1, paths.length);
            newList[0] = ROOT.replace('/', File.separatorChar);
            pathsField.set(null, newList);
        }
        catch (Exception e) {
            Log.error("Failed to do it! Entering virtual mode...", new Object[0]);
            e.printStackTrace();
            VIRTUAL = true;
            return;
        }
        Log.info("Done without errors.", new Object[0]);
        String exeSuffix = OS.isWindows() ? ".exe" : "";
        CefSettings settings = new CefSettings();
        settings.windowless_rendering_enabled = true;
        CefSettings cefSettings = settings;
        cefSettings.getClass();
        settings.background_color = new CefSettings.ColorType(cefSettings, 0, 255, 255, 255);
        settings.locales_dir_path = new File(ROOT, "MCEFLocales").getAbsolutePath();
        settings.cache_path = new File(ROOT, "MCEFCache").getAbsolutePath();
        settings.browser_subprocess_path = new File(ROOT, "jcef_helper" + exeSuffix).getAbsolutePath();
        try {
            if (OS.isWindows()) {
                ArrayList<String> libs = new ArrayList<String>();
                libs.add(System.getProperty("sun.arch.data.model").equals("64") ? "d3dcompiler_47.dll" : "d3dcompiler_43.dll");
                libs.add("libGLESv2.dll");
                libs.add("libEGL.dll");
                libs.add("libcef.dll");
                libs.add("jcef.dll");
                for (String lib : libs) {
                    File f = new File(ROOT, lib);
                    try {
                        f = f.getCanonicalFile();
                    }
                    catch (IOException ex) {
                        f = f.getAbsoluteFile();
                    }
                    System.load(f.getPath());
                }
            } else {
                System.loadLibrary("jcef");
            }
            this.cefApp = CefApp.getInstance(settings);
            this.loadMimeTypeMapping();
            CefApp.addAppHandler(this.appHandler);
            this.cefClient = this.cefApp.createClient();
        }
        catch (Throwable t) {
            Log.error("Going in virtual mode; couldn't initialize CEF.", new Object[0]);
            t.printStackTrace();
            VIRTUAL = true;
            return;
        }
        Log.info(this.cefApp.getVersion().toString(), new Object[0]);
        this.cefRouter = CefMessageRouter.create(new CefMessageRouter.CefMessageRouterConfig("mcefQuery", "mcefCancel"));
        this.cefClient.addMessageRouter(this.cefRouter);
        this.cefClient.addDisplayHandler(this.displayHandler);
        if (!ShutdownPatcher.didPatchSucceed()) {
            Log.warning("ShutdownPatcher failed to patch Minecraft.run() method; starting ShutdownThread...", new Object[0]);
            new ShutdownThread().start();
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
        if (MCEF.ENABLE_EXAMPLE) {
            this.exampleMod.onInit();
        }
        Log.info("MCEF loaded successfuly.", new Object[0]);
    }

    public CefApp getCefApp() {
        return this.cefApp;
    }

    @Override
    public IBrowser createBrowser(String url, boolean transp) {
        if (VIRTUAL) {
            return new VirtualBrowser();
        }
        CefBrowserOsr ret = (CefBrowserOsr)this.cefClient.createBrowser(url, true, transp);
        this.browsers.add(ret);
        return ret;
    }

    @Override
    public void registerDisplayHandler(IDisplayHandler idh) {
        this.displayHandler.addHandler(idh);
    }

    @Override
    public boolean isVirtual() {
        return VIRTUAL;
    }

    @Override
    public void openExampleBrowser(String url) {
        if (MCEF.ENABLE_EXAMPLE) {
            this.exampleMod.showScreen(url);
        }
    }

    @Override
    public void registerJSQueryHandler(IJSQueryHandler iqh) {
        if (!VIRTUAL) {
            this.cefRouter.addHandler(new MessageRouter(iqh), false);
        }
    }

    @Override
    public void registerScheme(String name, Class<? extends IScheme> schemeClass, boolean std, boolean local, boolean displayIsolated) {
        this.appHandler.registerScheme(name, schemeClass, std, local, displayIsolated);
    }

    @Override
    public boolean isSchemeRegistered(String name) {
        return this.appHandler.isSchemeRegistered(name);
    }

    @SubscribeEvent
    public void onTick(TickEvent.RenderTickEvent ev) {
        if (ev.phase == TickEvent.Phase.START) {
            this.mc.field_71424_I.func_76320_a("MCEF");
            for (CefBrowserOsr b : this.browsers) {
                b.mcefUpdate();
            }
            this.displayHandler.update();
            this.mc.field_71424_I.func_76319_b();
        }
    }

    @SubscribeEvent
    public void onLogin(PlayerEvent.PlayerLoggedInEvent ev) {
        if (this.updateStr == null || !MCEF.WARN_UPDATES) {
            return;
        }
        Style cs = new Style();
        cs.func_150238_a(TextFormatting.LIGHT_PURPLE);
        TextComponentString cct = new TextComponentString(this.updateStr);
        cct.func_150255_a(cs);
        ev.player.func_146105_b((ITextComponent)cct);
    }

    public void removeBrowser(CefBrowserOsr b) {
        this.browsers.remove(b);
    }

    @Override
    public IBrowser createBrowser(String url) {
        return this.createBrowser(url, false);
    }

    @Override
    public void onShutdown() {
        if (VIRTUAL) {
            return;
        }
        Log.info("Shutting down JCEF...", new Object[0]);
        CefBrowserOsr.CLEANUP = false;
        for (CefBrowserOsr b : this.browsers) {
            b.close();
        }
        this.browsers.clear();
        this.cefClient.dispose();
        if (MCEF.CHECK_VRAM_LEAK) {
            CefRenderer.dumpVRAMLeak();
        }
        try {
            Thread.sleep(100L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.cefApp.N_Shutdown();
    }

    public void loadMimeTypeMapping() {
        Pattern p = Pattern.compile("^(\\S+)\\s+(\\S+)\\s*(\\S*)\\s*(\\S*)$");
        String line = "";
        int cLine = 0;
        this.mimeTypeMap.clear();
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(ClientProxy.class.getResourceAsStream("/assets/mcef/mime.types")));
            while (true) {
                Matcher m;
                ++cLine;
                line = br.readLine();
                if (line == null) break;
                if ((line = line.trim()).startsWith("#") || !(m = p.matcher(line)).matches()) continue;
                this.mimeTypeMap.put(m.group(2), m.group(1));
                if (m.groupCount() < 4 || m.group(3).isEmpty()) continue;
                this.mimeTypeMap.put(m.group(3), m.group(1));
                if (m.groupCount() < 5 || m.group(4).isEmpty()) continue;
                this.mimeTypeMap.put(m.group(4), m.group(1));
            }
            Util.close(br);
        }
        catch (Throwable e) {
            Log.error("[Mime Types] Error while parsing \"%s\" at line %d:", line, cLine);
            e.printStackTrace();
        }
        Log.info("Loaded %d mime types", this.mimeTypeMap.size());
    }

    @Override
    public String mimeTypeFromExtension(String ext) {
        String ret = this.mimeTypeMap.get(ext = ext.toLowerCase());
        if (ret != null) {
            return ret;
        }
        switch (ext) {
            case "htm": 
            case "html": {
                return "text/html";
            }
            case "css": {
                return "text/css";
            }
            case "js": {
                return "text/javascript";
            }
            case "png": {
                return "image/png";
            }
            case "jpg": 
            case "jpeg": {
                return "image/jpeg";
            }
            case "gif": {
                return "image/gif";
            }
            case "svg": {
                return "image/svg+xml";
            }
            case "xml": {
                return "text/xml";
            }
            case "txt": {
                return "text/plain";
            }
        }
        return null;
    }
}

