/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.mcef.coremod;

import java.util.Map;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraftforge.fml.relauncher.IFMLLoadingPlugin;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;

@IFMLLoadingPlugin.Name(value="ShutdownPatcher")
@IFMLLoadingPlugin.TransformerExclusions(value={"net.montoyo.mcef."})
@IFMLLoadingPlugin.SortingIndex(value=90007531)
@IFMLLoadingPlugin.MCVersion(value="1.10.2")
public class ShutdownPatcher
implements IFMLLoadingPlugin,
IClassTransformer {
    private static boolean PATCH_OK = false;
    private static final String OBF_SHUTDOWN_METHOD = "func_71405_e";

    public static boolean didPatchSucceed() {
        return PATCH_OK;
    }

    public String[] getASMTransformerClass() {
        return new String[]{"net.montoyo.mcef.coremod.ShutdownPatcher"};
    }

    public String getModContainerClass() {
        return null;
    }

    public String getSetupClass() {
        return null;
    }

    public void injectData(Map<String, Object> data) {
    }

    public String getAccessTransformerClass() {
        return null;
    }

    public byte[] transform(String name, String deobfName, byte[] cls) {
        if (!deobfName.equals("net.minecraft.client.Minecraft")) {
            return cls;
        }
        boolean envObf = !name.equals(deobfName);
        ShutdownPatcher.log("Now transforming %s, aka %s (obfuscated: %s)", name, deobfName, envObf ? "yes" : "no");
        try {
            ClassReader cr = new ClassReader(cls);
            ClassWriter cw = new ClassWriter(1);
            McVisitor cv = new McVisitor((ClassVisitor)cw, envObf);
            cr.accept((ClassVisitor)cv, 0);
            return cw.toByteArray();
        }
        catch (Throwable t) {
            t.printStackTrace();
            ShutdownPatcher.log("Failed to setup Minecraft shutdown detector.", new Object[0]);
            return cls;
        }
    }

    private static void log(String str, Object ... args) {
        LogManager.getLogger((String)"MCEF").log(Level.INFO, String.format(str, args));
    }

    private static class McVisitor
    extends ClassVisitor {
        private final boolean envObf;

        public McVisitor(ClassVisitor cv, boolean obf) {
            super(327680, cv);
            this.envObf = obf;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor mv = this.cv.visitMethod(access, name, desc, signature, exceptions);
            if (access == 1 && desc.equals("()V") && (this.envObf && name.equals(ShutdownPatcher.OBF_SHUTDOWN_METHOD) || name.equals("shutdownMinecraftApplet"))) {
                ShutdownPatcher.log("shutdownMinecraftApplet() method found; transforming...", new Object[0]);
                return new ShutdownMCAppletVisitor(mv);
            }
            return mv;
        }
    }

    private static class ShutdownMCAppletVisitor
    extends MethodVisitor {
        public ShutdownMCAppletVisitor(MethodVisitor mv) {
            super(327680, mv);
        }

        public void visitCode() {
            this.mv.visitCode();
            this.mv.visitMethodInsn(184, "net/montoyo/mcef/MCEF", "onMinecraftShutdown", "()V", false);
            PATCH_OK = true;
            ShutdownPatcher.log("Target section has been patched.", new Object[0]);
        }
    }
}

