/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.mcef.example;

import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.montoyo.mcef.MCEF;
import net.montoyo.mcef.api.API;
import net.montoyo.mcef.api.IBrowser;
import net.montoyo.mcef.api.MCEFApi;
import net.montoyo.mcef.example.ExampleMod;
import net.montoyo.mcef.example.ScreenCfg;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class BrowserScreen
extends GuiScreen {
    IBrowser browser = null;
    private GuiButton back = null;
    private GuiButton fwd = null;
    private GuiButton go = null;
    private GuiButton min = null;
    private GuiButton vidMode = null;
    private GuiTextField url = null;
    private String urlToLoad = null;
    private static final String YT_REGEX1 = "^https?://(?:www\\.)?youtube\\.com/watch\\?v=([a-zA-Z0-9_\\-]+)$";
    private static final String YT_REGEX2 = "^https?://(?:www\\.)?youtu\\.be/([a-zA-Z0-9_\\-]+)$";
    private static final String YT_REGEX3 = "^https?://(?:www\\.)?youtube\\.com/embed/([a-zA-Z0-9_\\-]+)(\\?.+)?$";

    public BrowserScreen() {
        this.urlToLoad = MCEF.HOME_PAGE;
    }

    public BrowserScreen(String url) {
        this.urlToLoad = url == null ? MCEF.HOME_PAGE : url;
    }

    public void func_73866_w_() {
        ExampleMod.INSTANCE.hudBrowser = null;
        if (this.browser == null) {
            API api = MCEFApi.getAPI();
            if (api == null) {
                return;
            }
            this.browser = api.createBrowser(this.urlToLoad == null ? MCEF.HOME_PAGE : this.urlToLoad, false);
            this.urlToLoad = null;
        }
        if (this.browser != null) {
            this.browser.resize(this.field_146297_k.field_71443_c, this.field_146297_k.field_71440_d - this.scaleY(20));
        }
        Keyboard.enableRepeatEvents((boolean)true);
        this.field_146292_n.clear();
        if (this.url == null) {
            this.back = new GuiButton(0, 0, 0, 20, 20, "<");
            this.field_146292_n.add(this.back);
            this.fwd = new GuiButton(1, 20, 0, 20, 20, ">");
            this.field_146292_n.add(this.fwd);
            this.go = new GuiButton(2, this.field_146294_l - 60, 0, 20, 20, "Go");
            this.field_146292_n.add(this.go);
            this.min = new GuiButton(3, this.field_146294_l - 20, 0, 20, 20, "_");
            this.field_146292_n.add(this.min);
            this.vidMode = new GuiButton(4, this.field_146294_l - 40, 0, 20, 20, "YT");
            this.field_146292_n.add(this.vidMode);
            this.vidMode.field_146124_l = false;
            this.url = new GuiTextField(5, this.field_146289_q, 40, 0, this.field_146294_l - 100, 20);
            this.url.func_146203_f(65535);
        } else {
            this.field_146292_n.add(this.back);
            this.field_146292_n.add(this.fwd);
            this.field_146292_n.add(this.go);
            this.field_146292_n.add(this.min);
            this.field_146292_n.add(this.vidMode);
            this.vidMode.field_146128_h = this.field_146294_l - 40;
            this.go.field_146128_h = this.field_146294_l - 60;
            this.min.field_146128_h = this.field_146294_l - 20;
            String old = this.url.func_146179_b();
            this.url = new GuiTextField(5, this.field_146289_q, 40, 0, this.field_146294_l - 100, 20);
            this.url.func_146203_f(65535);
            this.url.func_146180_a(old);
        }
    }

    public int scaleY(int y) {
        double sy = (double)y / (double)this.field_146295_m * (double)this.field_146297_k.field_71440_d;
        return (int)sy;
    }

    public void loadURL(String url) {
        if (this.browser == null) {
            this.urlToLoad = url;
        } else {
            this.browser.loadURL(url);
        }
    }

    public void func_73876_c() {
        if (this.urlToLoad != null && this.browser != null) {
            this.browser.loadURL(this.urlToLoad);
            this.urlToLoad = null;
        }
    }

    public void func_73863_a(int i1, int i2, float f) {
        this.url.func_146194_f();
        super.func_73863_a(i1, i2, f);
        if (this.browser != null) {
            GlStateManager.func_179097_i();
            GlStateManager.func_179098_w();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.browser.draw(0.0, this.field_146295_m, this.field_146294_l, 20.0);
            GlStateManager.func_179126_j();
        }
    }

    public void func_146281_b() {
        if (!ExampleMod.INSTANCE.hasBackup() && this.browser != null) {
            this.browser.close();
        }
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void func_146269_k() {
        while (Keyboard.next()) {
            if (Keyboard.getEventKey() == 1) {
                this.field_146297_k.func_147108_a(null);
                return;
            }
            boolean pressed = Keyboard.getEventKeyState();
            boolean focused = this.url.func_146206_l();
            char key = Keyboard.getEventCharacter();
            int num = Keyboard.getEventKey();
            if (this.browser != null && !focused) {
                if (key != '.' && key != ';' && key != ',') {
                    if (pressed) {
                        this.browser.injectKeyPressed(key, 0);
                    } else {
                        this.browser.injectKeyReleased(key, 0);
                    }
                }
                if (key != '\u0000') {
                    this.browser.injectKeyTyped(key, 0);
                }
            }
            if (!pressed && focused && num == 28) {
                this.func_146284_a(this.go);
                continue;
            }
            if (!pressed) continue;
            this.url.func_146201_a(key, num);
        }
        while (Mouse.next()) {
            int btn = Mouse.getEventButton();
            boolean pressed = Mouse.getEventButtonState();
            int sx = Mouse.getEventX();
            int sy = Mouse.getEventY();
            int wheel = Mouse.getEventDWheel();
            if (this.browser != null) {
                int y = this.field_146297_k.field_71440_d - sy - this.scaleY(20);
                if (wheel != 0) {
                    this.browser.injectMouseWheel(sx, y, 0, 1, wheel);
                } else if (btn == -1) {
                    this.browser.injectMouseMove(sx, y, 0, y < 0);
                } else {
                    this.browser.injectMouseButton(sx, y, 0, btn + 1, pressed, 1);
                }
            }
            if (!pressed) continue;
            int x = sx * this.field_146294_l / this.field_146297_k.field_71443_c;
            int y = this.field_146295_m - sy * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
            try {
                this.func_73864_a(x, y, btn);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            this.url.func_146192_a(x, y, btn);
        }
    }

    public void onUrlChanged(IBrowser b, String nurl) {
        if (b == this.browser && this.url != null) {
            this.url.func_146180_a(nurl);
            this.vidMode.field_146124_l = nurl.matches(YT_REGEX1) || nurl.matches(YT_REGEX2) || nurl.matches(YT_REGEX3);
        }
    }

    protected void func_146284_a(GuiButton src) {
        if (this.browser == null) {
            return;
        }
        if (src.field_146127_k == 0) {
            this.browser.goBack();
        } else if (src.field_146127_k == 1) {
            this.browser.goForward();
        } else if (src.field_146127_k == 2) {
            this.browser.loadURL(this.url.func_146179_b());
        } else if (src.field_146127_k == 3) {
            ExampleMod.INSTANCE.setBackup(this);
            this.field_146297_k.func_147108_a(null);
        } else if (src.field_146127_k == 4) {
            String loc = this.browser.getURL();
            String vId = null;
            boolean redo = false;
            if (loc.matches(YT_REGEX1)) {
                vId = loc.replaceFirst(YT_REGEX1, "$1");
            } else if (loc.matches(YT_REGEX2)) {
                vId = loc.replaceFirst(YT_REGEX2, "$1");
            } else if (loc.matches(YT_REGEX3)) {
                redo = true;
            }
            if (vId != null || redo) {
                ExampleMod.INSTANCE.setBackup(this);
                this.field_146297_k.func_147108_a((GuiScreen)new ScreenCfg(this.browser, vId));
            }
        }
    }
}

