/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.mcef.setup;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.montoyo.mcef.setup.DefaultComparator;
import net.montoyo.mcef.setup.SetupUtil;
import net.montoyo.mcef.setup.SlashComparator;

public class FileListing {
    private ArrayList<String> fileNames = new ArrayList();
    private File location;

    public FileListing(File dir) {
        this.location = new File(dir, "mcefFiles.lst");
        if (this.location.exists()) {
            this.load();
        }
    }

    public boolean load() {
        try {
            this.unsafeLoad();
            return true;
        }
        catch (Throwable t) {
            System.err.println("Coud not read file listing:");
            t.printStackTrace();
            return false;
        }
    }

    private void unsafeLoad() throws Throwable {
        String line;
        BufferedReader br = new BufferedReader(new FileReader(this.location));
        this.fileNames.clear();
        while ((line = br.readLine()) != null) {
            if ((line = line.trim()).length() <= 0 || line.charAt(0) == '#' || line.charAt(0) == '.' || line.charAt(0) == '/' || line.charAt(0) == '\\') continue;
            this.fileNames.add(line);
        }
        SetupUtil.silentClose(br);
    }

    public boolean save() {
        try {
            this.unsafeSave();
            return true;
        }
        catch (Throwable t) {
            System.err.println("Coud not write file listing:");
            t.printStackTrace();
            return false;
        }
    }

    private void unsafeSave() throws Throwable {
        if (this.location.exists()) {
            SetupUtil.tryDelete(this.location);
        }
        BufferedWriter bw = new BufferedWriter(new FileWriter(this.location));
        bw.write("# DO NOT EDIT THIS FILE. IT HAS BEEN AUTOMATICALLY GENERATED.\n");
        bw.write("# This file contains the list of files installed by MCEF.\n");
        bw.write("# If you remove MCEF, they are no longer needed and you can safely remove them,\n");
        bw.write("# or you can let the uninstaller do it for you. Just run the MCEF mod jar using Java.\n\n");
        for (String f : this.fileNames) {
            bw.write(f + "\n");
        }
        SetupUtil.silentClose(bw);
    }

    public void addFile(String f) {
        if (!this.fileNames.contains(f)) {
            this.fileNames.add(f);
        }
    }

    public boolean addZip(String fname) {
        try {
            this.addZipUnsafe(fname);
            return true;
        }
        catch (Throwable t) {
            System.err.println("Coud not list file in ZIP archive \"" + fname + "\":");
            t.printStackTrace();
            return false;
        }
    }

    private void addZipUnsafe(String fname) throws Throwable {
        ZipEntry ze;
        ArrayList<String> files = new ArrayList<String>();
        ZipInputStream zis = new ZipInputStream(new FileInputStream(fname));
        while ((ze = zis.getNextEntry()) != null) {
            String name = ze.getName();
            if (ze.isDirectory() && (name.endsWith("/") || name.endsWith("\\"))) {
                files.add(name.substring(0, name.length() - 1));
                continue;
            }
            files.add(name);
        }
        SetupUtil.silentClose(zis);
        files.sort(new SlashComparator(new DefaultComparator()));
        for (String t : files) {
            this.addFile(t);
        }
    }

    public Iterator<String> iterator() {
        return this.fileNames.iterator();
    }

    public boolean selfDestruct() {
        return SetupUtil.tryDelete(this.location);
    }
}

