/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.client.gui;

import flaxbeard.cyberware.common.CyberwareContent;
import flaxbeard.cyberware.common.block.tile.TileEntityBlueprintArchive;
import flaxbeard.cyberware.common.block.tile.TileEntityComponentBox;
import flaxbeard.cyberware.common.block.tile.TileEntityEngineeringTable;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public class ContainerEngineeringTable
extends Container {
    private final TileEntityEngineeringTable engineering;
    public TileEntityBlueprintArchive archive;
    public int archiveIndex = 0;
    public ArrayList<TileEntityBlueprintArchive> archiveList = new ArrayList();
    public Object componentBox;
    public ArrayList<Object> componentBoxList = new ArrayList();
    public int componentBoxIndex = 0;
    ItemStackHandler componentHandler = null;
    public InventoryPlayer playerInv;

    public ContainerEngineeringTable(String uuid, InventoryPlayer playerInventory, @Nonnull TileEntityEngineeringTable engineering) {
        int indexColumn;
        TileEntity tileEntity;
        BlockPos pos;
        int y;
        this.playerInv = playerInventory;
        this.engineering = engineering;
        this.archive = null;
        this.componentBox = null;
        BlockPos target = null;
        if (engineering.lastPlayerArchive.containsKey(uuid)) {
            target = engineering.lastPlayerArchive.get(uuid);
        }
        for (y = -2; y < 2; ++y) {
            for (int x = -2; x < 3; ++x) {
                for (int z = -2; z < 3; ++z) {
                    pos = engineering.func_174877_v().func_177982_a(x, y, z);
                    tileEntity = engineering.func_145831_w().func_175625_s(pos);
                    if (!(tileEntity instanceof TileEntityBlueprintArchive)) continue;
                    if (this.archive == null || tileEntity.func_174877_v().equals((Object)target)) {
                        this.archive = (TileEntityBlueprintArchive)tileEntity;
                        this.archiveIndex = this.archiveList.size();
                    }
                    this.archiveList.add((TileEntityBlueprintArchive)tileEntity);
                }
            }
        }
        for (int indexSlot = 0; indexSlot < playerInventory.field_70462_a.size(); ++indexSlot) {
            ItemStack stack = (ItemStack)playerInventory.field_70462_a.get(indexSlot);
            if (stack.func_190926_b() || stack.func_77973_b() != CyberwareContent.componentBox.itemBlock) continue;
            NBTTagCompound tagCompoundStack = stack.func_77978_p();
            if (tagCompoundStack == null) {
                tagCompoundStack = new NBTTagCompound();
                stack.func_77982_d(tagCompoundStack);
            }
            if (!tagCompoundStack.func_74764_b("contents")) {
                TileEntityComponentBox.ItemStackHandlerComponent slots = new TileEntityComponentBox.ItemStackHandlerComponent(18);
                tagCompoundStack.func_74782_a("contents", (NBTBase)slots.serializeNBT());
            }
            if (this.componentBox == null) {
                this.componentBox = indexSlot;
                this.componentBoxIndex = this.componentBoxList.size();
            }
            this.componentBoxList.add(indexSlot);
        }
        for (y = -2; y < 2; ++y) {
            for (int x = -2; x < 3; ++x) {
                for (int z = -2; z < 3; ++z) {
                    pos = engineering.func_174877_v().func_177982_a(x, y, z);
                    tileEntity = engineering.func_145831_w().func_175625_s(pos);
                    if (!(tileEntity instanceof TileEntityComponentBox)) continue;
                    if (this.componentBox == null) {
                        this.componentBox = tileEntity;
                        this.componentBoxIndex = this.componentBoxList.size();
                    }
                    this.componentBoxList.add(tileEntity);
                }
            }
        }
        int offset = this.componentBox == null ? 0 : 65;
        this.func_75146_a((Slot)new SlotEngineering((IItemHandler)engineering.guiSlots, 0, 15 + offset, 20));
        this.func_75146_a((Slot)new SlotEngineering((IItemHandler)engineering.guiSlots, 1, 15 + offset, 53));
        for (indexColumn = 0; indexColumn < 2; ++indexColumn) {
            for (int indexRow = 0; indexRow < 3; ++indexRow) {
                this.func_75146_a((Slot)new SlotEngineering((IItemHandler)engineering.guiSlots, 2 + indexRow * 2 + indexColumn, 71 + indexColumn * 18 + offset, 17 + indexRow * 18));
            }
        }
        this.func_75146_a((Slot)new SlotEngineering((IItemHandler)engineering.guiSlots, 8, 115 + offset, 53));
        this.func_75146_a((Slot)new SlotEngineering((IItemHandler)engineering.guiSlots, 9, 145 + offset, 21));
        for (int indexRow = 0; indexRow < 3; ++indexRow) {
            for (int indexColumn2 = 0; indexColumn2 < 9; ++indexColumn2) {
                this.func_75146_a(new SlotInv((IInventory)playerInventory, indexColumn2 + indexRow * 9 + 9, 8 + indexColumn2 * 18 + offset, 84 + indexRow * 18));
            }
        }
        for (indexColumn = 0; indexColumn < 9; ++indexColumn) {
            this.func_75146_a(new SlotInv((IInventory)playerInventory, indexColumn, 8 + indexColumn * 18 + offset, 142));
        }
        if (this.archive != null) {
            int numRows = this.archive.slots.getSlots() / 6;
            for (int indexRow = 0; indexRow < 6; ++indexRow) {
                for (int indexColumn3 = 0; indexColumn3 < numRows; ++indexColumn3) {
                    this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.archive.slots, indexColumn3 + indexRow * numRows, 181 + indexColumn3 * 18 + offset, 22 + indexRow * 18));
                }
            }
        }
        if (this.componentBox != null) {
            if (this.componentBox instanceof TileEntityComponentBox) {
                this.componentHandler = ((TileEntityComponentBox)((Object)this.componentBox)).slots;
            } else {
                ItemStack item = (ItemStack)this.playerInv.field_70462_a.get(((Integer)this.componentBox).intValue());
                TileEntityComponentBox.ItemStackHandlerComponent slots = new TileEntityComponentBox.ItemStackHandlerComponent(18);
                slots.deserializeNBT(item.func_77978_p().func_74775_l("contents"));
                this.componentHandler = slots;
            }
            int numRows = this.componentHandler.getSlots() / 6;
            for (int indexRow = 0; indexRow < 6; ++indexRow) {
                for (int indexColumn4 = 0; indexColumn4 < numRows; ++indexColumn4) {
                    this.func_75146_a((Slot)new SlotComponentBox((IItemHandler)this.componentHandler, indexColumn4 + indexRow * numRows, 8 + indexColumn4 * 18, 22 + indexRow * 18));
                }
            }
        }
        engineering.updateRecipe();
    }

    private void validateComponentAndArchive() {
        while (this.archive != null && this.archive.func_145831_w().func_175625_s(this.archive.func_174877_v()) != this.archive) {
            this.archiveList.remove(this.archiveIndex);
            if (this.archiveList.size() == 0) {
                int offset = this.componentBox == null ? 0 : 18;
                int numColumns = 3;
                for (int indexRow = 0; indexRow < 6; ++indexRow) {
                    for (int indexColumn = 0; indexColumn < numColumns; ++indexColumn) {
                        this.field_75151_b.remove(this.field_75151_b.size() - 1 - offset);
                        this.field_75153_a.remove(this.field_75153_a.size() - 1 - offset);
                    }
                }
                this.archive = null;
                continue;
            }
            --this.archiveIndex;
            this.nextArchive();
        }
        while (this.componentBox instanceof TileEntityComponentBox && ((TileEntityComponentBox)((Object)this.componentBox)).func_145831_w().func_175625_s(((TileEntityComponentBox)((Object)this.componentBox)).func_174877_v()) != this.componentBox || this.componentBox instanceof Integer && (((ItemStack)this.playerInv.field_70462_a.get(((Integer)this.componentBox).intValue())).func_190926_b() || ((ItemStack)this.playerInv.field_70462_a.get(((Integer)this.componentBox).intValue())).func_77973_b() != CyberwareContent.componentBox.itemBlock)) {
            this.componentBoxList.remove(this.componentBoxIndex);
            if (this.componentBoxList.size() == 0) {
                int numColumns = 3;
                for (int indexRow = 0; indexRow < 6; ++indexRow) {
                    for (int indexColumn = 0; indexColumn < numColumns; ++indexColumn) {
                        this.field_75151_b.remove(this.field_75151_b.size() - 1);
                        this.field_75153_a.remove(this.field_75153_a.size() - 1);
                    }
                }
                this.componentBox = null;
                this.componentHandler = null;
                continue;
            }
            --this.componentBoxIndex;
            this.nextComponentBox();
        }
    }

    public boolean func_75145_c(@Nonnull EntityPlayer entityPlayer) {
        this.validateComponentAndArchive();
        return this.engineering.isUsableByPlayer(entityPlayer);
    }

    @Nonnull
    public ItemStack func_82846_b(EntityPlayer entityPlayer, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        boolean doUpdate = false;
        int componentLow = this.archive == null ? 46 : 64;
        int componentHigh = componentLow + 18;
        int archiveLow = 46;
        int archiveHigh = archiveLow + 18;
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index == 9) {
                if (!this.func_75135_a(itemstack1, 10, 46, true)) {
                    return ItemStack.field_190927_a;
                }
                this.engineering.subtractResources();
                doUpdate = true;
            } else if (index == 8 && this.archive != null ? !this.func_75135_a(itemstack1, archiveLow, archiveHigh, true) && !this.func_75135_a(itemstack1, 10, 46, false) : (index == 1 && this.archive != null ? !this.func_75135_a(itemstack1, archiveLow, archiveHigh, true) && !this.func_75135_a(itemstack1, 10, 46, false) : (index > 9 ? (!this.engineering.slots.isItemValidForSlot(1, itemstack1) || !this.func_75135_a(itemstack1, 1, 2, false)) && (this.engineering.slots.isItemValidForSlot(0, itemstack1) ? !this.func_75135_a(itemstack1, 0, 1, false) : (this.engineering.slots.isItemValidForSlot(8, itemstack1) ? !this.func_75135_a(itemstack1, 8, 9, false) : (index >= 10 && index < 37 ? !(this.archive != null && this.func_75135_a(itemstack1, archiveLow, archiveHigh, false) || this.func_75135_a(itemstack1, 2, 8, false) || this.componentBox != null && this.func_75135_a(itemstack1, componentLow, componentHigh, false) || this.func_75135_a(itemstack1, 37, 46, false)) : (index >= archiveLow && index < archiveHigh ? !this.func_75135_a(itemstack1, 10, 37, false) && !this.func_75135_a(itemstack1, 37, 46, false) : (index >= componentLow && index < componentHigh ? !this.func_75135_a(itemstack1, 2, 8, false) && !this.func_75135_a(itemstack1, 10, 37, false) && !this.func_75135_a(itemstack1, 37, 46, false) : index >= 37 && index < 46 && !this.func_75135_a(itemstack1, 2, 8, false) && !this.func_75135_a(itemstack1, 10, 37, false)))))) : !(this.componentBox != null && this.func_75135_a(itemstack1, componentLow, componentHigh, false) || this.archive != null && this.func_75135_a(itemstack1, archiveLow, archiveHigh, false) || this.func_75135_a(itemstack1, 10, 46, false))))) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190916_E() == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(entityPlayer, itemstack1);
        }
        if (doUpdate) {
            this.engineering.updateRecipe();
        }
        return itemstack;
    }

    public void checkForNewBoxes() {
        for (int indexSlot = 0; indexSlot < this.playerInv.field_70462_a.size(); ++indexSlot) {
            ItemStack stack;
            if (this.componentBoxList.contains(indexSlot) || (stack = (ItemStack)this.playerInv.field_70462_a.get(indexSlot)).func_190926_b() || stack.func_77973_b() != CyberwareContent.componentBox.itemBlock) continue;
            NBTTagCompound tagCompoundStack = stack.func_77978_p();
            if (tagCompoundStack == null) {
                tagCompoundStack = new NBTTagCompound();
                stack.func_77982_d(tagCompoundStack);
            }
            if (!tagCompoundStack.func_74764_b("contents")) {
                TileEntityComponentBox.ItemStackHandlerComponent slots = new TileEntityComponentBox.ItemStackHandlerComponent(18);
                tagCompoundStack.func_74782_a("contents", (NBTBase)slots.serializeNBT());
            }
            if (this.componentBox == null) {
                this.componentBox = indexSlot;
                this.componentBoxIndex = this.componentBoxList.size();
            }
            this.componentBoxList.add(indexSlot);
        }
    }

    public void nextArchive() {
        this.clearSlots();
        this.archiveIndex = (this.archiveIndex + 1) % this.archiveList.size();
        this.archive = this.archiveList.get(this.archiveIndex);
        this.createSlots();
    }

    public void prevArchive() {
        this.clearSlots();
        this.archiveIndex = (this.archiveIndex + this.archiveList.size() - 1) % this.archiveList.size();
        this.archive = this.archiveList.get(this.archiveIndex);
        this.createSlots();
    }

    public void nextComponentBox() {
        this.checkForNewBoxes();
        this.clearSlots();
        this.handleClosingBox();
        this.componentBoxIndex = (this.componentBoxIndex + 1) % this.componentBoxList.size();
        this.componentBox = this.componentBoxList.get(this.componentBoxIndex);
        this.createSlots();
    }

    public void prevComponentBox() {
        this.checkForNewBoxes();
        this.clearSlots();
        this.handleClosingBox();
        this.componentBoxIndex = (this.componentBoxIndex + this.componentBoxList.size() - 1) % this.componentBoxList.size();
        this.componentBox = this.componentBoxList.get(this.componentBoxIndex);
        this.createSlots();
    }

    public void clearSlots() {
        int numOccupied = 0;
        if (this.componentBox != null) {
            numOccupied += 18;
        }
        if (this.archive != null) {
            numOccupied += 18;
        }
        for (int index = 0; index < numOccupied; ++index) {
            this.field_75151_b.remove(this.field_75151_b.size() - 1);
            this.field_75153_a.remove(this.field_75153_a.size() - 1);
        }
    }

    public void createSlots() {
        int indexColumn;
        int indexRow;
        int numColumns;
        this.validateComponentAndArchive();
        if (this.archive != null) {
            numColumns = this.archive.slots.getSlots() / 6;
            for (indexRow = 0; indexRow < 6; ++indexRow) {
                for (indexColumn = 0; indexColumn < numColumns; ++indexColumn) {
                    this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.archive.slots, indexColumn + indexRow * numColumns, 181 + indexColumn * 18 + (this.componentBox == null ? 0 : 65), 22 + indexRow * 18));
                }
            }
        }
        if (this.componentBox != null) {
            if (this.componentBox instanceof TileEntityComponentBox) {
                this.componentHandler = ((TileEntityComponentBox)((Object)this.componentBox)).slots;
            } else {
                TileEntityComponentBox.ItemStackHandlerComponent slots = new TileEntityComponentBox.ItemStackHandlerComponent(18);
                ItemStack item = (ItemStack)this.playerInv.field_70462_a.get(((Integer)this.componentBox).intValue());
                slots.deserializeNBT(item.func_77978_p().func_74775_l("contents"));
                this.componentHandler = slots;
            }
            numColumns = this.componentHandler.getSlots() / 6;
            for (indexRow = 0; indexRow < 6; ++indexRow) {
                for (indexColumn = 0; indexColumn < numColumns; ++indexColumn) {
                    this.func_75146_a((Slot)new SlotComponentBox((IItemHandler)this.componentHandler, indexColumn + indexRow * numColumns, 8 + indexColumn * 18, 22 + indexRow * 18));
                }
            }
        }
    }

    public void func_75134_a(EntityPlayer entityPlayer) {
        super.func_75134_a(entityPlayer);
        this.handleClosingBox();
    }

    public void handleClosingBox() {
    }

    public class SlotComponentBox
    extends SlotItemHandler {
        public SlotComponentBox(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public void func_75218_e() {
            super.func_75218_e();
            this.updateNBT();
        }

        private void updateNBT() {
            ItemStack item;
            if (ContainerEngineeringTable.this.componentBox != null && ContainerEngineeringTable.this.componentBox instanceof Integer && !(item = (ItemStack)ContainerEngineeringTable.this.playerInv.field_70462_a.get(((Integer)ContainerEngineeringTable.this.componentBox).intValue())).func_190926_b() && item.func_77973_b() == CyberwareContent.componentBox.itemBlock) {
                NBTTagCompound tagCompoundContents = ContainerEngineeringTable.this.componentHandler.serializeNBT();
                NBTTagCompound tagCompoundItem = item.func_77978_p();
                if (tagCompoundItem == null) {
                    tagCompoundItem = new NBTTagCompound();
                    item.func_77982_d(tagCompoundItem);
                }
                tagCompoundItem.func_74782_a("contents", (NBTBase)tagCompoundContents);
            }
        }
    }

    public class SlotInv
    extends Slot {
        public SlotInv(IInventory inventoryIn, int index, int xPosition, int yPosition) {
            super(inventoryIn, index, xPosition, yPosition);
        }

        public void func_75218_e() {
            super.func_75218_e();
            this.seeIfCheckNewBox();
        }

        public void func_75215_d(@Nonnull ItemStack stack) {
            super.func_75215_d(stack);
            this.seeIfCheckNewBox();
        }

        private void seeIfCheckNewBox() {
            if (ContainerEngineeringTable.this.componentBoxList.size() <= 1) {
                ContainerEngineeringTable.this.checkForNewBoxes();
            }
        }
    }

    public class SlotEngineering
    extends SlotItemHandler {
        public SlotEngineering(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public boolean func_82869_a(EntityPlayer entityPlayer) {
            return true;
        }

        public void func_75218_e() {
            super.func_75218_e();
            ContainerEngineeringTable.this.engineering.func_70296_d();
            if (this.field_75222_d >= 2 && this.field_75222_d <= 8) {
                ContainerEngineeringTable.this.engineering.updateRecipe();
            }
        }

        public void func_75215_d(@Nonnull ItemStack stack) {
            ((ContainerEngineeringTable)ContainerEngineeringTable.this).engineering.slots.overrideExtract = true;
            super.func_75215_d(stack);
            ((ContainerEngineeringTable)ContainerEngineeringTable.this).engineering.slots.overrideExtract = false;
        }

        public boolean func_75214_a(@Nonnull ItemStack stack) {
            return this.field_75222_d >= 2 && this.field_75222_d < 8 || ((ContainerEngineeringTable)ContainerEngineeringTable.this).engineering.slots.isItemValidForSlot(this.field_75222_d, stack);
        }
    }
}

