/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.common.block.tile;

import net.darkhax.tesla.api.ITeslaConsumer;
import net.darkhax.tesla.api.ITeslaHolder;
import net.darkhax.tesla.api.ITeslaProducer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.common.Optional;

@Optional.InterfaceList(value={@Optional.Interface(iface="net.darkhax.tesla.api.ITeslaConsumer", modid="tesla"), @Optional.Interface(iface="net.darkhax.tesla.api.ITeslaHolder", modid="tesla"), @Optional.Interface(iface="net.darkhax.tesla.api.ITeslaProducer", modid="tesla")})
public class PowerContainer
implements ITeslaConsumer,
ITeslaHolder,
ITeslaProducer,
INBTSerializable<NBTTagCompound> {
    private long stored = 0L;
    private long capacity = 5000L;
    private long inputRate = 50L;
    private long outputRate = 50L;

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74772_a("power", this.stored);
        tag.func_74772_a("capacity", this.capacity);
        tag.func_74772_a("input", this.inputRate);
        tag.func_74772_a("output", this.outputRate);
        return tag;
    }

    public void deserializeNBT(NBTTagCompound tagCompound) {
        this.stored = tagCompound.func_74763_f("power");
        this.capacity = tagCompound.func_74763_f("capacity");
        this.inputRate = tagCompound.func_74763_f("input");
        this.outputRate = tagCompound.func_74763_f("output");
        if (this.stored > this.getCapacity()) {
            this.stored = this.getCapacity();
        }
    }

    public long getCapacity() {
        return this.capacity;
    }

    public long getStoredPower() {
        return this.stored;
    }

    public long givePower(long Tesla, boolean simulated) {
        long acceptedTesla = Math.min(this.getCapacity() - this.stored, Math.min(this.inputRate, Tesla));
        if (!simulated) {
            this.stored += acceptedTesla;
        }
        return acceptedTesla;
    }

    public long takePower(long Tesla, boolean simulated) {
        long removedPower = Math.min(this.stored, Math.min(this.outputRate, Tesla));
        if (!simulated) {
            this.stored -= removedPower;
        }
        return removedPower;
    }
}

