/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.common.block.tile;

import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.common.CyberwareConfig;
import flaxbeard.cyberware.common.item.ItemBlueprint;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RangedWrapper;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityScanner
extends TileEntity
implements ITickable {
    public ItemStackHandlerScanner slots = new ItemStackHandlerScanner(3);
    private final RangedWrapper slotsTopSides = new RangedWrapper((IItemHandlerModifiable)this.slots, 0, 2);
    private final RangedWrapper slotsBottom = new RangedWrapper((IItemHandlerModifiable)this.slots, 2, 3);
    private final RangedWrapper slotsBottom2 = new RangedWrapper((IItemHandlerModifiable)this.slots, 0, 1);
    public final GuiWrapper guiSlots = new GuiWrapper(this.slots);
    public String customName = null;
    public int ticks = 0;
    public int ticksMove = 0;
    public int lastX = 0;
    public int x = 0;
    public int lastZ = 0;
    public int z = 0;

    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.DOWN) {
                if (!this.slots.getStackInSlot(2).func_190926_b() && !this.slots.getStackInSlot(0).func_190926_b()) {
                    return (T)this.slotsBottom2;
                }
                return (T)this.slotsBottom;
            }
            return (T)this.slotsTopSides;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.slots.deserializeNBT(tagCompound.func_74775_l("inv"));
        if (tagCompound.func_150297_b("CustomName", 8)) {
            this.customName = tagCompound.func_74779_i("CustomName");
        }
        this.ticks = tagCompound.func_74762_e("ticks");
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        tagCompound = super.func_189515_b(tagCompound);
        tagCompound.func_74782_a("inv", (NBTBase)this.slots.serializeNBT());
        if (this.hasCustomName()) {
            tagCompound.func_74778_a("CustomName", this.customName);
        }
        tagCompound.func_74768_a("ticks", this.ticks);
        return tagCompound;
    }

    public void onDataPacket(NetworkManager networkManager, @Nonnull SPacketUpdateTileEntity packetUpdateTileEntity) {
        NBTTagCompound tagCompound = packetUpdateTileEntity.func_148857_g();
        this.func_145839_a(tagCompound);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        this.func_189515_b(tagCompound);
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, tagCompound);
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public boolean isUsableByPlayer(EntityPlayer entityPlayer) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && entityPlayer.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public String getName() {
        return this.hasCustomName() ? this.customName : "cyberware.container.scanner";
    }

    public boolean hasCustomName() {
        return this.customName != null && !this.customName.isEmpty();
    }

    public void setCustomInventoryName(String name) {
        this.customName = name;
    }

    public ITextComponent func_145748_c_() {
        return this.hasCustomName() ? new TextComponentString(this.getName()) : new TextComponentTranslation(this.getName(), new Object[0]);
    }

    public void func_73660_a() {
        ItemStack toDestroy = this.slots.getStackInSlot(0);
        if (CyberwareAPI.canDeconstruct(toDestroy) && toDestroy.func_190916_E() > 0 && this.slots.getStackInSlot(2).func_190926_b()) {
            ++this.ticks;
            if (this.ticksMove > this.ticks || this.ticks - this.ticksMove > Math.max(Math.abs(this.lastX - this.x) * 3, Math.abs(this.lastZ - this.z) * 3) + 10) {
                this.ticksMove = this.ticks;
                this.lastX = this.x;
                this.lastZ = this.z;
                while (this.x == this.lastX) {
                    this.x = this.field_145850_b.field_73012_v.nextInt(11);
                }
                while (this.z == this.lastZ) {
                    this.z = this.field_145850_b.field_73012_v.nextInt(11);
                }
            }
            if (this.ticks > CyberwareConfig.SCANNER_TIME) {
                this.ticks = 0;
                this.ticksMove = 0;
                if (!this.field_145850_b.field_72995_K && !this.slots.getStackInSlot(1).func_190926_b()) {
                    float chance = CyberwareConfig.SCANNER_CHANCE + CyberwareConfig.SCANNER_CHANCE_ADDL * (float)(this.slots.getStackInSlot(0).func_190916_E() - 1);
                    if (this.slots.getStackInSlot(0).func_77984_f()) {
                        chance = 50.0f * (1.0f - (float)this.slots.getStackInSlot(0).func_77952_i() / (float)this.slots.getStackInSlot(0).func_77958_k());
                    }
                    chance = Math.min(chance, 50.0f);
                    if (this.field_145850_b.field_73012_v.nextFloat() < chance / 100.0f) {
                        ItemStack stackBlueprint = ItemBlueprint.getBlueprintForItem(toDestroy);
                        this.slots.setStackInSlot(2, stackBlueprint);
                        ItemStack current = this.slots.getStackInSlot(1);
                        current.func_190918_g(1);
                        if (current.func_190916_E() <= 0) {
                            current = ItemStack.field_190927_a;
                        }
                        this.slots.setStackInSlot(1, current);
                        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.func_174877_v()), this.field_145850_b.func_180495_p(this.func_174877_v()), 2);
                    }
                }
            }
            this.func_70296_d();
        } else {
            this.lastZ = 0;
            this.z = 0;
            this.lastX = 0;
            this.x = 0;
            if (this.ticks != 0) {
                this.ticks = 0;
                this.func_70296_d();
            }
        }
    }

    public float getProgress() {
        return (float)this.ticks * 1.0f / (float)CyberwareConfig.SCANNER_TIME;
    }

    public class GuiWrapper
    implements IItemHandlerModifiable {
        private ItemStackHandlerScanner slots;

        public GuiWrapper(ItemStackHandlerScanner slots) {
            this.slots = slots;
        }

        public int getSlots() {
            return this.slots.getSlots();
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return this.slots.getStackInSlot(slot);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return this.slots.insertItem(slot, stack, simulate);
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.slots.extractItem(slot, amount, simulate);
        }

        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
            this.slots.setStackInSlot(slot, stack);
        }

        public int getSlotLimit(int slot) {
            return 64;
        }
    }

    public class ItemStackHandlerScanner
    extends ItemStackHandler {
        public ItemStackHandlerScanner(int size) {
            super(size);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!this.isItemValidForSlot(slot, stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return super.extractItem(slot, amount, simulate);
        }

        public boolean isItemValidForSlot(int slot, ItemStack stack) {
            this.validateSlotIndex(slot);
            switch (slot) {
                case 0: {
                    return CyberwareAPI.canDeconstruct(stack);
                }
                case 1: {
                    int[] idsOreDictionary = OreDictionary.getOreIDs((ItemStack)stack);
                    int idPaper = OreDictionary.getOreID((String)"paper");
                    for (int idOreDictionary : idsOreDictionary) {
                        if (idOreDictionary != idPaper) continue;
                        return true;
                    }
                    return false;
                }
                case 2: {
                    return false;
                }
            }
            return true;
        }
    }
}

