/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.common.handler;

import flaxbeard.cyberware.Cyberware;
import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.client.ClientUtils;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.input.Mouse;

public class CreativeMenuHandler {
    public static CreativeMenuHandler INSTANCE = new CreativeMenuHandler();
    private static final ResourceLocation CEX_GUI_TEXTURES = new ResourceLocation("cyberware:textures/gui/creative_expansion.png");
    private Minecraft mc = Minecraft.func_71410_x();
    public static int pageSelected = 1;
    private static CEXButton salvaged;
    private static CEXButton manufactured;

    @SubscribeEvent
    public void handleButtons(GuiScreenEvent.InitGuiEvent event) {
        if (event.getGui() instanceof GuiContainerCreative) {
            GuiContainerCreative gui = (GuiContainerCreative)event.getGui();
            int i = (gui.field_146294_l - 136) / 2;
            int j = (gui.field_146295_m - 195) / 2;
            List buttons = event.getButtonList();
            salvaged = new CEXButton(355, i + 166 + 4, j + 30 + 8, 0);
            buttons.add(salvaged);
            manufactured = new CEXButton(356, i + 166 + 4, j + 30 + 31, 1);
            buttons.add(manufactured);
            if (this.isCorrectGui(event.getGui())) {
                CreativeMenuHandler.salvaged.field_146125_m = false;
                CreativeMenuHandler.manufactured.field_146125_m = false;
            }
            event.setButtonList(buttons);
        }
    }

    @SubscribeEvent
    public void handleTooltips(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (this.isCorrectGui(event.getGui())) {
            int mouseX = event.getMouseX();
            int mouseY = event.getMouseY();
            GuiContainerCreative gui = (GuiContainerCreative)event.getGui();
            int i = (gui.field_146294_l - 136) / 2;
            int j = (gui.field_146295_m - 195) / 2;
            if (this.isPointInRegion(i, j, CreativeMenuHandler.salvaged.field_146128_h - i, 37, 18, 18, mouseX, mouseY)) {
                ClientUtils.drawHoveringText((GuiScreen)gui, Collections.singletonList(I18n.func_135052_a((String)CyberwareAPI.QUALITY_SCAVENGED.getUnlocalizedName(), (Object[])new Object[0])), mouseX, mouseY, this.mc.func_175598_ae().func_78716_a());
            }
            if (this.isPointInRegion(i, j, CreativeMenuHandler.manufactured.field_146128_h - i, 60, 18, 18, mouseX, mouseY)) {
                ClientUtils.drawHoveringText((GuiScreen)gui, Collections.singletonList(I18n.func_135052_a((String)CyberwareAPI.QUALITY_MANUFACTURED.getUnlocalizedName(), (Object[])new Object[0])), mouseX, mouseY, this.mc.func_175598_ae().func_78716_a());
            }
        }
    }

    @SubscribeEvent
    public void handleCreativeInventory(GuiScreenEvent.BackgroundDrawnEvent event) {
        if (this.isCorrectGui(event.getGui())) {
            GuiContainerCreative gui = (GuiContainerCreative)event.getGui();
            int i = (gui.field_146294_l - 136) / 2;
            int j = (gui.field_146295_m - 195) / 2;
            int xSize = 29;
            int ySize = 129;
            int xOffset = 0;
            boolean hasVisibleEffect = false;
            for (PotionEffect potioneffect : this.mc.field_71439_g.func_70651_bq()) {
                Potion potion = potioneffect.func_188419_a();
                if (!potion.shouldRender(potioneffect)) continue;
                hasVisibleEffect = true;
                break;
            }
            if (!this.mc.field_71439_g.func_70651_bq().isEmpty() && hasVisibleEffect) {
                xOffset = 59;
            }
            CreativeMenuHandler.salvaged.field_146128_h = CreativeMenuHandler.salvaged.baseX + xOffset;
            CreativeMenuHandler.manufactured.field_146128_h = CreativeMenuHandler.manufactured.baseX + xOffset;
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.mc.func_110434_K().func_110577_a(CEX_GUI_TEXTURES);
            gui.func_73729_b(i + 166 + xOffset, j + 30, 0, 0, xSize, ySize);
            CreativeMenuHandler.salvaged.field_146125_m = true;
            CreativeMenuHandler.manufactured.field_146125_m = true;
        } else {
            if (salvaged != null) {
                CreativeMenuHandler.salvaged.field_146125_m = false;
            }
            if (manufactured != null) {
                CreativeMenuHandler.manufactured.field_146125_m = false;
            }
        }
    }

    @SubscribeEvent
    public void handleButtonClick(GuiScreenEvent.ActionPerformedEvent event) {
        if (this.isCorrectGui(event.getGui())) {
            GuiContainerCreative gui = (GuiContainerCreative)event.getGui();
            if (event.getButton().field_146127_k == CreativeMenuHandler.salvaged.field_146127_k) {
                pageSelected = CreativeMenuHandler.salvaged.offset;
            } else if (event.getButton().field_146127_k == CreativeMenuHandler.manufactured.field_146127_k) {
                pageSelected = CreativeMenuHandler.manufactured.offset;
            }
            gui.func_147050_b(Cyberware.creativeTab);
        }
    }

    private boolean isCorrectGui(GuiScreen gui) {
        if (gui instanceof GuiContainerCreative) {
            return ((GuiContainerCreative)gui).func_147056_g() == Cyberware.creativeTab.func_78021_a();
        }
        return false;
    }

    private boolean isPointInRegion(int i, int j, int rectX, int rectY, int rectWidth, int rectHeight, int pointX, int pointY) {
        return (pointX -= i) >= rectX - 1 && pointX < rectX + rectWidth + 1 && (pointY -= j) >= rectY - 1 && pointY < rectY + rectHeight + 1;
    }

    private static class CEXButton
    extends GuiButton {
        public final int offset;
        public final int baseX;
        public final int baseY;

        public CEXButton(int buttonId, int x, int y, int offset) {
            super(buttonId, x, y, 21, 21, "");
            this.offset = offset;
            this.baseX = this.field_146128_h;
            this.baseY = this.field_146129_i;
        }

        public void func_191745_a(@Nonnull Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                boolean down = Mouse.isButtonDown((int)0);
                boolean flag = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                mc.func_110434_K().func_110577_a(CEX_GUI_TEXTURES);
                boolean isDown = down && flag || pageSelected == this.offset;
                int i = 4;
                int j = 8;
                if (isDown) {
                    i = 29;
                    j = 0;
                }
                this.func_73729_b(this.field_146128_h, this.field_146129_i, i, j += this.offset * (isDown ? 18 : 23), 18, 18);
            }
        }
    }
}

