/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.common.handler;

import com.google.common.collect.HashMultimap;
import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.api.CyberwareUpdateEvent;
import flaxbeard.cyberware.api.ICyberwareUserData;
import flaxbeard.cyberware.api.item.ICyberware;
import flaxbeard.cyberware.client.ClientUtils;
import flaxbeard.cyberware.common.CyberwareConfig;
import flaxbeard.cyberware.common.CyberwareContent;
import flaxbeard.cyberware.common.block.tile.TileEntitySurgery;
import flaxbeard.cyberware.common.item.ItemCyberlimb;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.FoodStats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EssentialsMissingHandler {
    public static final DamageSource brainless = new DamageSource("cyberware.brainless").func_76348_h().func_151518_m();
    public static final DamageSource heartless = new DamageSource("cyberware.heartless").func_76348_h().func_151518_m();
    public static final DamageSource surgery = new DamageSource("cyberware.surgery").func_76348_h();
    public static final DamageSource spineless = new DamageSource("cyberware.spineless").func_76348_h().func_151518_m();
    public static final DamageSource nomuscles = new DamageSource("cyberware.nomuscles").func_76348_h().func_151518_m();
    public static final DamageSource noessence = new DamageSource("cyberware.noessence").func_76348_h().func_151518_m();
    public static final DamageSource lowessence = new DamageSource("cyberware.lowessence").func_76348_h().func_151518_m();
    public static final EssentialsMissingHandler INSTANCE = new EssentialsMissingHandler();
    private static Map<Integer, Integer> timesLungs = new HashMap<Integer, Integer>();
    private static final UUID idMissingLegSpeedAttribute = UUID.fromString("fe00fdea-5044-11e6-beb8-9e71128cae77");
    private static final HashMultimap<String, AttributeModifier> multimapMissingLegSpeedAttribute = HashMultimap.create();
    private Map<Integer, Boolean> last = new HashMap<Integer, Boolean>();
    private Map<Integer, Boolean> lastClient = new HashMap<Integer, Boolean>();
    private static Map<Integer, Integer> mapHunger;
    private static Map<Integer, Float> mapSaturation;
    public static final ResourceLocation BLACK_PX;

    @SubscribeEvent
    public void triggerCyberwareEvent(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entityLivingBase = event.getEntityLiving();
        ICyberwareUserData cyberwareUserData = CyberwareAPI.getCapabilityOrNull((Entity)entityLivingBase);
        if (cyberwareUserData != null) {
            CyberwareUpdateEvent cyberwareUpdateEvent = new CyberwareUpdateEvent(entityLivingBase, cyberwareUserData);
            MinecraftForge.EVENT_BUS.post((Event)cyberwareUpdateEvent);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void handleMissingEssentials(CyberwareUpdateEvent event) {
        ItemStack legRight;
        ItemStack legLeft;
        EntityLivingBase entityLivingBase = event.getEntityLiving();
        ICyberwareUserData cyberwareUserData = event.getCyberwareUserData();
        if (entityLivingBase.field_70173_aa % 20 == 0) {
            cyberwareUserData.resetBuffer();
        }
        if (!cyberwareUserData.hasEssential(ICyberware.EnumSlot.CRANIUM)) {
            entityLivingBase.func_70097_a(brainless, 2.1474836E9f);
        }
        if (entityLivingBase instanceof EntityPlayer && entityLivingBase.field_70173_aa % 20 == 0) {
            int tolerance = cyberwareUserData.getTolerance(entityLivingBase);
            if (tolerance <= 0) {
                entityLivingBase.func_70097_a(noessence, 2.1474836E9f);
            }
            if (tolerance < CyberwareConfig.CRITICAL_ESSENCE && entityLivingBase.field_70173_aa % 100 == 0 && !entityLivingBase.func_70644_a(CyberwareContent.neuropozyneEffect)) {
                entityLivingBase.func_70690_d(new PotionEffect(CyberwareContent.rejectionEffect, 110, 0, true, false));
                entityLivingBase.func_70097_a(lowessence, 2.0f);
            }
            if (!cyberwareUserData.hasEssential(ICyberware.EnumSlot.EYES)) {
                entityLivingBase.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 40));
            }
        }
        int numMissingLegs = 0;
        int numMissingLegsVisible = 0;
        if (!cyberwareUserData.hasEssential(ICyberware.EnumSlot.LEG, ICyberware.ISidedLimb.EnumSide.LEFT)) {
            ++numMissingLegs;
            ++numMissingLegsVisible;
        }
        if (!cyberwareUserData.hasEssential(ICyberware.EnumSlot.LEG, ICyberware.ISidedLimb.EnumSide.RIGHT)) {
            ++numMissingLegs;
            ++numMissingLegsVisible;
        }
        if (!(legLeft = cyberwareUserData.getCyberware(CyberwareContent.cyberlimbs.getCachedStack(2))).func_190926_b() && !ItemCyberlimb.isPowered(legLeft)) {
            ++numMissingLegs;
        }
        if (!(legRight = cyberwareUserData.getCyberware(CyberwareContent.cyberlimbs.getCachedStack(3))).func_190926_b() && !ItemCyberlimb.isPowered(legRight)) {
            ++numMissingLegs;
        }
        if (entityLivingBase instanceof EntityPlayer) {
            if (numMissingLegsVisible == 2) {
                entityLivingBase.field_70131_O = 1.175f;
                ((EntityPlayer)entityLivingBase).eyeHeight = ((EntityPlayer)entityLivingBase).getDefaultEyeHeight() - 0.625f;
                AxisAlignedBB axisalignedbb = entityLivingBase.func_174813_aQ();
                entityLivingBase.func_174826_a(new AxisAlignedBB(axisalignedbb.field_72340_a, axisalignedbb.field_72338_b, axisalignedbb.field_72339_c, axisalignedbb.field_72340_a + (double)entityLivingBase.field_70130_N, axisalignedbb.field_72338_b + (double)entityLivingBase.field_70131_O, axisalignedbb.field_72339_c + (double)entityLivingBase.field_70130_N));
                if (entityLivingBase.field_70170_p.field_72995_K) {
                    this.lastClient.put(entityLivingBase.func_145782_y(), true);
                } else {
                    this.last.put(entityLivingBase.func_145782_y(), true);
                }
            } else if (this.last(entityLivingBase.field_70170_p.field_72995_K, entityLivingBase)) {
                entityLivingBase.field_70131_O = 1.8f;
                ((EntityPlayer)entityLivingBase).eyeHeight = ((EntityPlayer)entityLivingBase).getDefaultEyeHeight();
                AxisAlignedBB axisalignedbb = entityLivingBase.func_174813_aQ();
                entityLivingBase.func_174826_a(new AxisAlignedBB(axisalignedbb.field_72340_a, axisalignedbb.field_72338_b, axisalignedbb.field_72339_c, axisalignedbb.field_72340_a + (double)entityLivingBase.field_70130_N, axisalignedbb.field_72338_b + (double)entityLivingBase.field_70131_O, axisalignedbb.field_72339_c + (double)entityLivingBase.field_70130_N));
                if (entityLivingBase.field_70170_p.field_72995_K) {
                    this.lastClient.put(entityLivingBase.func_145782_y(), false);
                } else {
                    this.last.put(entityLivingBase.func_145782_y(), false);
                }
            }
        }
        if (numMissingLegs >= 1 && entityLivingBase.field_70122_E) {
            entityLivingBase.func_110140_aT().func_111147_b(multimapMissingLegSpeedAttribute);
        } else if (numMissingLegs >= 1 || entityLivingBase.field_70173_aa % 20 == 0) {
            entityLivingBase.func_110140_aT().func_111148_a(multimapMissingLegSpeedAttribute);
        }
        if (!cyberwareUserData.hasEssential(ICyberware.EnumSlot.HEART)) {
            entityLivingBase.func_70097_a(heartless, 2.1474836E9f);
        }
        if (!cyberwareUserData.hasEssential(ICyberware.EnumSlot.BONE)) {
            entityLivingBase.func_70097_a(spineless, 2.1474836E9f);
        }
        if (!cyberwareUserData.hasEssential(ICyberware.EnumSlot.MUSCLE)) {
            entityLivingBase.func_70097_a(nomuscles, 2.1474836E9f);
        }
        if (!cyberwareUserData.hasEssential(ICyberware.EnumSlot.LUNGS)) {
            if (this.getLungsTime(entityLivingBase) >= 20) {
                timesLungs.put(entityLivingBase.func_145782_y(), entityLivingBase.field_70173_aa);
                entityLivingBase.func_70097_a(DamageSource.field_76369_e, 2.0f);
            }
        } else if (entityLivingBase.field_70173_aa % 20 == 0) {
            timesLungs.remove(entityLivingBase.func_145782_y());
        }
    }

    private boolean last(boolean remote, EntityLivingBase entityLivingBase) {
        if (remote) {
            if (!this.lastClient.containsKey(entityLivingBase.func_145782_y())) {
                this.lastClient.put(entityLivingBase.func_145782_y(), false);
            }
            return this.lastClient.get(entityLivingBase.func_145782_y());
        }
        if (!this.last.containsKey(entityLivingBase.func_145782_y())) {
            this.last.put(entityLivingBase.func_145782_y(), false);
        }
        return this.last.get(entityLivingBase.func_145782_y());
    }

    @SubscribeEvent
    public void handleJump(LivingEvent.LivingJumpEvent event) {
        EntityLivingBase entityLivingBase = event.getEntityLiving();
        ICyberwareUserData cyberwareUserData = CyberwareAPI.getCapabilityOrNull((Entity)entityLivingBase);
        if (cyberwareUserData != null) {
            ItemStack legRight;
            ItemStack legLeft;
            int numMissingLegs = 0;
            if (!cyberwareUserData.hasEssential(ICyberware.EnumSlot.LEG, ICyberware.ISidedLimb.EnumSide.LEFT)) {
                ++numMissingLegs;
            }
            if (!cyberwareUserData.hasEssential(ICyberware.EnumSlot.LEG, ICyberware.ISidedLimb.EnumSide.RIGHT)) {
                ++numMissingLegs;
            }
            if (!(legLeft = cyberwareUserData.getCyberware(CyberwareContent.cyberlimbs.getCachedStack(2))).func_190926_b() && !ItemCyberlimb.isPowered(legLeft)) {
                ++numMissingLegs;
            }
            if (!(legRight = cyberwareUserData.getCyberware(CyberwareContent.cyberlimbs.getCachedStack(3))).func_190926_b() && !ItemCyberlimb.isPowered(legRight)) {
                ++numMissingLegs;
            }
            if (numMissingLegs == 2) {
                entityLivingBase.field_70181_x = 0.2f;
            }
        }
    }

    private int getLungsTime(@Nonnull EntityLivingBase entityLivingBase) {
        Integer timeLungs = timesLungs.computeIfAbsent(entityLivingBase.func_145782_y(), k -> entityLivingBase.field_70173_aa);
        return entityLivingBase.field_70173_aa - timeLungs;
    }

    @SubscribeEvent
    public void handleEatFoodTick(LivingEntityUseItemEvent.Tick event) {
        EntityLivingBase entityLivingBase = event.getEntityLiving();
        ItemStack stack = event.getItem();
        if (entityLivingBase == null) {
            return;
        }
        if (entityLivingBase instanceof EntityPlayer && !stack.func_190926_b() && stack.func_77973_b().func_77661_b(stack) == EnumAction.EAT) {
            EntityPlayer entityPlayer = (EntityPlayer)entityLivingBase;
            ICyberwareUserData cyberwareUserData = CyberwareAPI.getCapabilityOrNull((Entity)entityLivingBase);
            if (cyberwareUserData != null && !cyberwareUserData.hasEssential(ICyberware.EnumSlot.LOWER_ORGANS)) {
                mapHunger.put(entityPlayer.func_145782_y(), entityPlayer.func_71024_bL().func_75116_a());
                mapSaturation.put(entityPlayer.func_145782_y(), Float.valueOf(entityPlayer.func_71024_bL().func_75115_e()));
                return;
            }
        }
        mapHunger.remove(entityLivingBase.func_145782_y());
        mapSaturation.remove(entityLivingBase.func_145782_y());
    }

    @SubscribeEvent
    public void handleEatFoodEnd(LivingEntityUseItemEvent.Finish event) {
        EntityLivingBase entityLivingBase = event.getEntityLiving();
        ItemStack stack = event.getItem();
        if (entityLivingBase instanceof EntityPlayer && !stack.func_190926_b() && stack.func_77973_b().func_77661_b(stack) == EnumAction.EAT) {
            EntityPlayer entityPlayer = (EntityPlayer)entityLivingBase;
            ICyberwareUserData cyberwareUserData = CyberwareAPI.getCapabilityOrNull((Entity)entityLivingBase);
            if (cyberwareUserData != null && !cyberwareUserData.hasEssential(ICyberware.EnumSlot.LOWER_ORGANS)) {
                Float saturation;
                Integer hunger = mapHunger.get(entityPlayer.func_145782_y());
                if (hunger != null) {
                    entityPlayer.func_71024_bL().func_75114_a(hunger.intValue());
                }
                if ((saturation = mapSaturation.get(entityPlayer.func_145782_y())) != null) {
                    FoodStats foodStats = entityPlayer.func_71024_bL();
                    NBTTagCompound tagCompound = new NBTTagCompound();
                    foodStats.func_75117_b(tagCompound);
                    tagCompound.func_74776_a("foodSaturationLevel", saturation.floatValue());
                    foodStats.func_75112_a(tagCompound);
                }
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void overlayPre(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START && Minecraft.func_71410_x() != null && Minecraft.func_71410_x().field_71439_g != null) {
            EntityPlayerSP entityPlayer = Minecraft.func_71410_x().field_71439_g;
            entityPlayer.func_110140_aT().func_111148_a(multimapMissingLegSpeedAttribute);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void overlayPre(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            EntityPlayerSP entityPlayer = Minecraft.func_71410_x().field_71439_g;
            if (entityPlayer == null) {
                return;
            }
            ICyberwareUserData cyberwareUserData = CyberwareAPI.getCapabilityOrNull((Entity)entityPlayer);
            if (cyberwareUserData != null && !cyberwareUserData.hasEssential(ICyberware.EnumSlot.EYES) && !entityPlayer.func_184812_l_()) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179147_l();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.9f);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(BLACK_PX);
                ClientUtils.drawTexturedModalRect(0, 0, 0, 0, Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d);
                GlStateManager.func_179121_F();
            }
            if (TileEntitySurgery.workingOnPlayer) {
                float trans = 1.0f;
                float ticks = (float)TileEntitySurgery.playerProgressTicks + event.getPartialTicks();
                if (ticks < 20.0f) {
                    trans = ticks / 20.0f;
                } else if (ticks > 60.0f) {
                    trans = (80.0f - ticks) / 20.0f;
                }
                GlStateManager.func_179147_l();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)trans);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(BLACK_PX);
                ClientUtils.drawTexturedModalRect(0, 0, 0, 0, Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179084_k();
            }
        }
    }

    @SubscribeEvent
    public void handleMissingSkin(LivingHurtEvent event) {
        EntityLivingBase entityLivingBase = event.getEntityLiving();
        ICyberwareUserData cyberwareUserData = CyberwareAPI.getCapabilityOrNull((Entity)entityLivingBase);
        if (!(cyberwareUserData == null || cyberwareUserData.hasEssential(ICyberware.EnumSlot.SKIN) || event.getSource().func_76363_c() && event.getSource() != DamageSource.field_76379_h)) {
            event.setAmount(event.getAmount() * 3.0f);
        }
    }

    @SubscribeEvent
    public void handleEntityInteract(PlayerInteractEvent.EntityInteract event) {
        EntityLivingBase entityLivingBase = event.getEntityLiving();
        ICyberwareUserData cyberwareUserData = CyberwareAPI.getCapabilityOrNull((Entity)entityLivingBase);
        if (cyberwareUserData != null) {
            this.processEvent((Event)event, event.getHand(), event.getEntityPlayer(), cyberwareUserData);
        }
    }

    @SubscribeEvent
    public void handleLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        EntityLivingBase entityLivingBase = event.getEntityLiving();
        ICyberwareUserData cyberwareUserData = CyberwareAPI.getCapabilityOrNull((Entity)entityLivingBase);
        if (cyberwareUserData != null) {
            this.processEvent((Event)event, event.getHand(), event.getEntityPlayer(), cyberwareUserData);
        }
    }

    @SubscribeEvent
    public void handleRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        EntityLivingBase entityLivingBase = event.getEntityLiving();
        ICyberwareUserData cyberwareUserData = CyberwareAPI.getCapabilityOrNull((Entity)entityLivingBase);
        if (cyberwareUserData != null) {
            this.processEvent((Event)event, event.getHand(), event.getEntityPlayer(), cyberwareUserData);
        }
    }

    @SubscribeEvent
    public void handleRightClickItem(PlayerInteractEvent.RightClickItem event) {
        EntityLivingBase entityLivingBase = event.getEntityLiving();
        ICyberwareUserData cyberwareUserData = CyberwareAPI.getCapabilityOrNull((Entity)entityLivingBase);
        if (cyberwareUserData != null) {
            this.processEvent((Event)event, event.getHand(), event.getEntityPlayer(), cyberwareUserData);
        }
    }

    private void processEvent(Event event, EnumHand hand, EntityPlayer entityPlayer, ICyberwareUserData cyberwareUserData) {
        EnumHandSide mainHand = entityPlayer.func_184591_cq();
        EnumHandSide offHand = mainHand == EnumHandSide.LEFT ? EnumHandSide.RIGHT : EnumHandSide.LEFT;
        ICyberware.ISidedLimb.EnumSide correspondingMainHand = mainHand == EnumHandSide.RIGHT ? ICyberware.ISidedLimb.EnumSide.RIGHT : ICyberware.ISidedLimb.EnumSide.LEFT;
        ICyberware.ISidedLimb.EnumSide correspondingOffHand = offHand == EnumHandSide.RIGHT ? ICyberware.ISidedLimb.EnumSide.RIGHT : ICyberware.ISidedLimb.EnumSide.LEFT;
        boolean leftUnpowered = false;
        ItemStack armLeft = cyberwareUserData.getCyberware(CyberwareContent.cyberlimbs.getCachedStack(0));
        if (!armLeft.func_190926_b() && !ItemCyberlimb.isPowered(armLeft)) {
            leftUnpowered = true;
        }
        boolean rightUnpowered = false;
        ItemStack armRight = cyberwareUserData.getCyberware(CyberwareContent.cyberlimbs.getCachedStack(1));
        if (!armRight.func_190926_b() && !ItemCyberlimb.isPowered(armRight)) {
            rightUnpowered = true;
        }
        if (hand == EnumHand.MAIN_HAND && (!cyberwareUserData.hasEssential(ICyberware.EnumSlot.ARM, correspondingMainHand) || leftUnpowered)) {
            event.setCanceled(true);
        } else if (hand == EnumHand.OFF_HAND && (!cyberwareUserData.hasEssential(ICyberware.EnumSlot.ARM, correspondingOffHand) || rightUnpowered)) {
            event.setCanceled(true);
        }
    }

    static {
        multimapMissingLegSpeedAttribute.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(idMissingLegSpeedAttribute, "Missing leg speed", -100.0, 0));
        mapHunger = new HashMap<Integer, Integer>();
        mapSaturation = new HashMap<Integer, Float>();
        BLACK_PX = new ResourceLocation("cyberware:textures/gui/blackpx.png");
    }
}

