/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.common.item;

import com.google.common.collect.HashMultimap;
import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.api.ICyberwareUserData;
import flaxbeard.cyberware.api.item.ICyberware;
import flaxbeard.cyberware.common.item.ItemCyberware;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ItemBoneUpgrade
extends ItemCyberware {
    public static final int META_LACING = 0;
    public static final int META_FLEX = 1;
    public static final int META_BATTERY = 2;
    public static final int MAX_STACK_SIZE_LACING = 5;
    private static final UUID idBoneHealthAttribute = UUID.fromString("8bce997a-4c3a-11e6-beb8-9e71128cae77");
    private static final HashMap<Integer, HashMultimap<String, AttributeModifier>> multimapBoneHealthAttributes = new HashMap(6);

    public ItemBoneUpgrade(String name, ICyberware.EnumSlot slot, String[] subnames) {
        super(name, slot, subnames);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private static HashMultimap<String, AttributeModifier> getBoneHealthAttribute(int stackSize) {
        HashMultimap multimapBoneHealthAttribute = multimapBoneHealthAttributes.get(stackSize);
        if (multimapBoneHealthAttribute == null) {
            multimapBoneHealthAttribute = HashMultimap.create();
            multimapBoneHealthAttribute.put((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)new AttributeModifier(idBoneHealthAttribute, "Bone hp upgrade", (double)(4.0f * (float)stackSize), 0));
            multimapBoneHealthAttributes.put(stackSize, (HashMultimap<String, AttributeModifier>)multimapBoneHealthAttribute);
        }
        return multimapBoneHealthAttribute;
    }

    @Override
    public void onAdded(EntityLivingBase entityLivingBase, ItemStack stack) {
        if (stack.func_77952_i() == 0) {
            entityLivingBase.func_110140_aT().func_111147_b(ItemBoneUpgrade.getBoneHealthAttribute(stack.func_190916_E()));
        }
    }

    @Override
    public void onRemoved(EntityLivingBase entityLivingBase, ItemStack stack) {
        if (stack.func_77952_i() == 0) {
            entityLivingBase.func_110140_aT().func_111148_a(ItemBoneUpgrade.getBoneHealthAttribute(stack.func_190916_E()));
        }
    }

    @SubscribeEvent
    public void handleJoinWorld(EntityJoinWorldEvent event) {
        if (!(event.getEntity() instanceof EntityLivingBase)) {
            return;
        }
        EntityLivingBase entityLivingBase = (EntityLivingBase)event.getEntity();
        if (entityLivingBase.field_70173_aa % 20 != 0) {
            return;
        }
        ICyberwareUserData cyberwareUserData = CyberwareAPI.getCapabilityOrNull((Entity)entityLivingBase);
        if (cyberwareUserData != null) {
            ItemStack itemStackMetalLacing = cyberwareUserData.getCyberware(this.getCachedStack(0));
            if (!itemStackMetalLacing.func_190926_b()) {
                this.onAdded(entityLivingBase, cyberwareUserData.getCyberware(itemStackMetalLacing));
            } else {
                this.onRemoved(entityLivingBase, itemStackMetalLacing);
            }
        }
    }

    @SubscribeEvent
    public void handleFallDamage(LivingHurtEvent event) {
        if (event.getSource() != DamageSource.field_76379_h) {
            return;
        }
        EntityLivingBase entityLivingBase = event.getEntityLiving();
        ICyberwareUserData cyberwareUserData = CyberwareAPI.getCapabilityOrNull((Entity)entityLivingBase);
        if (cyberwareUserData == null) {
            return;
        }
        if (cyberwareUserData.isCyberwareInstalled(this.getCachedStack(1))) {
            event.setAmount(event.getAmount() * 0.3333f);
        }
    }

    @Override
    public boolean isIncompatible(ItemStack stack, ItemStack other) {
        return other.func_77973_b() == this;
    }

    @Override
    public int getCapacity(ItemStack wareStack) {
        return wareStack.func_77952_i() == 2 ? 900 * wareStack.func_190916_E() : 0;
    }

    @Override
    public int installedStackSize(ItemStack stack) {
        return stack.func_77952_i() == 0 ? 5 : (stack.func_77952_i() == 2 ? 4 : 1);
    }

    @Override
    protected int getUnmodifiedEssenceCost(ItemStack stack) {
        if (stack.func_77952_i() == 0) {
            switch (stack.func_190916_E()) {
                case 1: {
                    return 3;
                }
                case 2: {
                    return 6;
                }
                case 3: {
                    return 9;
                }
                case 4: {
                    return 12;
                }
                case 5: {
                    return 15;
                }
            }
        }
        if (stack.func_77952_i() == 2) {
            switch (stack.func_190916_E()) {
                case 1: {
                    return 2;
                }
                case 2: {
                    return 3;
                }
                case 3: {
                    return 4;
                }
                case 4: {
                    return 5;
                }
            }
        }
        return super.getUnmodifiedEssenceCost(stack);
    }
}

