/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.common.network;

import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.api.ICyberwareUserData;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class SyncHudDataPacket
implements IMessage {
    private NBTTagCompound tagCompound;

    public SyncHudDataPacket() {
    }

    public SyncHudDataPacket(NBTTagCompound tagCompound) {
        this.tagCompound = tagCompound;
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.tagCompound);
    }

    public void fromBytes(ByteBuf buf) {
        this.tagCompound = ByteBufUtils.readTag((ByteBuf)buf);
    }

    private static class DoSync
    implements Runnable {
        private NBTTagCompound tagCompound;
        private EntityPlayer entityPlayer;

        public DoSync(NBTTagCompound tagCompound, EntityPlayer entityPlayer) {
            this.tagCompound = tagCompound;
            this.entityPlayer = entityPlayer;
        }

        @Override
        public void run() {
            ICyberwareUserData cyberwareUserData = CyberwareAPI.getCapabilityOrNull((Entity)this.entityPlayer);
            if (cyberwareUserData != null) {
                cyberwareUserData.setHudData(this.tagCompound);
            }
        }
    }

    public static class SyncHudDataPacketHandler
    implements IMessageHandler<SyncHudDataPacket, IMessage> {
        public IMessage onMessage(SyncHudDataPacket message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            DimensionManager.getWorld((int)player.field_70170_p.field_73011_w.getDimension()).func_152344_a((Runnable)new DoSync(message.tagCompound, (EntityPlayer)player));
            return null;
        }
    }
}

