/*
 * Decompiled with CFR 0.152.
 */
package us.timinc.interactions.event;

import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import us.timinc.interactions.recipe.InteractRecipe;
import us.timinc.interactions.recipe.InteractRecipes;
import us.timinc.interactions.util.IdUtil;
import us.timinc.interactions.util.MinecraftUtil;
import us.timinc.interactions.util.RandUtil;

public class InteractionHandler {
    public InteractRecipes interactRecipes = new InteractRecipes();

    public void reload() {
        this.interactRecipes = new InteractRecipes();
    }

    @SubscribeEvent
    public void onInteraction(PlayerInteractEvent.RightClickBlock event) {
        if (!event.getEntityPlayer().func_175151_a(event.getPos(), event.getFace(), event.getEntityPlayer().func_184586_b(event.getHand()))) {
            return;
        }
        this.processMatchinInteractions(event);
    }

    private void processMatchinInteractions(PlayerInteractEvent.RightClickBlock event) {
        ArrayList<InteractRecipe> matches = this.interactRecipes.findMatches(event);
        matches.forEach(r -> this.processInteraction((InteractRecipe)r, event));
    }

    private void processInteraction(InteractRecipe recipe, PlayerInteractEvent.RightClickBlock event) {
        if (event.getWorld().field_72995_K) {
            this.processInteractionClient(recipe, event);
        } else {
            this.processInteractionServer(recipe, event);
        }
    }

    private void processInteractionServer(InteractRecipe recipe, PlayerInteractEvent.RightClickBlock event) {
        World world = event.getWorld();
        BlockPos targetPosition = event.getPos();
        EntityPlayer player = event.getEntityPlayer();
        ItemStack heldItem = player.func_184586_b(event.getHand());
        boolean success = recipe.rollForChangeBlock();
        if (recipe.changesTargetBlock() && success) {
            world.func_175656_a(targetPosition, recipe.getChangeBlockState());
        }
        if (recipe.dropsItem(success) && recipe.rollForDropItem()) {
            EntityItem itemDropEntity = MinecraftUtil.createEntityItem(world, event.getHitVec(), recipe.createDrop());
            world.func_72838_d((Entity)itemDropEntity);
        }
        if (recipe.damagesHeldItem(success) && recipe.rollForDamageItem()) {
            MinecraftUtil.damageItemStack(heldItem, recipe.getDamage(), (EntityLivingBase)player);
        }
    }

    private void processInteractionClient(InteractRecipe recipe, PlayerInteractEvent.RightClickBlock event) {
        World world = event.getWorld();
        BlockPos targetPosition = event.getPos();
        if (recipe.spawnsParticles()) {
            int count = recipe.rollForParticleCount();
            for (int i = 0; i <= count; ++i) {
                double[] particlePosition = this.getParticlePosition(targetPosition, recipe.getParticleArea());
                world.func_175688_a(EnumParticleTypes.func_186831_a((String)recipe.getParticleName()), particlePosition[0], particlePosition[1], particlePosition[2], (double)((float)Math.random()) * 0.02, (double)((float)Math.random()) * 0.02, (double)((float)Math.random()) * 0.02, new int[]{recipe.getParticleParam().isEmpty() ? 0 : Item.func_150891_b((Item)IdUtil.createItemStackFrom(recipe.getParticleParam(), 1).func_77973_b())});
            }
        }
    }

    private double[] getParticlePosition(BlockPos targetPosition, String string) {
        double[] retval = new double[3];
        switch (string) {
            case "in": {
                retval[0] = (double)targetPosition.func_177958_n() + Math.random();
                retval[1] = (double)targetPosition.func_177956_o() + Math.random();
                retval[2] = (double)targetPosition.func_177952_p() + Math.random();
                break;
            }
            case "out": {
                int side = RandUtil.roll(0, 2);
                double[] sideFinder = new double[]{-0.1, 1.1};
                retval[0] = (double)targetPosition.func_177958_n() + (side == 0 ? sideFinder[RandUtil.roll(0, 1)] : Math.random());
                retval[1] = (double)targetPosition.func_177956_o() + (side == 1 ? sideFinder[RandUtil.roll(0, 1)] : Math.random());
                retval[2] = (double)targetPosition.func_177952_p() + (side == 2 ? sideFinder[RandUtil.roll(0, 1)] : Math.random());
            }
        }
        return retval;
    }
}

