/*
 * Decompiled with CFR 0.152.
 */
package io.github.mribby.babyanimals;

import io.github.mribby.babyanimals.Proxy;
import io.github.mribby.babyanimals.renderer.RenderBunny;
import io.github.mribby.babyanimals.renderer.RenderCalf;
import io.github.mribby.babyanimals.renderer.RenderChick;
import io.github.mribby.babyanimals.renderer.RenderKitten;
import io.github.mribby.babyanimals.renderer.RenderLamb;
import io.github.mribby.babyanimals.renderer.RenderMooshroomCalf;
import io.github.mribby.babyanimals.renderer.RenderPiglet;
import io.github.mribby.babyanimals.renderer.RenderPuppy;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ProxyClient
extends Proxy {
    public static final HashMap<Class<? extends EntityLivingBase>, RenderLivingBase> ENTITY_RENDERER_MAP = new HashMap();
    private boolean isRendering;
    private boolean forceBabyModels;

    @Override
    public void init() {
        RenderManager renderManager = Minecraft.func_71410_x().func_175598_ae();
        this.registerRenderer((Class)EntityPig.class, "enablePig", (RenderLivingBase)new RenderPiglet(renderManager));
        this.registerRenderer((Class)EntitySheep.class, "enableSheep", (RenderLivingBase)new RenderLamb(renderManager));
        this.registerRenderer((Class)EntityCow.class, "enableCow", (RenderLivingBase)new RenderCalf(renderManager));
        this.registerRenderer((Class)EntityMooshroom.class, "enableMooshroom", (RenderLivingBase)new RenderMooshroomCalf(renderManager));
        this.registerRenderer((Class)EntityWolf.class, "enableWolf", (RenderLivingBase)new RenderPuppy(renderManager));
        this.registerRenderer((Class)EntityChicken.class, "enableChicken", (RenderLivingBase)new RenderChick(renderManager));
        this.registerRenderer((Class)EntityRabbit.class, "enableRabbit", (RenderLivingBase)new RenderBunny(renderManager));
        this.registerRenderer((Class)EntityOcelot.class, "enableOcelot", (RenderLivingBase)new RenderKitten(renderManager));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private <T extends EntityLivingBase> void registerRenderer(Class<T> clazz, String configKey, RenderLivingBase<T> renderer) {
        ENTITY_RENDERER_MAP.put(clazz, renderer);
    }

    @SubscribeEvent
    public void onRenderLivingPre(RenderLivingEvent.Pre event) {
        RenderLivingBase renderer;
        EntityLivingBase entity;
        if (!this.isRendering && ((entity = event.getEntity()).func_70631_g_() || this.forceBabyModels) && (renderer = ENTITY_RENDERER_MAP.get(entity.getClass())) != null) {
            this.isRendering = true;
            renderer.func_76986_a(entity, event.getX(), event.getY(), event.getZ(), 0.0f, Minecraft.func_71410_x().func_184121_ak());
            this.isRendering = false;
            event.setCanceled(true);
        }
    }
}

