/*
 * Decompiled with CFR 0.152.
 */
package io.github.mribby.babyanimals;

import io.github.mribby.babyanimals.BabyAnimalsMod;
import io.github.mribby.babyanimals.renderer.RenderBunny;
import io.github.mribby.babyanimals.renderer.RenderCalf;
import io.github.mribby.babyanimals.renderer.RenderChick;
import io.github.mribby.babyanimals.renderer.RenderLamb;
import io.github.mribby.babyanimals.renderer.RenderMooshroomCalf;
import io.github.mribby.babyanimals.renderer.RenderOcelotKitten;
import io.github.mribby.babyanimals.renderer.RenderPiglet;
import io.github.mribby.babyanimals.renderer.RenderPuppy;
import io.github.mribby.babyanimals.util.ConfigurationProperties;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.passive.CowEntity;
import net.minecraft.entity.passive.MooshroomEntity;
import net.minecraft.entity.passive.OcelotEntity;
import net.minecraft.entity.passive.PigEntity;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class BabyAnimalsClient {
    public static final HashMap<Class<? extends LivingEntity>, LivingRenderer> ENTITY_RENDERER_MAP = new HashMap();
    private static ConfigurationProperties config;
    private static boolean isRendering;
    private static boolean forceBabyModels;

    public static void init() {
        config = new ConfigurationProperties(BabyAnimalsMod.configFile);
        config.read();
        EntityRendererManager renderManager = Minecraft.func_71410_x().func_175598_ae();
        forceBabyModels = config.getProperty("forceBabyModels", false);
        BabyAnimalsClient.registerRenderer(PigEntity.class, "enablePig", new RenderPiglet(renderManager));
        BabyAnimalsClient.registerRenderer(SheepEntity.class, "enableSheep", new RenderLamb(renderManager));
        BabyAnimalsClient.registerRenderer(CowEntity.class, "enableCow", new RenderCalf(renderManager));
        BabyAnimalsClient.registerRenderer(MooshroomEntity.class, "enableMooshroom", new RenderMooshroomCalf(renderManager));
        BabyAnimalsClient.registerRenderer(WolfEntity.class, "enableWolf", new RenderPuppy(renderManager));
        BabyAnimalsClient.registerRenderer(ChickenEntity.class, "enableChicken", new RenderChick(renderManager));
        BabyAnimalsClient.registerRenderer(RabbitEntity.class, "enableRabbit", new RenderBunny(renderManager));
        BabyAnimalsClient.registerRenderer(OcelotEntity.class, "enableOcelot", new RenderOcelotKitten(renderManager));
        config.save();
        MinecraftForge.EVENT_BUS.register(BabyAnimalsClient.class);
    }

    private static <T extends LivingEntity, M extends EntityModel<T>> void registerRenderer(Class<T> clazz, String configKey, LivingRenderer<T, M> renderer) {
        if (config.getProperty(configKey, true)) {
            ENTITY_RENDERER_MAP.put(clazz, renderer);
        }
    }

    @SubscribeEvent
    public static void onRenderLivingPre(RenderLivingEvent.Pre event) {
        LivingRenderer renderer;
        LivingEntity entity;
        if (!isRendering && ((entity = event.getEntity()).func_70631_g_() || forceBabyModels) && (renderer = ENTITY_RENDERER_MAP.get(entity.getClass())) != null) {
            isRendering = true;
            renderer.func_76986_a(entity, event.getX(), event.getY(), event.getZ(), 0.0f, Minecraft.func_71410_x().func_184121_ak());
            isRendering = false;
            event.setCanceled(true);
        }
    }
}

