/*
 * Decompiled with CFR 0.152.
 */
package io.github.mribby.babyanimals.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class ConfigurationProperties
extends Properties {
    private final File file;

    public ConfigurationProperties(File file) {
        this(null, file);
    }

    public ConfigurationProperties(Properties defaults, File file) {
        super(defaults);
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public synchronized void read() {
        try {
            this.load();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void load() throws IOException {
        this.load(new FileInputStream(this.file));
    }

    public void save() {
        this.save(null);
    }

    public void save(String comments) {
        try {
            this.store(comments);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void store(String comments) throws IOException {
        this.store(new FileOutputStream(this.file), comments);
    }

    public synchronized Object setProperty(String key, boolean value) {
        return this.setProperty(key, String.valueOf(value));
    }

    public synchronized Object setProperty(String key, char value) {
        return this.setProperty(key, String.valueOf(value));
    }

    public synchronized Object setProperty(String key, int value) {
        return this.setProperty(key, String.valueOf(value));
    }

    public synchronized Object setProperty(String key, long value) {
        return this.setProperty(key, String.valueOf(value));
    }

    public synchronized Object setProperty(String key, float value) {
        return this.setProperty(key, String.valueOf(value));
    }

    public synchronized Object setProperty(String key, double value) {
        return this.setProperty(key, String.valueOf(value));
    }

    public boolean getBooleanProperty(String key) throws IllegalArgumentException {
        String s = this.getProperty(key);
        if (s == null) {
            throw new IllegalArgumentException("null");
        }
        if (s.equalsIgnoreCase("true")) {
            return true;
        }
        if (s.equalsIgnoreCase("false")) {
            return false;
        }
        throw new IllegalArgumentException("For input string: \"" + s + "\"");
    }

    public char getCharProperty(String key) throws IllegalArgumentException {
        String s = this.getProperty(key);
        if (s == null) {
            throw new IllegalArgumentException("null");
        }
        if (s.length() != 1) {
            throw new IllegalArgumentException("For input string: \"" + s + "\"");
        }
        return s.charAt(0);
    }

    public int getIntProperty(String key) throws NumberFormatException {
        return Integer.parseInt(this.getProperty(key));
    }

    public long getLongProperty(String key) throws NumberFormatException {
        return Long.parseLong(this.getProperty(key));
    }

    public float getFloatProperty(String key) throws NumberFormatException {
        return Float.parseFloat(this.getProperty(key));
    }

    public double getDoubleProperty(String key) throws NumberFormatException {
        return Double.parseDouble(this.getProperty(key));
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        String val = this.getProperty(key);
        if (val == null) {
            this.setProperty(key, defaultValue);
            return defaultValue;
        }
        return val;
    }

    public boolean getProperty(String key, boolean defaultValue) {
        try {
            return this.getBooleanProperty(key);
        }
        catch (IllegalArgumentException e) {
            this.setProperty(key, defaultValue);
            return defaultValue;
        }
    }

    public char getProperty(String key, char defaultValue) {
        try {
            return this.getCharProperty(key);
        }
        catch (IllegalArgumentException e) {
            this.setProperty(key, defaultValue);
            return defaultValue;
        }
    }

    public int getProperty(String key, int defaultValue) {
        try {
            return this.getIntProperty(key);
        }
        catch (NumberFormatException e) {
            this.setProperty(key, defaultValue);
            return defaultValue;
        }
    }

    public long getProperty(String key, long defaultValue) {
        try {
            return this.getLongProperty(key);
        }
        catch (NumberFormatException e) {
            this.setProperty(key, defaultValue);
            return defaultValue;
        }
    }

    public float getProperty(String key, float defaultValue) {
        try {
            return this.getFloatProperty(key);
        }
        catch (NumberFormatException e) {
            this.setProperty(key, defaultValue);
            return defaultValue;
        }
    }

    public double getProperty(String key, double defaultValue) {
        try {
            return this.getDoubleProperty(key);
        }
        catch (NumberFormatException e) {
            this.setProperty(key, defaultValue);
            return defaultValue;
        }
    }
}

