/*
 * Decompiled with CFR 0.152.
 */
package io.github.mribby.babyanimals;

import com.google.common.io.ByteStreams;
import com.google.gson.Gson;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.versioning.DefaultArtifactVersion;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;

public class VersionChecker {
    public static void startVersionCheck() {
        new Thread("Baby Animals Model Swapper Version Check"){

            @Override
            public void run() {
                try {
                    URL url = new URL("https://gist.githubusercontent.com/MrIbby/b25a49bdf1ffe888dd6956f025d1af28/raw");
                    InputStream con = url.openStream();
                    String data = new String(ByteStreams.toByteArray((InputStream)con));
                    con.close();
                    Map json = (Map)new Gson().fromJson(data, Map.class);
                    String homepage = (String)json.get("homepage");
                    Map promos = (Map)json.get("promos");
                    String rec = (String)promos.get("1.7.10-recommended");
                    String lat = (String)promos.get("1.7.10-latest");
                    DefaultArtifactVersion current = new DefaultArtifactVersion("1.7.10-4");
                    String target = null;
                    if (rec != null) {
                        DefaultArtifactVersion recommended = new DefaultArtifactVersion(rec);
                        int diff = recommended.compareTo((Object)current);
                        if (diff < 0) {
                            if (lat != null && current.compareTo((Object)new DefaultArtifactVersion(lat)) < 0) {
                                target = lat;
                            }
                        } else if (diff > 0) {
                            target = rec;
                        }
                    } else if (lat != null && current.compareTo((Object)new DefaultArtifactVersion(lat)) < 0) {
                        target = lat;
                    }
                    if (target != null) {
                        VersionChecker.sendUpdateIMCMessage(target, homepage);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }.start();
    }

    private static void sendUpdateIMCMessage(String newVersion, String updateUrl) {
        if (Loader.isModLoaded((String)"VersionChecker")) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("modDisplayName", "Baby Animals Model Swapper");
            tag.func_74778_a("oldVersion", "1.7.10-4");
            tag.func_74778_a("newVersion", newVersion);
            tag.func_74778_a("updateUrl", updateUrl);
            tag.func_74757_a("isDirectLink", false);
            FMLInterModComms.sendRuntimeMessage((Object)"babyanimals", (String)"VersionChecker", (String)"addUpdate", (NBTTagCompound)tag);
        }
    }
}

