/*
 * Decompiled with CFR 0.152.
 */
package io.github.mribby.babyanimals;

import io.github.mribby.babyanimals.BabyAnimalsMod;
import io.github.mribby.babyanimals.Proxy;
import io.github.mribby.babyanimals.renderer.RenderBunny;
import io.github.mribby.babyanimals.renderer.RenderCalf;
import io.github.mribby.babyanimals.renderer.RenderChick;
import io.github.mribby.babyanimals.renderer.RenderKitten;
import io.github.mribby.babyanimals.renderer.RenderLamb;
import io.github.mribby.babyanimals.renderer.RenderMooshroomCalf;
import io.github.mribby.babyanimals.renderer.RenderPiglet;
import io.github.mribby.babyanimals.renderer.RenderPuppy;
import java.util.HashMap;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RendererLivingEntity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class ProxyClient
extends Proxy {
    public static final HashMap<Class<? extends EntityLivingBase>, RendererLivingEntity> ENTITY_RENDERER_MAP = new HashMap();
    private Configuration config;
    private float renderTickTime;
    private boolean isRendering;
    private boolean forceBabyModels;

    @Override
    public void init() {
        this.config = new Configuration(BabyAnimalsMod.configFile);
        this.forceBabyModels = this.config.get("client", "forceBabyModels", false).getBoolean();
        RenderManager renderManager = FMLClientHandler.instance().getClient().func_175598_ae();
        this.registerRenderer((Class)EntityPig.class, "enablePig", (RendererLivingEntity)new RenderPiglet(renderManager));
        this.registerRenderer((Class)EntitySheep.class, "enableSheep", (RendererLivingEntity)new RenderLamb(renderManager));
        this.registerRenderer((Class)EntityCow.class, "enableCow", (RendererLivingEntity)new RenderCalf(renderManager));
        this.registerRenderer((Class)EntityMooshroom.class, "enableMooshroom", (RendererLivingEntity)new RenderMooshroomCalf(renderManager));
        this.registerRenderer((Class)EntityWolf.class, "enableWolf", (RendererLivingEntity)new RenderPuppy(renderManager));
        this.registerRenderer((Class)EntityChicken.class, "enableChicken", (RendererLivingEntity)new RenderChick(renderManager));
        this.registerRenderer((Class)EntityRabbit.class, "enableRabbit", (RendererLivingEntity)new RenderBunny(renderManager));
        this.registerRenderer((Class)EntityOcelot.class, "enableOcelot", (RendererLivingEntity)new RenderKitten(renderManager));
        this.config.save();
        FMLCommonHandler.instance().bus().register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private <T extends EntityLivingBase> void registerRenderer(Class<T> clazz, String configKey, RendererLivingEntity<T> renderer) {
        if (this.config.get("client", configKey, true).getBoolean()) {
            ENTITY_RENDERER_MAP.put(clazz, renderer);
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            this.renderTickTime = event.renderTickTime;
        }
    }

    @SubscribeEvent
    public void onRenderLivingPre(RenderLivingEvent.Pre event) {
        RendererLivingEntity renderer;
        EntityLivingBase entity;
        if (!this.isRendering && ((entity = event.entity).func_70631_g_() || this.forceBabyModels) && (renderer = ENTITY_RENDERER_MAP.get(entity.getClass())) != null) {
            this.isRendering = true;
            renderer.func_76986_a(entity, event.x, event.y, event.z, 0.0f, this.renderTickTime);
            this.isRendering = false;
            event.setCanceled(true);
        }
    }
}

