/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.denseores;

import com.rwtema.denseores.DenseOresConfig;
import com.rwtema.denseores.DenseOresRegistry;
import com.rwtema.denseores.LogHelper;
import com.rwtema.denseores.ModIntegration;
import com.rwtema.denseores.Proxy;
import com.rwtema.denseores.WorldGenOres;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLMissingMappingsEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraftforge.common.MinecraftForge;

@Mod(modid="denseores", version="1.0", dependencies="after:*")
public class DenseOresMod {
    public static final String MODID = "denseores";
    public static final String VERSION = "1.0";
    @SidedProxy(serverSide="com.rwtema.denseores.Proxy", clientSide="com.rwtema.denseores.ProxyClient")
    public static Proxy proxy;
    private File config;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.config = event.getSuggestedConfigurationFile();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        LogHelper.info("Ph'nglui mglw'nafh, y'uln Dense Ores shugg ch'agl", new Object[0]);
        DenseOresConfig.instance.loadConfig(this.config);
        DenseOresRegistry.buildBlocks();
        DenseOresRegistry.buildOreDictionary();
        ModIntegration.addModIntegration();
        WorldGenOres worldGen = new WorldGenOres();
        GameRegistry.registerWorldGenerator((IWorldGenerator)worldGen, (int)1000);
        MinecraftForge.EVENT_BUS.register((Object)worldGen);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit();
        LogHelper.info("Dense Ores is fully loaded but sadly it cannot tell you the unlocalized name for dirt.", new Object[0]);
    }

    @Mod.EventHandler
    public void checkMappings(FMLMissingMappingsEvent event) {
        for (FMLMissingMappingsEvent.MissingMapping map : event.getAll()) {
            if (!map.name.startsWith("specialores:") && !map.name.startsWith("denseores:")) continue;
            int k = -1;
            for (int i : DenseOresRegistry.blocks.keySet()) {
                if (!map.name.endsWith(Integer.toString(i)) || k != -1 && Integer.toString(k).length() >= Integer.toString(i).length()) continue;
                k = i;
            }
            if (k < 0) continue;
            if (map.type == GameRegistry.Type.BLOCK) {
                map.remap((Block)DenseOresRegistry.blocks.get(k));
                continue;
            }
            if (map.type != GameRegistry.Type.ITEM) continue;
            map.remap(Item.func_150898_a((Block)((Block)DenseOresRegistry.blocks.get(k))));
        }
    }
}

