/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.denseores;

import com.rwtema.denseores.DenseOre;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockOre;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockDenseOre
extends BlockOre {
    public static int maxMetdata;
    public PropertyInteger METADATA;
    public IBakedModel[] models;
    public IBakedModel[] invmodels;
    public DenseOre[] entry;
    public Block[] baseBlocks;
    public boolean[] valid;
    public boolean init = false;

    public BlockDenseOre() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)this.METADATA, (Comparable)Integer.valueOf(0)));
        this.entry = new DenseOre[maxMetdata];
        this.baseBlocks = new Block[maxMetdata];
        this.valid = new boolean[maxMetdata];
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)this.METADATA, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.METADATA);
    }

    public static Block getBlock(String name) {
        return (Block)GameData.getBlockRegistry().func_82594_a((Object)new ResourceLocation(name));
    }

    public static Block getBlock(DenseOre ore) {
        return ore != null ? BlockDenseOre.getBlock(ore.baseBlock) : null;
    }

    public void init() {
        this.init = true;
        for (int i = 0; i < maxMetdata; ++i) {
            this.baseBlocks[i] = BlockDenseOre.getBlock(this.entry[i]);
            this.valid[i] = this.baseBlocks[i] != null && this.baseBlocks[i] != Blocks.field_150350_a;
        }
    }

    protected BlockState func_180661_e() {
        this.METADATA = PropertyInteger.func_177719_a((String)"Type", (int)0, (int)(maxMetdata - 1));
        return new BlockState((Block)this, new IProperty[]{this.METADATA});
    }

    public Block getBlock(int id) {
        if (!this.init) {
            this.init();
        }
        return this.baseBlocks[id];
    }

    public IBlockState getBaseBlockState(int id) {
        return this.entry[id].getBaseBlock().func_176203_a(this.entry[id].metadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(World world, BlockPos pos, IBlockState state, Random rand) {
        int id = this.func_176201_c(world.func_180495_p(pos));
        if (!this.isValid(id)) {
            return;
        }
        try {
            world.func_180501_a(pos, this.getBaseBlockState(id), 0);
            for (int i = 0; i < 1 + rand.nextInt(3); ++i) {
                this.getBlock(id).func_180655_c(world, pos, this.getBaseBlockState(id), rand);
            }
        }
        finally {
            world.func_180501_a(pos, state, 0);
        }
    }

    public boolean isValid(IBlockState id) {
        return this.isValid(this.func_176201_c(id));
    }

    public boolean isValid(int id) {
        if (!this.init) {
            this.init();
        }
        if (id < 0 || id >= maxMetdata) {
            return false;
        }
        return this.valid[id];
    }

    public void setEntry(int id, DenseOre ore) {
        this.entry[id] = ore;
    }

    public DenseOre getEntry(int id) {
        return this.entry[id];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < maxMetdata; ++i) {
            if (!this.isValid(i)) continue;
            list.add(new ItemStack(item, 1, i));
        }
    }

    public Block getNullOverride(IBlockAccess world, BlockPos pos) {
        if (world == null) {
            return Blocks.field_150348_b;
        }
        BiomeGenBase biome = world.func_180494_b(pos);
        if (biome == BiomeGenBase.field_76778_j) {
            return Blocks.field_150424_aL;
        }
        if (biome == BiomeGenBase.field_76779_k) {
            return Blocks.field_150377_bs;
        }
        return this.getNullOverride(world);
    }

    public Block getNullOverride(IBlockAccess blockAccess) {
        if (!(blockAccess instanceof World)) {
            return Blocks.field_150348_b;
        }
        World world = (World)blockAccess;
        if (world.field_73011_w == null) {
            return Blocks.field_150348_b;
        }
        if (world.field_73011_w.func_177502_q() == -1) {
            return Blocks.field_150424_aL;
        }
        if (world.field_73011_w.func_177502_q() == 1) {
            return Blocks.field_150377_bs;
        }
        return Blocks.field_150348_b;
    }

    public void registerBlockIcons(TextureMap register) {
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
        IBlockState base;
        if (worldIn.field_72995_K || worldIn.restoringBlockSnapshots) {
            return;
        }
        List<ItemStack> items = this.getDrops((IBlockAccess)worldIn, pos, state, fortune);
        chance = ForgeEventFactory.fireBlockHarvesting(items, (World)worldIn, (BlockPos)pos, (IBlockState)state, (int)fortune, (float)chance, (boolean)false, (EntityPlayer)((EntityPlayer)this.harvesters.get()));
        if (chance == 0.0f) {
            return;
        }
        if (this.isValid(state) && (base = this.getBaseBlockState(this.func_176201_c(state))) != null) {
            chance = ForgeEventFactory.fireBlockHarvesting(items, (World)worldIn, (BlockPos)pos, (IBlockState)base, (int)fortune, (float)chance, (boolean)false, (EntityPlayer)((EntityPlayer)this.harvesters.get()));
        }
        if (chance == 0.0f) {
            return;
        }
        for (ItemStack item : items) {
            if (!(worldIn.field_73012_v.nextFloat() <= chance)) continue;
            BlockDenseOre.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)item);
        }
    }

    public Block getBlock(IBlockState state) {
        return this.getBlock(this.func_176201_c(state));
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        int meta = this.func_176201_c(state);
        if (this.isValid(meta)) {
            Block base = this.getBlock(meta);
            if (base == null) {
                return ret;
            }
            IBlockState m = this.getBaseBlockState(meta);
            for (int j = 0; j < 3; ++j) {
                ret.addAll(base.getDrops(world, pos, m, fortune));
            }
        } else {
            Block block = this.getNullOverride(world, pos);
            return block.getDrops(world, pos, block.func_176223_P(), fortune);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float func_176195_g(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != this) {
            return 1.0f;
        }
        int id = this.func_176201_c(state);
        if (!this.isValid(id)) {
            return 1.0f;
        }
        try {
            world.func_180501_a(pos, this.getBaseBlockState(id), 0);
            float f = this.getBlock(id).func_176195_g(world, pos);
            return f;
        }
        finally {
            world.func_180501_a(pos, state, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getExpDrop(IBlockAccess iBlockAccess, BlockPos pos, int fortune) {
        if (!(iBlockAccess instanceof World)) {
            return super.getExpDrop(iBlockAccess, pos, fortune);
        }
        World world = (World)iBlockAccess;
        IBlockState state = world.func_180495_p(pos);
        int id = this.func_176201_c(state);
        if (!this.isValid(id)) {
            return super.getExpDrop(iBlockAccess, pos, fortune);
        }
        try {
            world.func_180501_a(pos, this.getBaseBlockState(id), 0);
            int n = this.getBlock(id).getExpDrop((IBlockAccess)world, pos, fortune) * 3;
            return n;
        }
        finally {
            world.func_180501_a(pos, state, 0);
        }
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }
}

