/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.denseores.ModelBuilder;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.util.EnumFacing;

public class ModelBuilder {
    public static SimpleBakedModel newBlankModel(TextureAtlasSprite texture) {
        return new SimpleBakedModel(new LinkedList(), ModelBuilder.newBlankFacingLists(), true, true, texture, ItemCameraTransforms.field_178357_a);
    }

    public static BakedQuad copyQuad(BakedQuad quad) {
        return new BakedQuad(Arrays.copyOf(quad.func_178209_a(), quad.func_178209_a().length), quad.func_178211_c(), quad.func_178210_d());
    }

    public static BakedQuad changeTexture(BakedQuad quad, TextureAtlasSprite tex) {
        quad = ModelBuilder.copyQuad(quad);
        for (int i = 0; i < 4; ++i) {
            int j = 7 * i;
            float x = Float.intBitsToFloat(quad.func_178209_a()[j]);
            float y = Float.intBitsToFloat(quad.func_178209_a()[j + 1]);
            float z = Float.intBitsToFloat(quad.func_178209_a()[j + 2]);
            float u = 0.0f;
            float v = 0.0f;
            if (x < 0.0f || x > 1.0f) {
                x = (x + 1.0f) % 1.0f;
            }
            if (y < 0.0f || y > 1.0f) {
                y = (y + 1.0f) % 1.0f;
            }
            if (z < 0.0f || z > 1.0f) {
                z = (z + 1.0f) % 1.0f;
            }
            switch (quad.func_178210_d().ordinal()) {
                case 0: {
                    u = x * 16.0f;
                    v = (1.0f - z) * 16.0f;
                    break;
                }
                case 1: {
                    u = x * 16.0f;
                    v = z * 16.0f;
                    break;
                }
                case 2: {
                    u = (1.0f - x) * 16.0f;
                    v = (1.0f - y) * 16.0f;
                    break;
                }
                case 3: {
                    u = x * 16.0f;
                    v = (1.0f - y) * 16.0f;
                    break;
                }
                case 4: {
                    u = z * 16.0f;
                    v = (1.0f - y) * 16.0f;
                    break;
                }
                case 5: {
                    u = (1.0f - z) * 16.0f;
                    v = (1.0f - y) * 16.0f;
                }
            }
            quad.func_178209_a()[j + 4] = Float.floatToRawIntBits(tex.func_94214_a((double)u));
            quad.func_178209_a()[j + 4 + 1] = Float.floatToRawIntBits(tex.func_94207_b((double)v));
        }
        return quad;
    }

    public static SimpleBakedModel changePrimaryIcon(IBakedModel model, TextureAtlasSprite texture) {
        SimpleBakedModel bakedModel = new SimpleBakedModel(new LinkedList(), ModelBuilder.newBlankFacingLists(), model.func_177556_c(), model.func_177555_b(), texture, model.func_177552_f());
        for (Object o : model.func_177550_a()) {
            bakedModel.func_177550_a().add(ModelBuilder.changeTexture((BakedQuad)o, texture));
        }
        for (EnumFacing facing : EnumFacing.values()) {
            for (Object o : model.func_177551_a(facing)) {
                bakedModel.func_177551_a(facing).add(ModelBuilder.changeTexture((BakedQuad)o, texture));
            }
        }
        return bakedModel;
    }

    public static List newBlankFacingLists() {
        ArrayList objects = Lists.newArrayListWithCapacity((int)6);
        for (int j = 0; j < EnumFacing.values().length; ++j) {
            objects.add(Lists.newLinkedList());
        }
        return objects;
    }

    public static SimpleBakedModel join(IBakedModel ... models) {
        if (models.length == 0) {
            throw new IllegalArgumentException("Number of models must be > 0");
        }
        IBakedModel m = models[0];
        SimpleBakedModel simpleBakedModel = new SimpleBakedModel(new LinkedList(), ModelBuilder.newBlankFacingLists(), m.func_177556_c(), m.func_177555_b(), m.func_177554_e(), m.func_177552_f());
        for (IBakedModel model : models) {
            simpleBakedModel.func_177550_a().addAll(model.func_177550_a());
            for (EnumFacing enumFacing : EnumFacing.values()) {
                simpleBakedModel.func_177551_a(enumFacing).addAll(model.func_177551_a(enumFacing));
            }
        }
        return simpleBakedModel;
    }
}

