/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.denseores;

import com.rwtema.denseores.DenseOre;
import com.rwtema.denseores.DenseOresRegistry;
import com.rwtema.denseores.blockstates.OreType;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Loader;

public class DenseOresConfig {
    public static final DenseOresConfig instance = new DenseOresConfig();
    public static final String CATEGORY_BLOCK = "ores.block_";

    public void loadConfig(File file) {
        Configuration config = new Configuration(file);
        config.load();
        DenseOresRegistry.initVanillaOres();
        for (DenseOre ore : DenseOresRegistry.ores.values()) {
            String cat = CATEGORY_BLOCK + ore.name;
            config.get(cat, "baseBlock", ore.baseBlock);
            config.get(cat, "baseBlockMeta", ore.metadata);
            config.get(cat, "baseBlockTexture", ore.texture);
            config.get(cat, "underlyingBlockTexture", ore.underlyingBlockTexture);
            config.get(cat, "retroGenId", 0);
            if (ore.rendertype == 0) continue;
            config.get(cat, "renderType", ore.rendertype);
        }
        for (String cat : config.getCategoryNames()) {
            if (!cat.startsWith(CATEGORY_BLOCK)) continue;
            String name = cat.substring(CATEGORY_BLOCK.length());
            if (config.hasKey(cat, "requiredMod") && !config.get(cat, "requiredMod", "").getString().equals("") && !Loader.isModLoaded((String)config.get(cat, "requiredMod", "").getString())) {
                return;
            }
            if (DenseOresRegistry.hasEntry(name) || !config.hasKey(cat, "baseBlock") || !config.hasKey(cat, "baseBlockTexture")) continue;
            DenseOresRegistry.registerOre(name, config.get(cat, "baseBlock", "").getString().trim(), config.get(cat, "baseBlockMeta", 0).getInt(0), config.get(cat, "underlyingBlockTexture", "blocks/stone").getString().trim(), config.get(cat, "baseBlockTexture", "").getString().trim(), config.get(cat, "retroGenID", 0).getInt(), config.hasKey(cat, "renderType") ? config.get(cat, "renderType", 0).getInt(0) : 0);
        }
        for (OreType type : OreType.values()) {
            String name = type.func_176610_l();
            type.enabled = config.get("General", "enable" + name, true).getBoolean();
            type.generate = config.get("General", "generate" + name, true).getBoolean() && type.enabled;
        }
        config.save();
    }
}

