/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.denseores;

import com.rwtema.denseores.DenseOresConfig;
import com.rwtema.denseores.DenseOresRegistry;
import com.rwtema.denseores.Proxy;
import com.rwtema.denseores.WorldGenOres;
import com.rwtema.denseores.blocks.TileDepositLevel;
import com.rwtema.denseores.client.DenseModelGenerator;
import com.rwtema.denseores.commands.CommandFindDeposits;
import com.rwtema.denseores.debug.WorldGenAnalyser;
import com.rwtema.denseores.utils.LogHelper;
import java.io.File;
import net.minecraft.command.ICommand;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;

@Mod(modid="denseores", version="1.0", dependencies="after:*", acceptedMinecraftVersions="[1.8.9]")
public class DenseOresMod {
    public static final String MODID = "denseores";
    public static final String VERSION = "1.0";
    @SidedProxy(serverSide="com.rwtema.denseores.Proxy", clientSide="com.rwtema.denseores.ProxyClient")
    public static Proxy proxy;
    private File config;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.config = event.getSuggestedConfigurationFile();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        LogHelper.info("Ph'nglui mglw'nafh, y'uln Dense Ores shugg ch'agl", new Object[0]);
        DenseOresConfig.instance.loadConfig(this.config);
        DenseOresRegistry.buildBlocks();
        DenseModelGenerator.register();
        GameRegistry.registerTileEntity(TileDepositLevel.class, (String)"DenseOreDeposit");
        DenseOresRegistry.buildOreDictionary();
        WorldGenOres worldGen = new WorldGenOres();
        GameRegistry.registerWorldGenerator((IWorldGenerator)worldGen, (int)1000);
        MinecraftForge.EVENT_BUS.register((Object)worldGen);
        if (LogHelper.isDeObf) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)WorldGenAnalyser.INSTANCE, (int)1000000);
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit();
        LogHelper.info("Dense Ores is fully loaded but sadly it cannot tell you the unlocalized name for dirt.", new Object[0]);
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        if (LogHelper.isDeObf) {
            WorldGenAnalyser.INSTANCE.reset();
            event.registerServerCommand((ICommand)WorldGenAnalyser.INSTANCE);
        }
        event.registerServerCommand((ICommand)new CommandFindDeposits());
    }
}

