/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.denseores.blocks;

import com.google.common.base.Throwables;
import com.rwtema.denseores.DenseOre;
import com.rwtema.denseores.DenseOresMod;
import com.rwtema.denseores.blockaccess.BlockAccessSingleOverride;
import com.rwtema.denseores.blockstates.DenseOreBlockStateCreator;
import com.rwtema.denseores.blockstates.OreType;
import com.rwtema.denseores.utils.LogHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockOre;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockDenseOre
extends BlockOre {
    public static final PropertyEnum<OreType> ORE_TYPE = PropertyEnum.func_177709_a((String)"Ore Type", OreType.class);
    public boolean init = false;
    DenseOre denseOre;
    IBlockState baseBlockState;
    private boolean isValid;
    private Block baseBlock;

    public BlockDenseOre(DenseOre denseOre) {
        this.denseOre = denseOre;
        this.func_149647_a(CreativeTabs.field_78030_b);
    }

    public static Block getBlock(String name) {
        return (Block)GameData.getBlockRegistry().getObject(new ResourceLocation(name));
    }

    public static Block getBlock(DenseOre ore) {
        return ore != null ? BlockDenseOre.getBlock(ore.baseBlock) : null;
    }

    public Block getUnderlyingBlock(IBlockAccess world, BlockPos pos) {
        if ("blocks/stone".equals(this.denseOre.underlyingBlockTexture)) {
            return Blocks.field_150348_b;
        }
        if ("blocks/netherrack".equals(this.denseOre.underlyingBlockTexture)) {
            return Blocks.field_150424_aL;
        }
        if ("blocks/end_stone".equals(this.denseOre.underlyingBlockTexture)) {
            return Blocks.field_150377_bs;
        }
        return BlockDenseOre.getNullOverride(world, pos);
    }

    public static Block getNullOverride(IBlockAccess world, BlockPos pos) {
        if (world == null) {
            return Blocks.field_150348_b;
        }
        BiomeGenBase biome = world.func_180494_b(pos);
        if (biome == BiomeGenBase.field_76778_j) {
            return Blocks.field_150424_aL;
        }
        if (biome == BiomeGenBase.field_76779_k) {
            return Blocks.field_150377_bs;
        }
        return BlockDenseOre.getNullOverride(world);
    }

    public static Block getNullOverride(IBlockAccess blockAccess) {
        if (!(blockAccess instanceof World)) {
            return Blocks.field_150348_b;
        }
        World world = (World)blockAccess;
        return BlockDenseOre.getBlock(world);
    }

    public static Block getBlock(World world) {
        if (world.field_73011_w == null) {
            return Blocks.field_150348_b;
        }
        if (world.field_73011_w.func_177502_q() == -1) {
            return Blocks.field_150424_aL;
        }
        if (world.field_73011_w.func_177502_q() == 1) {
            return Blocks.field_150377_bs;
        }
        return Blocks.field_150348_b;
    }

    public boolean isValid() {
        if (!this.init) {
            this.init();
        }
        return this.isValid;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(ORE_TYPE, (Comparable)((Object)OreType.get(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((OreType)((Object)state.func_177229_b(ORE_TYPE))).ordinal();
    }

    public void init() {
        this.init = true;
        this.baseBlock = this.denseOre.getBaseBlock();
        this.baseBlockState = this.baseBlock.func_176203_a(this.denseOre.metadata);
        this.isValid = this.baseBlock != null && this.baseBlock != Blocks.field_150350_a;
    }

    protected BlockState func_180661_e() {
        return new DenseOreBlockStateCreator((Block)this);
    }

    public Block getBlock() {
        if (!this.init) {
            this.init();
        }
        return this.baseBlock;
    }

    public IBlockState getBaseBlockState() {
        if (!this.init) {
            this.init();
        }
        return this.baseBlockState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!this.isValid()) {
            return;
        }
        try {
            world.func_180501_a(pos, this.getBaseBlockState(), 0);
            for (int i = 0; i < 1 + rand.nextInt(3); ++i) {
                this.getBlock().func_180655_c(world, pos, this.getBaseBlockState(), rand);
            }
        }
        finally {
            world.func_180501_a(pos, state, 0);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        if (this.isValid()) {
            for (int i = 0; i < OreType.values().length; ++i) {
                list.add(new ItemStack(item, 1, i));
            }
        }
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
        IBlockState base;
        if (worldIn.field_72995_K || worldIn.restoringBlockSnapshots) {
            return;
        }
        List<ItemStack> items = this.getDrops((IBlockAccess)worldIn, pos, state, fortune);
        chance = ForgeEventFactory.fireBlockHarvesting(items, (World)worldIn, (BlockPos)pos, (IBlockState)state, (int)fortune, (float)chance, (boolean)false, (EntityPlayer)((EntityPlayer)this.harvesters.get()));
        if (chance == 0.0f) {
            return;
        }
        if (this.isValid() && (base = this.getBaseBlockState()) != null) {
            chance = ForgeEventFactory.fireBlockHarvesting(items, (World)worldIn, (BlockPos)pos, (IBlockState)base, (int)fortune, (float)chance, (boolean)false, (EntityPlayer)((EntityPlayer)this.harvesters.get()));
        }
        if (chance == 0.0f) {
            return;
        }
        for (ItemStack item : items) {
            if (!(worldIn.field_73012_v.nextFloat() <= chance)) continue;
            BlockDenseOre.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)item);
        }
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        Block base;
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        OreType oreType = (OreType)((Object)state.func_177229_b(ORE_TYPE));
        if (this.isValid()) {
            base = this.getBlock();
            if (base == null) {
                return list;
            }
        } else {
            Block block = BlockDenseOre.getNullOverride(world, pos);
            BlockAccessSingleOverride delegate = new BlockAccessSingleOverride(world, block.func_176223_P(), pos);
            return block.getDrops((IBlockAccess)delegate, pos, block.func_176223_P(), fortune);
        }
        IBlockState m = this.getBaseBlockState();
        BlockAccessSingleOverride delegate = new BlockAccessSingleOverride(world, m, pos);
        Random rand = world instanceof World ? ((World)world).field_73012_v : RANDOM;
        oreType.addDrops(list, this.denseOre, world, pos, base, m, delegate, fortune, rand);
        return list;
    }

    public float func_176195_g(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != this) {
            return 1.0f;
        }
        if (!this.isValid()) {
            return 1.0f;
        }
        OreType type = (OreType)((Object)state.func_177229_b(ORE_TYPE));
        TileEntity tile = world.func_175625_s(pos);
        try {
            world.func_180501_a(pos, this.getBaseBlockState(), 0);
            float blockHardness = this.getBlock().func_176195_g(world, pos);
            world.func_180501_a(pos, state, 0);
            if (tile != null) {
                NBTTagCompound tag = new NBTTagCompound();
                tile.func_145841_b(tag);
                TileEntity newTile = world.func_175625_s(pos);
                newTile.func_145839_a(tag);
            }
            return type.transfromHardness(this.denseOre, type, world, pos, tile, blockHardness);
        }
        catch (Throwable throwable) {
            world.func_180501_a(pos, state, 0);
            if (tile != null) {
                NBTTagCompound tag = new NBTTagCompound();
                tile.func_145841_b(tag);
                TileEntity newTile = world.func_175625_s(pos);
                newTile.func_145839_a(tag);
            }
            throw Throwables.propagate((Throwable)throwable);
        }
    }

    public int getExpDrop(IBlockAccess iBlockAccess, BlockPos pos, int fortune) {
        if (!(iBlockAccess instanceof World) || !this.isValid()) {
            return 0;
        }
        World world = (World)iBlockAccess;
        IBlockState state = world.func_180495_p(pos);
        OreType oreType = (OreType)((Object)state.func_177229_b(ORE_TYPE));
        IBlockState baseState = this.getBaseBlockState();
        BlockAccessSingleOverride delegate = new BlockAccessSingleOverride(iBlockAccess, baseState, pos);
        return oreType.getExpDrops(this.denseOre, world, pos, fortune, baseState, delegate);
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return state.func_177230_c() == this && this.isValid() && ((OreType)((Object)state.func_177229_b(ORE_TYPE))).canSilkHarvest(world, pos, player);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        DenseOresMod.proxy.loadModel(this, state, worldIn, pos);
        return state;
    }

    public int func_176222_j(World worldIn, BlockPos pos) {
        return this.func_180651_a(worldIn.func_180495_p(pos));
    }

    public boolean hasTileEntity(IBlockState state) {
        return ((OreType)((Object)state.func_177229_b(ORE_TYPE))).hasTile();
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        if (world.field_72995_K) {
            return null;
        }
        return ((OreType)((Object)state.func_177229_b(ORE_TYPE))).createTile(world);
    }

    public boolean removedByPlayer(World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        IBlockState blockState = world.func_180495_p(pos);
        if (blockState.func_177230_c() != this) {
            LogHelper.warn("Invalid IBlockState found (" + blockState + ") at " + pos);
            return super.removedByPlayer(world, pos, player, willHarvest);
        }
        return ((OreType)((Object)blockState.func_177229_b(ORE_TYPE))).removedByPlayer(world, pos, this, player, willHarvest);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumFacing side, float hitX, float hitY, float hitZ) {
        return ((OreType)((Object)state.func_177229_b(ORE_TYPE))).onBlockActivated(this.denseOre, worldIn, pos, state, playerIn, side, hitX, hitY, hitZ);
    }

    public int getHarvestLevel(IBlockState state) {
        IBlockState baseState = this.getBaseBlockState();
        int harvestLevel = baseState.func_177230_c().getHarvestLevel(baseState);
        return ((OreType)((Object)state.func_177229_b(ORE_TYPE))).transformHarvestLevel(harvestLevel, this, baseState);
    }

    public String getHarvestTool(IBlockState state) {
        IBlockState baseState = this.getBaseBlockState();
        return baseState.func_177230_c().getHarvestTool(baseState);
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te) {
        player.func_71029_a(StatList.field_75934_C[BlockDenseOre.func_149682_b((Block)this)]);
        player.func_71020_j(0.025f);
        if (this.canSilkHarvest(worldIn, pos, state, player) && EnchantmentHelper.func_77502_d((EntityLivingBase)player)) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            ItemStack itemstack = this.func_180643_i(state);
            if (itemstack != null) {
                items.add(itemstack);
            }
            ForgeEventFactory.fireBlockHarvesting(items, (World)worldIn, (BlockPos)pos, (IBlockState)worldIn.func_180495_p(pos), (int)0, (float)1.0f, (boolean)true, (EntityPlayer)player);
            for (ItemStack stack : items) {
                BlockDenseOre.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)stack);
            }
        } else {
            this.harvesters.set(player);
            int i = EnchantmentHelper.func_77517_e((EntityLivingBase)player);
            this.func_176226_b(worldIn, pos, state, i);
            this.harvesters.set(null);
        }
    }
}

