/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.denseores.blockstates;

import com.google.common.collect.Maps;
import com.rwtema.denseores.DenseOre;
import com.rwtema.denseores.WorldGenOres;
import com.rwtema.denseores.blockaccess.BlockAccessSingleOverride;
import com.rwtema.denseores.blocks.BlockDenseOre;
import com.rwtema.denseores.blocks.TileDepositLevel;
import com.rwtema.denseores.utils.ColorHelper;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public enum OreType implements IStringSerializable
{
    DENSE{

        @Override
        public void addDrops(ArrayList<ItemStack> list, DenseOre denseOre, IBlockAccess world, BlockPos pos, Block base, IBlockState blockState, BlockAccessSingleOverride delegate, int fortune, Random rand) {
            for (int j = 0; j < 3; ++j) {
                list.addAll(base.getDrops((IBlockAccess)delegate, pos, blockState, fortune));
            }
        }

        @Override
        public int getExpDrops(DenseOre denseOre, World world, BlockPos pos, int fortune, IBlockState baseState, BlockAccessSingleOverride delegate) {
            return this.getBaseExp(pos, fortune, baseState, delegate) * 3;
        }

        @Override
        public void registerOre(DenseOre ore, String oreName) {
            OreDictionary.registerOre((String)("dense" + oreName), (ItemStack)new ItemStack((Block)ore.block, 1, this.ordinal()));
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void assignOreTexData(int w, int[] ore_data, int[] stone_data, int renderType, int[] new_data, boolean[] same) {
            Offset offset = Offset.getOffset(renderType);
            int[] dx = offset.dx;
            int[] dy = offset.dy;
            block0: for (int i = 0; i < ore_data.length; ++i) {
                int x = i % w;
                int y = (i - x) / w;
                if (!same[i]) continue;
                for (int j = 0; j < dx.length; ++j) {
                    int new_x = x + dx[j];
                    int new_y = y + dy[j];
                    if (new_x < 0 || new_x >= w || new_y < 0 || new_y >= w || same[new_x + new_y * w]) continue;
                    new_data[i] = ore_data[new_x + new_y * w];
                    continue block0;
                }
            }
        }

        @Override
        public void generate(Chunk chunk, Random random, DenseOre denseOre, boolean retroGen) {
            IBlockState replaceState = denseOre.block.func_176223_P().func_177226_a(BlockDenseOre.ORE_TYPE, (Comparable)((Object)this));
            for (int i = 0; i < 1000; ++i) {
                int z;
                int y;
                int x = chunk.field_76635_g << 4 | random.nextInt(16);
                BlockPos pos = new BlockPos(x, y = 1 + random.nextInt(80), z = chunk.field_76647_h << 4 | random.nextInt(16));
                IBlockState state = chunk.func_177435_g(pos);
                if (state != denseOre.getBaseState()) continue;
                WorldGenOres.overrideChunkBlock(chunk, pos, replaceState, retroGen);
            }
        }
    }
    ,
    SPARSE{
        HashMap<DenseOre, List<ItemStack>> nuggets = Maps.newHashMap();

        @Override
        public void assignOreTexData(int w, int[] ore_data, int[] stone_data, int renderType, int[] new_data, boolean[] same) {
            Random rnd = new Random(0L);
            boolean[] backBlock = new boolean[ore_data.length];
            int r = (int)Math.ceil((float)w / 16.0f);
            TIntHashSet borderValues = new TIntHashSet();
            for (int i = 0; i < ore_data.length; ++i) {
                if (!same[i]) continue;
                backBlock[i] = true;
                int x = i % w;
                int y = (i - x) / w;
                for (int dx = -r; dx <= r; ++dx) {
                    for (int dy = -r; dy <= r; ++dy) {
                        int j;
                        int x2 = x + dx;
                        int y2 = y + dy;
                        if (x2 < 0 || x2 >= w || y2 < 0 || y2 >= w || same[j = y2 * w + x2]) continue;
                        borderValues.add(j);
                    }
                }
            }
            int[] border = borderValues.toArray();
            for (int i = border.length - 1; i > 0; --i) {
                int index = rnd.nextInt(i + 1);
                int a = border[index];
                border[index] = border[i];
                border[i] = a;
            }
            int[] dx = new int[]{-1, 1};
            int[] dy = new int[]{1, 0};
            for (int i : border) {
                int x = i % w;
                int y = (i - x) / w;
                boolean alone = true;
                for (int j = 0; j < dx.length; ++j) {
                    int k;
                    int x2 = x + dx[j];
                    int y2 = y + dy[j];
                    if (x2 < 0 || x2 >= w || y2 < 0 || y2 >= w || backBlock[k = y2 * w + x2]) continue;
                    alone = false;
                }
                if (alone) continue;
                backBlock[i] = true;
            }
            for (int i = 0; i < ore_data.length; ++i) {
                new_data[i] = backBlock[i] ? stone_data[i] : ore_data[i];
            }
        }

        @Override
        public void addDrops(ArrayList<ItemStack> list, DenseOre denseOre, IBlockAccess world, BlockPos pos, Block base, IBlockState blockState, BlockAccessSingleOverride delegate, int fortune, Random rand) {
            List<ItemStack> nuggets;
            List drops = base.getDrops((IBlockAccess)delegate, pos, blockState, fortune);
            if (!drops.isEmpty()) {
                for (ItemStack drop : drops) {
                    int i;
                    if (drop == null || drop.field_77994_a == 0 || (i = rand.nextInt(1 + drop.field_77994_a)) == 0 || (i = rand.nextInt(1 + i)) == 0) continue;
                    drop = drop.func_77946_l();
                    drop.field_77994_a = i;
                    list.add(drop);
                }
            }
            if (!(nuggets = this.nuggets.get(denseOre)).isEmpty()) {
                ItemStack itemStack = nuggets.get(0);
                list.add(itemStack.func_77946_l());
            }
            if (list.isEmpty()) {
                Block block = denseOre.block.getUnderlyingBlock(world, pos);
                IBlockState state = block.func_176223_P();
                list.addAll(block.getDrops((IBlockAccess)new BlockAccessSingleOverride(world, state, pos), pos, state, fortune));
            }
        }

        @Override
        public void registerOre(DenseOre ore, String oreName) {
            String s = "nugget" + oreName.substring(3);
            this.nuggets.put(ore, OreDictionary.getOres((String)s));
        }

        @Override
        public int getExpDrops(DenseOre denseOre, World world, BlockPos pos, int fortune, IBlockState baseState, BlockAccessSingleOverride delegate) {
            return this.getBaseExp(pos, fortune, baseState, delegate) >> 2;
        }

        @Override
        public float transfromHardness(DenseOre denseOre, OreType type, World world, BlockPos pos, TileEntity tile, float blockHardness) {
            return Math.max(1.0f, blockHardness / 2.0f);
        }

        @Override
        public void generate(Chunk chunk, Random random, DenseOre denseOre, boolean retroGen) {
            IBlockState replaceState = denseOre.block.func_176223_P().func_177226_a(BlockDenseOre.ORE_TYPE, (Comparable)((Object)this));
            for (int i = 0; i < 15; ++i) {
                int z;
                int y;
                int x = chunk.field_76635_g << 4 | 3 + random.nextInt(13);
                BlockPos pos = new BlockPos(x, y = 4 + random.nextInt(80), z = chunk.field_76647_h << 4 | 3 + random.nextInt(13));
                IBlockState state = chunk.func_177435_g(pos);
                if (state != denseOre.getBaseState()) continue;
                for (BlockPos.MutableBlockPos offsetPos : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-3, -3, -3), (BlockPos)pos.func_177982_a(3, 3, 3))) {
                    Block block;
                    if (random.nextInt(2) == 0 || (block = chunk.func_177428_a((BlockPos)offsetPos)) != denseOre.block.getUnderlyingBlock((IBlockAccess)chunk.func_177412_p(), pos)) continue;
                    WorldGenOres.overrideChunkBlock(chunk, (BlockPos)offsetPos, replaceState, retroGen);
                }
            }
        }
    }
    ,
    DEPOSIT{

        @Override
        public float transfromHardness(DenseOre denseOre, OreType type, World world, BlockPos pos, TileEntity tile, float blockHardness) {
            if (tile instanceof TileDepositLevel) {
                return blockHardness * MathHelper.func_76129_c((float)((TileDepositLevel)tile).num);
            }
            return blockHardness * 8.0f;
        }

        @Override
        public void assignOreTexData(int w, int[] ore_data, int[] stone_data, int renderType, int[] new_data, boolean[] same) {
            int x;
            int i;
            Offset offset = Offset.getOffset(renderType);
            int[] tx = offset.dx;
            int[] ty = offset.dy;
            Random rand = new Random();
            int r = w >> 3;
            TIntArrayList diffColors = new TIntArrayList();
            block0: for (i = 0; i < ore_data.length; ++i) {
                if (same[i]) continue;
                x = i % w;
                for (int dx = -r; dx <= r; ++dx) {
                    if (x + dx <= 0 || x + dx > w) continue;
                    for (int dy = -(r * w); dy <= r * w; dy += w) {
                        int k = i + dx + dy;
                        if (k < 0 || k >= stone_data.length || !ColorHelper.areColorsClose(ore_data[i], stone_data[k])) continue;
                        same[i] = true;
                        continue block0;
                    }
                }
                diffColors.add(ore_data[i]);
            }
            if (diffColors.isEmpty()) {
                return;
            }
            block3: for (i = 0; i < ore_data.length; ++i) {
                if (!same[i]) continue;
                x = i % w;
                int y = (i - x) / w;
                for (int j = 0; j < tx.length; ++j) {
                    int k;
                    int x2 = x + tx[j];
                    int y2 = y + ty[j];
                    if (x2 < 0 || x2 >= w || y2 < 0 || y2 >= w || same[k = x2 + y2 * w]) continue;
                    new_data[i] = ColorHelper.multiply(ore_data[k], 0.975f);
                    continue block3;
                }
                Random rnd = new Random(0L);
                for (int r2 = 1; r2 < w; ++r2) {
                    for (int j = 0; j < r2; ++j) {
                        int k;
                        int x2 = x + rnd.nextInt(r2 * 2 + 1) - r2;
                        int y2 = y + rnd.nextInt(r2 * 2 + 1) - r2;
                        if (x2 < 0 || x2 >= w || y2 < 0 || y2 >= w || same[k = y2 * w + x2]) continue;
                        new_data[i] = ColorHelper.multiply(ore_data[k], 0.95f);
                        continue block3;
                    }
                }
                for (int j = 0; j < same.length; ++j) {
                    int k = (i + j) % ore_data.length;
                    if (same[k]) continue;
                    new_data[i] = ColorHelper.multiply(ore_data[k], 0.95f);
                    continue block3;
                }
            }
        }

        @Override
        public void addDrops(ArrayList<ItemStack> list, DenseOre denseOre, IBlockAccess world, BlockPos pos, Block base, IBlockState blockState, BlockAccessSingleOverride delegate, int fortune, Random rand) {
            list.addAll(base.getDrops((IBlockAccess)delegate, pos, blockState, fortune));
        }

        @Override
        public int getExpDrops(DenseOre denseOre, World world, BlockPos pos, int fortune, IBlockState baseState, BlockAccessSingleOverride delegate) {
            return this.getBaseExp(pos, fortune, baseState, delegate);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void generate(Chunk chunk, Random random, DenseOre denseOre, boolean retroGen) {
            if (random.nextInt(32) != 0) {
                return;
            }
            for (int dv = 0; dv < 1; ++dv) {
                int z;
                int y;
                IBlockState oreState = denseOre.getBaseState();
                int x = chunk.field_76635_g << 4 | random.nextInt(16);
                BlockPos pos = new BlockPos(x, y = 1 + random.nextInt(256), z = chunk.field_76647_h << 4 | random.nextInt(16));
                IBlockState state = chunk.func_177435_g(pos);
                if (state != oreState) continue;
                IBlockState depositState = denseOre.block.func_176223_P().func_177226_a(BlockDenseOre.ORE_TYPE, (Comparable)((Object)this));
                IBlockState rawState = BlockDenseOre.getNullOverride((IBlockAccess)chunk.func_177412_p()).func_176223_P();
                Block rawBlock = rawState.func_177230_c();
                IBlockState denseState = denseOre.block.func_176223_P().func_177226_a(BlockDenseOre.ORE_TYPE, (Comparable)((Object)DENSE));
                for (int v = 0; v < 10; ++v) {
                    x = chunk.field_76635_g << 4 | 4 + random.nextInt(8);
                    z = chunk.field_76647_h << 4 | 4 + random.nextInt(8);
                    for (int j = 1; j < 20; ++j) {
                        BlockPos t;
                        y = chunk.func_177412_p().field_73011_w.func_177495_o() ? random.nextInt(256) : chunk.func_76611_b(x & 0xF, z & 0xF) - j;
                        Block block = chunk.func_177438_a(x, y, z);
                        if (block != Blocks.field_150349_c && block != Blocks.field_150348_b && block != Blocks.field_150346_d && block != rawBlock) continue;
                        TObjectIntHashMap vals = new TObjectIntHashMap(10, 0.5f, 0);
                        BlockPos p = new BlockPos(x, y, z);
                        WorldGenOres.overrideChunkBlock(chunk, p, depositState, retroGen);
                        vals.put((Object)p, 4 + random.nextInt(5));
                        LinkedList<BlockPos> toProcess = new LinkedList<BlockPos>();
                        LinkedList linkedList = deposit_positions;
                        synchronized (linkedList) {
                            if (deposit_positions.size() > 10) {
                                deposit_positions.removeFirst();
                            }
                            deposit_positions.addLast(p);
                        }
                        toProcess.add(p);
                        while ((t = (BlockPos)toProcess.poll()) != null) {
                            int i = vals.get((Object)t);
                            for (EnumFacing facing : EnumFacing.values()) {
                                int i2 = vals.get((Object)t.func_177972_a(facing)) - 1;
                                if (i2 <= i) continue;
                                i = i2;
                            }
                            for (EnumFacing facing : EnumFacing.values()) {
                                BlockPos offset = t.func_177972_a(facing);
                                if (vals.containsKey((Object)offset)) continue;
                                Block b = chunk.func_177428_a(offset);
                                if (b != Blocks.field_150349_c && b != Blocks.field_150348_b && b != Blocks.field_150346_d && b != Blocks.field_150351_n && b != Blocks.field_150350_a && b != rawBlock) {
                                    vals.put((Object)offset, 0);
                                    continue;
                                }
                                int dx = offset.func_177958_n() & 0xF;
                                if (dx == 0 || dx == 15) {
                                    vals.put((Object)offset, 0);
                                    if (b == Blocks.field_150350_a) continue;
                                    WorldGenOres.overrideChunkBlock(chunk, offset, rawState, retroGen);
                                    continue;
                                }
                                int dz = offset.func_177952_p() & 0xF;
                                if (dz == 0 || dz == 15) {
                                    vals.put((Object)offset, 0);
                                    if (b == Blocks.field_150350_a) continue;
                                    WorldGenOres.overrideChunkBlock(chunk, offset, rawState, retroGen);
                                    continue;
                                }
                                int i_temp = i;
                                i_temp -= 1 + random.nextInt(2);
                                if (facing.ordinal() <= 2) {
                                    i_temp -= random.nextInt(2);
                                }
                                if (i_temp < 0) {
                                    i_temp = 0;
                                }
                                vals.put((Object)offset, i_temp);
                                if (i_temp > 2) {
                                    toProcess.add(offset);
                                    WorldGenOres.overrideChunkBlock(chunk, offset, depositState, retroGen);
                                    continue;
                                }
                                if (b == Blocks.field_150350_a) continue;
                                if (i_temp == 2) {
                                    toProcess.add(offset);
                                    WorldGenOres.overrideChunkBlock(chunk, offset, denseState, retroGen);
                                    continue;
                                }
                                if (i_temp == 1) {
                                    toProcess.add(offset);
                                    WorldGenOres.overrideChunkBlock(chunk, offset, oreState, retroGen);
                                    continue;
                                }
                                WorldGenOres.overrideChunkBlock(chunk, offset, rawState, retroGen);
                            }
                        }
                        return;
                    }
                }
            }
        }

        @Override
        public boolean hasTile() {
            return true;
        }

        @Override
        public int transformHarvestLevel(int harvestLevel, BlockDenseOre blockDenseOre, IBlockState baseState) {
            return 1 + harvestLevel;
        }

        @Override
        public TileEntity createTile(World world) {
            if (world.field_72995_K) {
                return null;
            }
            return new TileDepositLevel();
        }

        @Override
        public boolean canSilkHarvest(World world, BlockPos pos, EntityPlayer player) {
            return false;
        }

        @Override
        public boolean removedByPlayer(World world, BlockPos pos, BlockDenseOre blockDenseOre, EntityPlayer player, boolean willHarvest) {
            if (player != null && player.field_71075_bZ.field_75098_d) {
                return super.removedByPlayer(world, pos, blockDenseOre, player, willHarvest);
            }
            if (world.field_72995_K) {
                return false;
            }
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof TileDepositLevel && ((TileDepositLevel)tileEntity).dec()) {
                if (willHarvest) {
                    blockDenseOre.func_180657_a(world, player, pos, world.func_180495_p(pos), tileEntity);
                }
                return false;
            }
            return super.removedByPlayer(world, pos, blockDenseOre, player, willHarvest);
        }

        @Override
        public boolean onBlockActivated(DenseOre denseOre, World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumFacing side, float hitX, float hitY, float hitZ) {
            if (worldIn.field_72995_K) {
                return true;
            }
            TileEntity tile = worldIn.func_175625_s(pos);
            if (tile instanceof TileDepositLevel) {
                playerIn.func_146105_b((IChatComponent)new ChatComponentTranslation("denseores.deposit.num", new Object[]{((TileDepositLevel)tile).num}));
            }
            return true;
        }
    };

    public final String name = this.name().toLowerCase();
    public boolean generate;
    public static final LinkedList<BlockPos> deposit_positions;
    public boolean enabled;

    public static OreType get(int meta) {
        for (OreType oreType : OreType.values()) {
            if (oreType.ordinal() != meta) continue;
            return oreType;
        }
        return DENSE;
    }

    public void registerOre(DenseOre ore, String oreName) {
    }

    @SideOnly(value=Side.CLIENT)
    public abstract void assignOreTexData(int var1, int[] var2, int[] var3, int var4, int[] var5, boolean[] var6);

    public String func_176610_l() {
        return this.name;
    }

    public abstract void addDrops(ArrayList<ItemStack> var1, DenseOre var2, IBlockAccess var3, BlockPos var4, Block var5, IBlockState var6, BlockAccessSingleOverride var7, int var8, Random var9);

    public abstract int getExpDrops(DenseOre var1, World var2, BlockPos var3, int var4, IBlockState var5, BlockAccessSingleOverride var6);

    protected int getBaseExp(BlockPos pos, int fortune, IBlockState baseState, BlockAccessSingleOverride delegate) {
        return baseState.func_177230_c().getExpDrop((IBlockAccess)delegate, pos, fortune);
    }

    public boolean canSilkHarvest(World world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    public abstract void generate(Chunk var1, Random var2, DenseOre var3, boolean var4);

    public boolean hasTile() {
        return false;
    }

    public TileEntity createTile(World world) {
        return null;
    }

    public boolean removedByPlayer(World world, BlockPos pos, BlockDenseOre blockDenseOre, EntityPlayer player, boolean willHarvest) {
        return world.func_175698_g(pos);
    }

    public boolean onBlockActivated(DenseOre denseOre, World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public float transfromHardness(DenseOre denseOre, OreType type, World world, BlockPos pos, TileEntity tile, float blockHardness) {
        return blockHardness;
    }

    public int transformHarvestLevel(int harvestLevel, BlockDenseOre blockDenseOre, IBlockState baseState) {
        return harvestLevel;
    }

    static {
        deposit_positions = new LinkedList();
    }

    private static class Offset {
        public int[] dx;
        public int[] dy;

        private Offset() {
        }

        public static Offset getOffset(int renderType) {
            Offset offset = new Offset();
            switch (renderType) {
                default: {
                    offset.dx = new int[]{-1, 2, 3};
                    offset.dy = new int[]{-1, 0, 1};
                    break;
                }
                case 1: {
                    offset.dx = new int[]{-1, 1, 0, 0, -1, -1, 1, 1, -2, 2, 0, 0};
                    offset.dy = new int[]{0, 0, -1, 1, -1, 1, -1, 1, 0, 0, -2, 2};
                    break;
                }
                case 2: {
                    offset.dx = new int[]{-1, 0, 1};
                    offset.dy = new int[]{-1, 0, 1};
                    break;
                }
                case 3: {
                    offset.dx = new int[]{-2, 2, 1, 1};
                    offset.dy = new int[]{1, 1, -2, 2};
                }
                case 4: {
                    offset.dx = new int[]{-6, -3, 3, 6};
                    offset.dy = new int[]{0, 0, 0, 0};
                    break;
                }
                case 5: {
                    offset.dx = new int[]{-5, -5, 5, 5};
                    offset.dy = new int[]{-5, 5, -5, 5};
                    break;
                }
                case 6: {
                    offset.dx = new int[]{0, 1, 2, 3};
                    offset.dy = new int[]{0, -3, 2, -1};
                    break;
                }
                case 7: {
                    offset.dx = new int[]{-1, 1, 0, 0};
                    offset.dy = new int[]{0, 0, -1, 1};
                }
            }
            return offset;
        }
    }
}

