/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.denseores.client;

import com.rwtema.denseores.DenseOre;
import com.rwtema.denseores.DenseOresRegistry;
import com.rwtema.denseores.blocks.BlockDenseOre;
import com.rwtema.denseores.blockstates.OreType;
import com.rwtema.denseores.client.DynamicBlockModel;
import com.rwtema.denseores.client.EmptyBakedModel;
import com.rwtema.denseores.client.TextureOre;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.block.statemap.DefaultStateMapper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IRegistry;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DenseModelGenerator {
    public static DenseModelGenerator INSTANCE = new DenseModelGenerator();

    public static void register() {
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void textureStitch(TextureStitchEvent.Pre event) {
        TextureMap textureMap = event.map;
        for (DenseOre entry : DenseOresRegistry.ores.values()) {
            entry.sprites = new EnumMap(OreType.class);
            for (OreType oreType : OreType.values()) {
                String name = TextureOre.getDerivedName(entry.texture, oreType);
                TextureAtlasSprite texture = textureMap.getTextureExtry(name);
                if (texture == null) {
                    texture = new TextureOre(entry, oreType);
                    textureMap.setTextureEntry(name, texture);
                }
                entry.sprites.put(oreType, textureMap.getTextureExtry(name));
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void bakeModels(ModelBakeEvent event) {
        IRegistry modelRegistry = event.modelRegistry;
        ItemModelMesher mesher = Minecraft.func_71410_x().func_175599_af().func_175037_a();
        for (DenseOre denseOre : DenseOresRegistry.ores.values()) {
            BlockDenseOre block = denseOre.block;
            Item item = Item.func_150898_a((Block)block);
            modelRegistry.func_82595_a((Object)new ModelResourceLocation((ResourceLocation)Item.field_150901_e.func_177774_c((Object)item), "inventory"), (Object)new EmptyBakedModel());
            Map locations = new DefaultStateMapper().func_178130_a((Block)block);
            final ModelResourceLocation[] invModels = new ModelResourceLocation[OreType.values().length];
            for (IBlockState iBlockState : block.func_176194_O().func_177619_a()) {
                OreType oreType = (OreType)((Object)iBlockState.func_177229_b(BlockDenseOre.ORE_TYPE));
                ModelResourceLocation blockLocation = (ModelResourceLocation)locations.get(iBlockState);
                ModelResourceLocation inventoryLocation = new ModelResourceLocation(Item.field_150901_e.func_177774_c((Object)item) + "_" + oreType.func_176610_l(), "inventory");
                DynamicBlockModel model = new DynamicBlockModel(denseOre, iBlockState, oreType);
                modelRegistry.func_82595_a((Object)blockLocation, (Object)model);
                modelRegistry.func_82595_a((Object)inventoryLocation, (Object)model);
                mesher.func_178086_a(item, oreType.ordinal(), inventoryLocation);
                invModels[oreType.ordinal()] = inventoryLocation;
            }
            mesher.func_178080_a(item, new ItemMeshDefinition(){

                public ModelResourceLocation func_178113_a(ItemStack stack) {
                    int itemDamage = stack.func_77952_i();
                    if (itemDamage < 0 || itemDamage >= OreType.values().length) {
                        itemDamage = 0;
                    }
                    return invModels[itemDamage];
                }
            });
        }
    }
}

