/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.denseores.commands;

import com.rwtema.denseores.blockaccess.SingleBlockWorldAccess;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class CommandClientIdentifyBlock
extends CommandBase {
    public String func_71517_b() {
        return "denseores_identifyblock";
    }

    public boolean func_71519_b(ICommandSender par1ICommandSender) {
        return true;
    }

    public String func_71518_a(ICommandSender var1) {
        return "denseores.commandIdentify.help";
    }

    public void func_71515_b(ICommandSender var1, String[] var2) {
        if (!(var1 instanceof EntityPlayer)) {
            return;
        }
        ItemStack item = ((EntityPlayer)var1).func_70694_bm();
        if (item == null || !(item.func_77973_b() instanceof ItemBlock) || ((ItemBlock)item.func_77973_b()).func_179223_d() == null) {
            ((EntityPlayer)var1).func_146105_b((IChatComponent)new ChatComponentTranslation("denseores.commandIdentify.invalid", new Object[0]));
            return;
        }
        var1.func_145747_a((IChatComponent)new ChatComponentTranslation("denseores.commandIdentify.start", new Object[]{item.toString()}));
        ItemBlock itemBlock = (ItemBlock)item.func_77973_b();
        Block b = itemBlock.func_179223_d();
        int metadata = itemBlock.func_77647_b(item.func_77952_i());
        IBlockState state = b.func_176203_a(metadata);
        var1.func_145747_a((IChatComponent)new ChatComponentTranslation("S:baseBlock=%s", new Object[]{GameData.getBlockRegistry().getNameForObject((Object)b)}));
        var1.func_145747_a((IChatComponent)new ChatComponentTranslation("I:baseBlockMeta=%s", new Object[]{b.func_176201_c(state)}));
        TextureMap map = Minecraft.func_71410_x().func_147117_R();
        Map textures = (Map)ObfuscationReflectionHelper.getPrivateValue(TextureMap.class, (Object)map, (int)6);
        SingleBlockWorldAccess world = new SingleBlockWorldAccess(state);
        IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_175022_a(state, (IBlockAccess)world, SingleBlockWorldAccess.CENTER_POS);
        HashSet<TextureAtlasSprite> sprites = new HashSet<TextureAtlasSprite>();
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        quads.addAll(model.func_177550_a());
        for (EnumFacing facing : EnumFacing.values()) {
            quads.addAll(model.func_177551_a(facing));
        }
        for (TextureAtlasSprite sprite : textures.values()) {
            if (!this.matches(quads, sprite)) continue;
            sprites.add(sprite);
        }
        for (TextureAtlasSprite sprite : sprites) {
            String iconName = sprite.func_94215_i();
            if (iconName.startsWith("minecraft:")) {
                iconName = iconName.substring("minecraft:".length());
            }
            var1.func_145747_a((IChatComponent)new ChatComponentTranslation("tex=%s", new Object[]{iconName}));
        }
    }

    public boolean matches(List<BakedQuad> quad, TextureAtlasSprite sprite) {
        for (BakedQuad bakedQuad : quad) {
            if (!this.matches(bakedQuad, sprite)) continue;
            return true;
        }
        return false;
    }

    public boolean matches(BakedQuad quad, TextureAtlasSprite sprite) {
        int[] vertexData = quad.func_178209_a();
        for (int i = 0; i < 28; i += 7) {
            float u = Float.intBitsToFloat(vertexData[i + 4]);
            float v = Float.intBitsToFloat(vertexData[i + 5]);
            if (!(u >= sprite.func_94209_e()) || !(u <= sprite.func_94212_f()) || !(v >= sprite.func_94206_g()) || !(v <= sprite.func_94210_h())) continue;
            return true;
        }
        return false;
    }
}

