/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.denseores.debug;

import com.rwtema.denseores.DenseOre;
import com.rwtema.denseores.DenseOresRegistry;
import com.rwtema.denseores.blocks.TileDepositLevel;
import gnu.trove.map.hash.TObjectLongHashMap;
import gnu.trove.procedure.TObjectLongProcedure;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenAnalyser
extends CommandBase
implements IWorldGenerator {
    public static final WorldGenAnalyser INSTANCE = new WorldGenAnalyser();
    final TObjectLongHashMap<IBlockState> states = new TObjectLongHashMap();
    long n;

    public void reset() {
        this.n = 0L;
        this.states.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        Chunk chunk = world.func_72964_e(chunkX, chunkZ);
        TObjectLongHashMap<IBlockState> tObjectLongHashMap = this.states;
        synchronized (tObjectLongHashMap) {
            ++this.n;
            for (BlockPos.MutableBlockPos pos : BlockPos.func_177975_b((BlockPos)this.getBlock(0, 0, 0, chunkX, chunkZ), (BlockPos)this.getBlock(15, 255, 15, chunkX, chunkZ))) {
                IBlockState state = chunk.func_177435_g((BlockPos)pos);
                this.states.adjustOrPutValue((Object)state, 1L, 1L);
                if (!(world.func_175625_s((BlockPos)pos) instanceof TileDepositLevel)) continue;
                int num = ((TileDepositLevel)world.func_175625_s((BlockPos)pos)).num;
                this.states.adjustOrPutValue((Object)state, (long)(num - 1), (long)(num - 1));
            }
        }
    }

    public BlockPos getBlock(int x, int y, int z, int chunkXPos, int chunkZPos) {
        return new BlockPos((chunkXPos << 4) + x, y, (chunkZPos << 4) + z);
    }

    public String func_71517_b() {
        return "denseores_worldgenreport";
    }

    public String func_71518_a(ICommandSender sender) {
        return "denseores_worldgenreport";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_71515_b(final ICommandSender sender, String[] args) throws CommandException {
        if (!sender.func_174792_t_()) {
            return;
        }
        if (args.length == 1) {
            String arg = args[0];
            if ("reset".equals(arg)) {
                this.reset();
                return;
            }
            if ("gen".equals(arg)) {
                WorldServer world = (WorldServer)sender.func_130014_f_();
                BlockPos pos = sender.func_180425_c();
                for (int i = 0; i < 100; ++i) {
                    int x = world.field_73012_v.nextInt(2000) - 1000;
                    int z = world.field_73012_v.nextInt(2000) - 1000;
                    for (int dx = -1; dx <= 1; ++dx) {
                        for (int dz = -1; dz <= 1; ++dz) {
                            world.field_73059_b.func_73158_c(x + dx, z + dz);
                        }
                    }
                    world.field_73059_b.func_73158_c(x, z);
                }
                return;
            }
            if ("fly".equals(arg) && sender instanceof EntityPlayerMP) {
                EntityPlayerMP playerMP = (EntityPlayerMP)sender;
                playerMP.field_71075_bZ.func_75092_a(0.25f);
                playerMP.func_71016_p();
            }
            sender.func_145747_a((IChatComponent)new ChatComponentText("Unrecognized Command"));
            return;
        }
        TObjectLongHashMap<IBlockState> tObjectLongHashMap = this.states;
        synchronized (tObjectLongHashMap) {
            this.states.forEachEntry((TObjectLongProcedure)new TObjectLongProcedure<IBlockState>(){

                public boolean execute(IBlockState a, long b) {
                    sender.func_145747_a((IChatComponent)new ChatComponentText(a + " " + (double)b / (double)WorldGenAnalyser.this.n));
                    return true;
                }
            });
            double k = 0.0;
            for (DenseOre denseOre : DenseOresRegistry.ores.values()) {
                sender.func_145747_a((IChatComponent)new ChatComponentText("Ore " + denseOre.name));
                double t = 0.0;
                IBlockState baseBlockState = denseOre.block.getBaseBlockState();
                if (this.states.containsKey((Object)baseBlockState)) {
                    double v = (double)this.states.get((Object)baseBlockState) / (double)this.n;
                    k += v;
                    t += v;
                    sender.func_145747_a((IChatComponent)new ChatComponentText("Ore " + baseBlockState + " " + v));
                }
                for (IBlockState oreState : denseOre.block.func_176194_O().func_177619_a()) {
                    if (!this.states.containsKey((Object)oreState)) continue;
                    double v = (double)this.states.get((Object)oreState) / (double)this.n;
                    k += v;
                    t += v;
                    sender.func_145747_a((IChatComponent)new ChatComponentText("Ore " + oreState + " " + v));
                }
                sender.func_145747_a((IChatComponent)new ChatComponentText("SubTotal " + t));
            }
            sender.func_145747_a((IChatComponent)new ChatComponentText("Total " + k));
        }
    }
}

