/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.denseores;

import com.rwtema.denseores.DenseOre;
import com.rwtema.denseores.DenseOresRegistry;
import java.io.File;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Loader;

public class DenseOresConfig {
    public static final DenseOresConfig instance = new DenseOresConfig();
    public static final String CATEGORY_BLOCK = "ores.";

    public void loadConfig(File file) {
        Configuration config = new Configuration(file);
        config.load();
        DenseOresRegistry.initVanillaOres();
        for (DenseOre ore : DenseOresRegistry.ores.values()) {
            String cat = CATEGORY_BLOCK + ore.unofficialName;
            config.get(cat, "baseBlock", ore.baseBlock.toString());
            config.get(cat, "baseBlockMeta", ore.metadata);
            if (ore.texture != null) {
                config.get(cat, "baseBlockTexture", ore.texture);
            }
            config.get(cat, "underlyingBlockTexture", ore.underlyingBlockTexture);
            if (ore.rendertype == 0) continue;
            config.get(cat, "renderType", ore.rendertype);
        }
        for (String cat : config.getCategoryNames()) {
            String requiredMod;
            if (!cat.startsWith(CATEGORY_BLOCK)) continue;
            String name = cat.substring(CATEGORY_BLOCK.length());
            if (config.hasKey(cat, "requiredMod") && !(requiredMod = config.get(cat, "requiredMod", "").getString()).equals("") && !"minecraft".equals(requiredMod) && !Loader.isModLoaded((String)requiredMod)) {
                return;
            }
            if (!config.hasKey(cat, "baseBlock")) continue;
            DenseOresRegistry.registerOre(name, new ResourceLocation(config.get(cat, "baseBlock", "").getString().trim()), config.get(cat, "baseBlockMeta", 0).getInt(0), config.get(cat, "underlyingBlockTexture", "blocks/stone").getString().trim(), config.hasKey(cat, "baseBlockTexture") ? config.get(cat, "baseBlockTexture", "").getString().trim() : null, config.get(cat, "retroGenID", 0).getInt(), config.hasKey(cat, "renderType") ? config.get(cat, "renderType", 0).getInt(0) : 0);
        }
        config.save();
    }
}

